/*
 * Decompiled with CFR 0.152.
 */
package de.ilias;

import de.ilias.services.rpc.RPCServer;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.IniFileParser;
import de.ilias.services.settings.ServerSettings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;

public class ilServer {
    private String version = "4.4.0.1";
    private String[] arguments;
    private String command;
    private static final Logger logger = Logger.getLogger(ilServer.class);

    public ilServer(String[] args) {
        this.arguments = args;
    }

    public static void main(String[] args) {
        ilServer server = null;
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
        Logger root = Logger.getLogger("org");
        root.setLevel(Level.OFF);
        server = new ilServer(args);
        server.handleRequest();
    }

    private boolean handleRequest() {
        if (this.arguments.length < 1) {
            logger.error(this.getUsage());
            return false;
        }
        if (this.arguments.length == 1) {
            this.command = this.arguments[0];
            if (this.command.compareTo("version") == 0) {
                System.out.println("ILIAS java server version \"" + this.version + "\"");
                return true;
            }
        }
        this.command = this.arguments[1];
        if (this.command.compareTo("start") == 0) {
            if (this.arguments.length != 2) {
                logger.error("Usage: java -jar ilServer.jar PATH_TO_SERVER_INI start");
                return false;
            }
            return this.startServer();
        }
        if (this.command.compareTo("stop") == 0) {
            if (this.arguments.length != 2) {
                logger.error("Usage: java -jar ilServer.jar PATH_TO_SERVER_INI stop");
                return false;
            }
            return this.stopServer();
        }
        if (this.command.compareTo("createIndex") == 0) {
            if (this.arguments.length != 3) {
                logger.error("Usage java -jar ilServer.jar PATH_TO_SERVER_INI createIndex CLIENT_KEY");
                return false;
            }
            return this.createIndexer();
        }
        if (this.command.compareTo("updateIndex") == 0) {
            if (this.arguments.length < 3) {
                logger.error("Usage java -jar ilServer.jar PATH_TO_SERVER_INI updateIndex CLIENT_KEY");
                return false;
            }
            return this.updateIndexer();
        }
        if (this.command.compareTo("search") == 0) {
            if (this.arguments.length != 4) {
                logger.error("Usage java -jar ilServer.jar PATH_TO_SERVER_INI CLIENT_KEY search QUERY_STRING");
                return false;
            }
            return this.startSearch();
        }
        if (this.command.compareTo("status") == 0) {
            if (this.arguments.length != 2) {
                logger.error("Usage java -jar ilServer.jar PATH_TO_SERVER_INI status");
                return false;
            }
            return this.getStatus();
        }
        logger.error(this.getUsage());
        return false;
    }

    private boolean createIndexer() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], true);
            if (!ClientSettings.exists(this.arguments[2])) {
                throw new ConfigurationException("Unknown client given: " + this.arguments[2]);
            }
            XmlRpcClient client = this.initRpcClient();
            Vector<Object> params = new Vector<Object>();
            params.add(this.arguments[2]);
            params.add(false);
            client.execute("RPCIndexHandler.index", params);
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            logger.fatal(e.getMessage());
            System.exit(1);
            return false;
        }
    }

    private boolean updateIndexer() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], true);
            if (!ClientSettings.exists(this.arguments[2])) {
                throw new ConfigurationException("Unknown client given: " + this.arguments[2]);
            }
            XmlRpcClient client = this.initRpcClient();
            Vector<Object> params = new Vector<Object>();
            params.add(this.arguments[2]);
            params.add(true);
            client.execute("RPCIndexHandler.index", params);
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            logger.fatal(e.getMessage());
            System.exit(1);
            return false;
        }
    }

    private boolean startSearch() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], true);
            if (!ClientSettings.exists(this.arguments[2])) {
                throw new ConfigurationException("Unknown client given: " + this.arguments[2]);
            }
            XmlRpcClient client = this.initRpcClient();
            Vector<Object> params = new Vector<Object>();
            params.add(this.arguments[2]);
            params.add(this.arguments[3]);
            params.add(1);
            String response = (String)client.execute("RPCSearchHandler.search", params);
            System.out.println(response);
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            logger.fatal(e.getMessage());
            System.exit(1);
            return false;
        }
    }

    private boolean startServer() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], true);
            XmlRpcClient client = this.initRpcClient();
            try {
                String status = (String)client.execute("RPCAdministration.status", new Vector());
                System.err.println("Server already started. Aborting");
                System.exit(1);
            }
            catch (XmlRpcException e) {
                logger.info("No server running. Starting new instance...");
            }
            ServerSettings settings = ServerSettings.getInstance();
            logger.info("New rpc server");
            RPCServer rpc = RPCServer.getInstance(settings.getHost(), settings.getPort());
            logger.info("Server start");
            rpc.start();
            client = this.initRpcClient();
            client.execute("RPCAdministration.start", new Vector());
            do {
                Thread.sleep(3000L);
            } while (rpc.isAlive());
            rpc.shutdown();
            logger.info("WebServer shutdown. Aborting...");
            return true;
        }
        catch (ConfigurationException e) {
            System.exit(1);
            return false;
        }
        catch (InterruptedException e) {
            logger.error("VM did not allow to sleep. Aborting!");
        }
        catch (XmlRpcException e) {
            System.out.println("Error starting server: " + e);
            System.exit(1);
        }
        catch (IOException e) {
            logger.error("IOException " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("IOException " + e.getMessage());
        }
        catch (Throwable e) {
            logger.error("IOException " + e.getMessage());
        }
        return false;
    }

    private boolean stopServer() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], false);
            XmlRpcClient client = this.initRpcClient();
            client.execute("RPCAdministration.stop", new Vector());
            return true;
        }
        catch (ConfigurationException e) {
            logger.error("Configuration " + e.getMessage());
        }
        catch (XmlRpcException e) {
            logger.error("XMLRPC " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IOException " + e.getMessage());
        }
        return false;
    }

    private boolean getStatus() {
        try {
            IniFileParser parser = new IniFileParser();
            parser.parseServerSettings(this.arguments[0], false);
            ServerSettings settings = ServerSettings.getInstance();
            XmlRpcClient client = this.initRpcClient();
            String status = (String)client.execute("RPCAdministration.status", new Vector());
            System.out.println(status);
            return true;
        }
        catch (ConfigurationException e) {
            logger.error("Configuration " + e.getMessage());
        }
        catch (XmlRpcException e) {
            System.out.println("Stopped");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Stopped");
            System.exit(1);
        }
        return false;
    }

    private String getUsage() {
        return "Usage: java -jar ilServer.jar PATH_TO_SERVER_INI start|stop|createIndex|updateIndex|search PARAMS";
    }

    private XmlRpcClient initRpcClient() throws ConfigurationException, MalformedURLException {
        ServerSettings settings = ServerSettings.getInstance();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(settings.getServerUrl()));
        config.setConnectionTimeout(10000);
        config.setReplyTimeout(0);
        XmlRpcClient client = new XmlRpcClient();
        client.setTransportFactory(new XmlRpcCommonsTransportFactory(client));
        client.setConfig(config);
        return client;
    }
}

