/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.db;

import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import de.ilias.services.settings.ServerSettings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.OraclePreparedStatement;
import org.apache.log4j.Logger;

public class DBFactory {
    private static Logger logger = Logger.getLogger(DBFactory.class);
    private static String MARIA_DB_CONNECTOR = "jdbc:mariadb://";
    private static ThreadLocal<HashMap<String, PreparedStatement>> ps = new ThreadLocal<HashMap<String, PreparedStatement>>(){

        @Override
        protected HashMap<String, PreparedStatement> initialValue() {
            return new HashMap<String, PreparedStatement>();
        }

        @Override
        public void remove() {
            super.remove();
        }
    };
    private static ThreadLocal<Connection> connection = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            try {
                ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
                ServerSettings server = ServerSettings.getInstance();
                logger.info("+++++++++++++++++++++++++++++++++++++++++++ New Thread local " + LocalSettings.getClientKey());
                if (client.getDbType().equalsIgnoreCase("mysql")) {
                    logger.info("Loading maria db driver...");
                    logger.info("Using jdbc url: " + client.getDbUrl() + "/" + client.getDbUser() + "/******?autoReconnect=true");
                    return DriverManager.getConnection(MARIA_DB_CONNECTOR + client.getDbUrl() + "?autoReconnect=true", client.getDbUser(), client.getDbPass());
                }
                if (client.getDbType().equalsIgnoreCase("oracle")) {
                    logger.info("Loading Oracle driver...");
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    if (client.getDbName().length() == 0) {
                        String url = "jdbc:oracle:thin:" + client.getDbUser() + "/" + client.getDbPass() + "@" + client.getDbHost();
                        String log = "jdbc:oracle:thin:" + client.getDbUser() + "/******@" + client.getDbHost();
                        logger.info("Using tnsname.ora: " + log);
                        try {
                            System.setProperty("oracle.net.tns_admin", server.lookupTnsAdmin());
                        }
                        catch (SecurityException e) {
                            logger.error("Cannot connect to database: " + e);
                            return null;
                        }
                        catch (NullPointerException e) {
                            logger.error("No TNS_ADMIN given: " + e);
                            return null;
                        }
                        return DriverManager.getConnection(url);
                    }
                    logger.info("Using URL: " + client.getDbUrl());
                    return DriverManager.getConnection(client.getDbUrl());
                }
                logger.error("Unsupported db type given." + client.getDbType());
                throw new ConfigurationException("Unsupported db type given." + client.getDbType());
            }
            catch (SQLException e) {
                logger.error("Cannot connect to database: " + e);
            }
            catch (ConfigurationException e) {
                logger.error("Cannot connect to database: " + e);
            }
            catch (ClassNotFoundException e) {
                logger.error(e);
                logger.error("Could not load the JDBC driver.");
            }
            return null;
        }

        @Override
        public void remove() {
            super.remove();
        }
    };

    public static Connection factory() throws SQLException {
        logger.debug("====================================== Used cached DB connector.");
        return connection.get();
    }

    public static void init() {
        logger.debug("------------------------------------- Destroying cached DB connector.");
        connection.remove();
        ps.remove();
    }

    public static PreparedStatement getPreparedStatement(String query) throws SQLException {
        if (ps.get().containsKey(query)) {
            logger.debug("Reusing prepared statement: " + query);
            return ps.get().get(query);
        }
        logger.debug("Creating new prepared statement: " + query);
        ps.get().put(query, DBFactory.factory().prepareStatement(query));
        return ps.get().get(query);
    }

    public static void closePreparedStatement(String query) {
        try {
            if (ps.get().containsKey(query)) {
                ps.get().get(query).close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            ps.get().remove(query);
        }
    }

    public static void closeAll() {
        try {
            for (PreparedStatement pst : ps.get().values()) {
                logger.debug("Clossing prepared statement: " + pst.toString());
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    logger.warn("Cannot close prepared statement: " + pst.toString());
                    logger.warn(e);
                }
                catch (Throwable t) {
                    logger.warn(t);
                }
            }
        }
        catch (Throwable t) {
            logger.warn(t);
        }
        finally {
            try {
                connection.get().close();
            }
            catch (Throwable e) {
                logger.error("Cannot release db connection: ", e);
            }
        }
    }

    public static PreparedStatement setString(PreparedStatement ps, int index, String str) throws SQLException {
        try {
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            if (client.getDbType().equals("mysql")) {
                ps.setString(index, str);
                return ps;
            }
            ((OraclePreparedStatement)ps).setFixedCHAR(index, str);
            return ps;
        }
        catch (ConfigurationException e) {
            logger.error(e);
            return ps;
        }
    }

    public static String getString(ResultSet res, String name) throws SQLException {
        try {
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            if (client.getDbType().equals("mysql")) {
                return res.getString(name);
            }
            String ret = res.getString(name);
            if (ret == null) {
                return "";
            }
            return ret.trim();
        }
        catch (ConfigurationException e) {
            logger.error(e);
            return "";
        }
    }

    public static String getCLOB(ResultSet res, String name) throws SQLException {
        if (DBFactory.getDbType().equalsIgnoreCase("mysql")) {
            return DBFactory.getString(res, name);
        }
        return DBFactory.getString(res, name);
    }

    public static String getInt(ResultSet res, String name) throws SQLException {
        return String.valueOf(res.getInt(name));
    }

    public static String getDbType() {
        try {
            return ClientSettings.getInstance(LocalSettings.getClientKey()).getDbType();
        }
        catch (ConfigurationException e) {
            logger.error(e);
            return "";
        }
    }
}

