/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.lucene.index.CommandQueue;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.lucene.search.SearchHolder;
import de.ilias.services.lucene.settings.LuceneSettings;
import de.ilias.services.object.ObjectDefinition;
import de.ilias.services.object.ObjectDefinitionException;
import de.ilias.services.object.ObjectDefinitions;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.LockObtainFailedException;

public class CommandController {
    private static ThreadLocal<CommandController> instance = new ThreadLocal<CommandController>(){

        @Override
        protected CommandController initialValue() {
            try {
                return new CommandController();
            }
            catch (Throwable t) {
                logger.error(t);
                return null;
            }
        }
    };
    private static final int MAX_ELEMENTS = 100;
    protected static Logger logger = Logger.getLogger(CommandController.class);
    private Vector<Integer> finished = new Vector();
    private CommandQueue queue = new CommandQueue();
    private ObjectDefinitions objDefinitions;
    private IndexHolder holder;

    private CommandController(ObjectDefinitions objDefinitions) throws SQLException, CorruptIndexException, LockObtainFailedException, IOException, ConfigurationException {
        this.objDefinitions = objDefinitions;
        this.holder = IndexHolder.getInstance();
        this.holder.init();
        logger.info("New command controller created.");
    }

    public CommandController() throws CorruptIndexException, LockObtainFailedException, SQLException, IOException, ConfigurationException {
        this(ObjectDefinitions.getInstance(ClientSettings.getInstance(LocalSettings.getClientKey()).getAbsolutePath()));
    }

    public static CommandController getInstance() {
        try {
            logger.info("Creating new command controller...");
            return new CommandController();
        }
        catch (Throwable t) {
            logger.error(t);
            return null;
        }
    }

    public void setFinished(Vector<Integer> finished) {
        this.finished = finished;
    }

    public Vector<Integer> getFinished() {
        return this.finished;
    }

    public void initCreate() throws SQLException {
        this.queue.deleteAll();
        this.queue.addAll();
        this.queue.loadFromDb();
    }

    public void initRefresh() throws SQLException, ConfigurationException {
        this.queue.deleteNonIncremental();
        this.queue.addNonIncremental();
        this.queue.loadFromDb();
    }

    public void initObjects(Vector<Integer> objIds) throws SQLException {
        this.queue.loadFromObjectList(objIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        CommandQueueElement currentElement = null;
        int elementCounter = 0;
        try {
            while ((currentElement = this.queue.nextElement()) != null) {
                logger.info("Current element id: " + currentElement.getObjId() + " " + currentElement.getObjType());
                String command = currentElement.getCommand();
                logger.debug("Handling command: " + command + "!");
                if (command.equals("reset")) {
                    this.deleteDocument(currentElement);
                    try {
                        this.addDocument(currentElement);
                    }
                    catch (ObjectDefinitionException e) {
                        logger.warn("Ignoring deprecated object type " + currentElement.getObjType());
                        this.getQueue().deleteCommandsByType(currentElement.getObjType());
                    }
                } else if (command.equals("create")) {
                    try {
                        this.addDocument(currentElement);
                    }
                    catch (ObjectDefinitionException e) {
                        logger.warn("Ignoring deprecated object type " + currentElement.getObjType());
                        this.getQueue().deleteCommandsByType(currentElement.getObjType());
                    }
                } else if (command.equals("update")) {
                    this.deleteDocument(currentElement);
                    try {
                        this.addDocument(currentElement);
                    }
                    catch (ObjectDefinitionException e) {
                        logger.warn("Ignoring deprecated object type " + currentElement.getObjType());
                        this.getQueue().deleteCommandsByType(currentElement.getObjType());
                    }
                } else if (command.equals("delete")) {
                    this.deleteDocument(currentElement);
                }
                this.getFinished().add(currentElement.getObjId());
                if (++elementCounter <= 100) continue;
                CommandController commandController = this;
                synchronized (commandController) {
                    this.queue.setFinished(this.getFinished());
                    this.setFinished(new Vector<Integer>());
                    elementCounter = 0;
                }
            }
            return;
        }
        catch (SQLException e) {
            logger.error(e);
            return;
        }
        catch (CorruptIndexException e) {
            logger.error(e);
            return;
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public synchronized boolean writeToIndex() {
        try {
            logger.info("Writer commit.");
            this.holder.getWriter().commit();
            logger.info("Writer forcing merge...");
            this.holder.getWriter().forceMerge(100);
            logger.info("Writer forced merge");
            this.queue.setFinished(this.getFinished());
            LuceneSettings.writeLastIndexTime();
            SearchHolder.getInstance().getSearcher().getIndexReader().close();
            SearchHolder.getInstance().init();
            return true;
        }
        catch (ConfigurationException e) {
            logger.error("Cannot refresh index reader: " + e);
        }
        catch (CorruptIndexException e) {
            logger.fatal("Index Corrupted. Aborting!" + e);
        }
        catch (IOException e) {
            logger.fatal("Index Corrupted. Aborting!" + e);
        }
        catch (SQLException e) {
            logger.error("Cannot update search_command_queue: " + e);
        }
        return false;
    }

    public synchronized void closeIndex() {
        try {
            logger.info("Closing writer");
            this.holder.getWriter().close();
            logger.info("Writer closed");
            logger.info("Reopening index reader...");
            SearchHolder.getInstance().getSearcher().getIndexReader().close();
            SearchHolder.getInstance().init();
            LuceneSettings.getInstance().refresh();
        }
        catch (ConfigurationException e) {
            logger.error("Cannot close index reader/writer: " + e);
        }
        catch (CorruptIndexException e) {
            logger.fatal("Index Corrupted. Aborting!" + e);
        }
        catch (IOException e) {
            logger.fatal("Index Corrupted. Aborting!" + e);
        }
        catch (SQLException e) {
            logger.error("Cannot update search_command_queue: " + e);
        }
    }

    private void addDocument(CommandQueueElement el) throws CorruptIndexException, ObjectDefinitionException {
        try {
            logger.debug("Adding new document!");
            ObjectDefinition definition = this.objDefinitions.getDefinitionByType(el.getObjType());
            definition.writeDocument(el);
        }
        catch (DocumentHandlerException e) {
            logger.warn(e);
        }
        catch (IOException e) {
            logger.warn(e);
        }
    }

    private void deleteDocument(CommandQueueElement el) throws CorruptIndexException, IOException {
        logger.debug("Deleteing document with objId: " + String.valueOf(el.getObjId()));
        this.holder.getWriter().deleteDocuments(new Term("objId", String.valueOf(el.getObjId())));
    }

    public void setQueue(CommandQueue queue) {
        this.queue = queue;
    }

    public CommandQueue getQueue() {
        return this.queue;
    }
}

