/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandController;
import de.ilias.services.settings.LocalSettings;
import org.apache.log4j.Logger;

public class CommandControllerThread
extends Thread {
    protected Logger logger = Logger.getLogger(CommandControllerThread.class);
    protected String clientKey = null;
    protected CommandController controller = null;

    public CommandControllerThread(String ck, CommandController con) {
        this.clientKey = ck;
        this.controller = con;
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                CommandControllerThread.this.logger.error("Caught uncaught error: " + e);
                try {
                    CommandControllerThread nt = new CommandControllerThread(CommandControllerThread.this.clientKey, CommandControllerThread.this.controller);
                    nt.start();
                    nt.join();
                }
                catch (Exception ex) {
                    CommandControllerThread.this.logger.error("New error " + ex);
                }
            }
        });
    }

    @Override
    public void run() {
        this.logger.info("Started new indexer thread...");
        LocalSettings.setClientKey(this.clientKey);
        DBFactory.init();
        try {
            this.controller.start();
        }
        catch (Exception e) {
            this.logger.error("Cannot start indexer thread: " + e);
            this.interrupt();
        }
        finally {
            DBFactory.closeAll();
        }
    }
}

