/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;

public class DocumentHolder {
    protected static Logger logger = Logger.getLogger(DocumentHolder.class);
    private static ThreadLocal<DocumentHolder> thDocumentHolder = new ThreadLocal<DocumentHolder>(){

        @Override
        protected DocumentHolder initialValue() {
            return new DocumentHolder();
        }
    };
    private Document globalDoc = null;
    private Document doc = null;

    private DocumentHolder() {
        this.newGlobalDocument();
        this.newDocument();
    }

    public static DocumentHolder factory() {
        return thDocumentHolder.get();
    }

    public Document newGlobalDocument() {
        this.globalDoc = new Document();
        this.globalDoc.add(new StringField("docType", "combined", Field.Store.YES));
        return this.globalDoc;
    }

    public Document newDocument() {
        this.doc = new Document();
        this.doc.add(new StringField("docType", "separated", Field.Store.YES));
        return this.doc;
    }

    public Document getGlobalDocument() {
        return this.globalDoc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void add(String name, String value, boolean isGlobal, Field.Store store, boolean indexed) {
        if (indexed) {
            this.getDocument().add(new TextField(name, value, store));
        } else {
            this.getDocument().add(new StringField(name, value, store));
        }
        if (isGlobal) {
            if (indexed) {
                this.getGlobalDocument().add(new TextField(name, value, store));
            } else {
                this.getGlobalDocument().add(new StringField(name, value, store));
            }
        }
    }
}

