/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.settings.LocalSettings;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FieldInfo {
    protected static Logger logger = Logger.getLogger(FieldInfo.class);
    private static HashMap<String, FieldInfo> instances = new HashMap();
    private Vector<String> fields = new Vector();

    protected FieldInfo() {
        this.initDefaultFields();
    }

    protected static FieldInfo getInstance() {
        return FieldInfo.getInstance(LocalSettings.getClientKey());
    }

    public static FieldInfo getInstance(String clientKey) {
        if (instances.containsKey(clientKey)) {
            return instances.get(clientKey);
        }
        instances.put(clientKey, new FieldInfo());
        return instances.get(clientKey);
    }

    public void addField(String field) {
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public Vector<String> getFields() {
        return this.fields;
    }

    public String[] getFieldsAsStringArray() {
        return this.fields.toArray(new String[0]);
    }

    public int getFieldSize() {
        return this.fields.size();
    }

    protected void initDefaultFields() {
        this.addField("title");
        this.addField("description");
        this.addField("lomKeyword");
        this.addField("metaData");
        this.addField("tag");
        this.addField("propertyHigh");
        this.addField("propertyMedium");
        this.addField("propertyLow");
        this.addField("content");
    }
}

