/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.lucene.index.IndexDirectoryFactory;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import de.ilias.services.settings.ServerSettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;

public class IndexHolder {
    protected static Logger logger = Logger.getLogger(IndexHolder.class);
    public static final int MAX_NUM_SEGMENTS = 100;
    private static HashMap<String, IndexHolder> instances = new HashMap();
    private ClientSettings settings;
    private IndexWriter writer;

    private IndexHolder(String clientKey) throws IOException {
        try {
            this.settings = ClientSettings.getInstance(clientKey);
        }
        catch (ConfigurationException e) {
            throw new IOException("Caught configuration exception: " + e.getMessage());
        }
    }

    public static synchronized IndexHolder getInstance(String clientKey) throws IOException {
        String hash = clientKey;
        if (instances.containsKey(hash)) {
            return instances.get(hash);
        }
        instances.put(hash, new IndexHolder(clientKey));
        return instances.get(hash);
    }

    public static synchronized IndexHolder getInstance() throws IOException {
        return IndexHolder.getInstance(LocalSettings.getClientKey());
    }

    public static void deleteIndex() throws ConfigurationException {
        File indexPath = ClientSettings.getInstance(LocalSettings.getClientKey()).getIndexPath();
        IndexHolder.deleteTree(indexPath);
        logger.info("Deleted index directory: " + indexPath.getAbsoluteFile());
    }

    private static boolean deleteTree(File path) {
        if (!path.exists() || !path.isDirectory()) {
            return false;
        }
        for (File del : path.listFiles()) {
            if (del.isDirectory()) {
                IndexHolder.deleteTree(del);
                continue;
            }
            del.delete();
        }
        path.delete();
        return true;
    }

    public static synchronized void closeAllWriters() {
        logger.info("Closing document writers...");
        for (String key : instances.keySet()) {
            try {
                logger.info("Closing writer: " + key);
                IndexHolder holder = instances.get(key);
                IndexDirectoryFactory.getDirectory(ClientSettings.getInstance(key).getIndexPath()).close();
                holder.close();
            }
            catch (ConfigurationException | IOException ex) {
                logger.error("Cannot close fs directory: " + ex.getMessage());
            }
        }
        logger.info("Index writers closed.");
    }

    public void init() throws IOException, ConfigurationException {
        logger.debug("Adding new separated index for " + LocalSettings.getClientKey());
        IndexWriterConfig writerConfig = new IndexWriterConfig(new StandardAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND).setRAMBufferSizeMB(ServerSettings.getInstance().getRAMSize());
        this.writer = new IndexWriter(IndexDirectoryFactory.getDirectory(this.settings.getIndexPath()), writerConfig);
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IndexWriter writer) {
        this.writer = writer;
    }

    public void close() {
        try {
            this.getWriter().close();
            IndexDirectoryFactory.getDirectory(this.settings.getIndexPath()).close();
        }
        catch (CorruptIndexException e) {
            logger.fatal("Index corrupted." + e);
        }
        catch (IOException e) {
            logger.fatal("Error closing writer." + e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

