/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file;

import de.ilias.services.lucene.index.file.FileHandlerException;
import de.ilias.services.lucene.index.file.JTidyHTMLHandler;
import de.ilias.services.lucene.index.file.OpenOfficeDefaultHandler;
import de.ilias.services.lucene.index.file.PDFBoxPDFHandler;
import de.ilias.services.lucene.index.file.PlainTextHandler;
import de.ilias.services.lucene.index.file.RTFHandler;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.ServerSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ExtensionFileHandler {
    protected static Logger logger = Logger.getLogger(ExtensionFileHandler.class);

    public String getContent(File file, String extension) throws FileHandlerException {
        if (!file.canRead()) {
            throw new FileHandlerException("No permission to read file: " + file.getAbsolutePath());
        }
        if (!this.checkFileSizeLimit(file)) {
            throw new FileHandlerException("File size limit exceeded. Ignoring file " + file.getAbsolutePath());
        }
        logger.info("Current file is: " + file.getAbsolutePath());
        try {
            String fname = file.getName();
            int dotIndex = fname.lastIndexOf(".");
            if (extension.length() == 0 && dotIndex > 0 && dotIndex < fname.length()) {
                extension = fname.substring(dotIndex + 1, fname.length());
            }
            if (extension.equalsIgnoreCase("")) {
                logger.warn("no valid extension found for: " + file.getName());
                return "";
            }
            if (extension.equalsIgnoreCase("xlsx")) {
                logger.info("Ignoring xslx: " + file.getName());
                return "";
            }
            if (extension.equalsIgnoreCase("pdf")) {
                logger.info("Using getPDFDocument() for " + file.getName());
                return this.getPDFDocument(file);
            }
            if (extension.equalsIgnoreCase("html") || extension.equalsIgnoreCase("htm")) {
                logger.info("Using getHTMLDocument() for " + file.getName());
                return this.getHTMLDocument(file);
            }
            if (extension.equalsIgnoreCase("txt") || extension.length() == 0) {
                logger.info("Using getTextDocument() for: " + file.getName());
                return this.getTextDocument(file);
            }
            if (extension.equalsIgnoreCase("odt")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("ott")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("stw")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("sxw")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("odg")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("odp")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("sti")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("sxd")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("sxw")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("fodt")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getFlatOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("fodp")) {
                logger.info("Using getOpenOfficeDocument() for " + file.getName());
                return this.getFlatOpenOfficeDocument(file);
            }
            if (extension.equalsIgnoreCase("rtf")) {
                logger.info("Using getRTFDocument() for " + file.getName());
                return this.getRTFDocument(file);
            }
        }
        catch (FileHandlerException e) {
            logger.warn("Parsing failed with message: " + e);
            return "";
        }
        catch (Exception e) {
            logger.warn("Parsing failed with message: " + e);
            return "";
        }
        return this.tryPOIDocument(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tryPOIDocument(File file) {
        FileInputStream fis = null;
        try {
            StringBuilder content = new StringBuilder();
            POITextExtractor extractor = null;
            fis = new FileInputStream(file);
            extractor = ExtractorFactory.createExtractor(fis);
            content.append(extractor.getText());
            if (content.length() > 0) {
                logger.info("Parsed file: " + file.getName());
            } else {
                logger.warn("No content found for" + file.getName());
            }
            String string = content.toString();
            return string;
        }
        catch (InvalidFormatException e) {
            logger.info("File is not a compatible POI file.");
            logger.info("Current file is: " + file.getAbsolutePath());
        }
        catch (IllegalArgumentException e) {
            logger.info("No handler found.");
            logger.info("Current file is: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            logger.warn("Parsing failed with message: " + e);
            logger.info("Current file is: " + file.getAbsolutePath());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {}
        }
        return "";
    }

    private String getTextDocument(File file) throws FileHandlerException {
        FileInputStream fis = null;
        PlainTextHandler doch = new PlainTextHandler();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.getContent(fis);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("Cannot find file: " + file.getAbsolutePath());
        }
        catch (FileHandlerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getPDFDocument(File file) throws FileHandlerException {
        PDFBoxPDFHandler doch = new PDFBoxPDFHandler();
        FileInputStream fis = null;
        logger.debug("Start PDFBoxPDFHandler...");
        try {
            logger.debug(file.getAbsolutePath());
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.getContent(fis);
            return string;
        }
        catch (IOException e) {
            throw new FileHandlerException("Caught unknown exception " + e.getMessage());
        }
        catch (FileHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileHandlerException("Caught unknown exception " + e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getHTMLDocument(File file) throws FileHandlerException {
        FileInputStream fis = null;
        JTidyHTMLHandler doch = new JTidyHTMLHandler();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.getContent(fis);
            return string;
        }
        catch (FileHandlerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getOpenOfficeDocument(File file) throws FileHandlerException {
        FileInputStream fis = null;
        OpenOfficeDefaultHandler doch = new OpenOfficeDefaultHandler();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.getContent(fis);
            return string;
        }
        catch (IOException e) {
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getFlatOpenOfficeDocument(File file) throws FileHandlerException {
        FileInputStream fis = null;
        OpenOfficeDefaultHandler doch = new OpenOfficeDefaultHandler();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.extractContent(fis);
            return string;
        }
        catch (IOException e) {
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getRTFDocument(File file) throws FileHandlerException {
        FileInputStream fis = null;
        RTFHandler doch = new RTFHandler();
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            String string = doch.getContent(fis);
            return string;
        }
        catch (IOException e) {
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean checkFileSizeLimit(File file) {
        long maxFileSize = 0L;
        try {
            maxFileSize = ServerSettings.getInstance().getMaxFileSize();
        }
        catch (ConfigurationException e) {
            maxFileSize = 524288000L;
        }
        if (file.length() > maxFileSize) {
            logger.info("File size is " + file.length() + " bytes.");
            return false;
        }
        return true;
    }
}

