/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file;

import de.ilias.services.lucene.index.file.FileHandler;
import de.ilias.services.lucene.index.file.FileHandlerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class JTidyHTMLHandler
implements FileHandler {
    protected Logger logger = Logger.getLogger(JTidyHTMLHandler.class);
    private Tidy tidy;

    @Override
    public String getContent(InputStream is) throws FileHandlerException, IOException {
        StringBuilder builder = new StringBuilder();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.tidy = new Tidy();
        this.tidy.setErrout(new PrintWriter(new ByteArrayOutputStream()));
        this.tidy.setQuiet(true);
        this.tidy.setShowWarnings(false);
        Document root = this.tidy.parseDOM(is, bout);
        Element rawDoc = root.getDocumentElement();
        String title = this.getTitle(rawDoc);
        String body = this.getBody(rawDoc);
        if (title != null && !title.equals("")) {
            builder.append(title);
        }
        if (body != null && !body.equals("")) {
            builder.append(body);
        }
        if (bout != null) {
            try {
                bout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    @Override
    public InputStream transformStream(InputStream is) {
        return null;
    }

    private String getTitle(Element rawDoc) {
        Element titleElement;
        Text text;
        if (rawDoc == null) {
            return null;
        }
        String title = "";
        NodeList children = rawDoc.getElementsByTagName("title");
        if (children.getLength() > 0 && (text = (Text)(titleElement = (Element)children.item(0)).getFirstChild()) != null) {
            title = text.getData();
        }
        return title;
    }

    private String getBody(Element rawDoc) {
        if (rawDoc == null) {
            return null;
        }
        String body = "";
        NodeList children = rawDoc.getElementsByTagName("body");
        if (children.getLength() > 0) {
            body = this.getText(children.item(0));
        }
        return body;
    }

    private String getText(Node node) {
        NodeList children = node.getChildNodes();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    sb.append(this.getText(child));
                    sb.append(" ");
                    continue block4;
                }
                case 3: {
                    sb.append(((Text)child).getData());
                }
            }
        }
        return sb.toString();
    }
}

