/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file;

import de.ilias.services.lucene.index.file.FileHandlerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public abstract class ZipBasedOfficeHandler {
    protected static Logger logger = Logger.getLogger(ZipBasedOfficeHandler.class);
    protected static final int BUFFER = 2048;

    protected abstract String getContentFileName();

    protected abstract String getXPath();

    protected InputStream extractContentStream(InputStream is) throws FileHandlerException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(is);
            while ((entry = zip.getNextEntry()) != null) {
                int count;
                if (!entry.getName().equalsIgnoreCase(this.getContentFileName())) continue;
                byte[] data = new byte[2048];
                while ((count = zip.read(data, 0, 2048)) != -1) {
                    bout.write(data, 0, count);
                }
                break block10;
            }
            is.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
        catch (ZipException e) {
            logger.info("Cannot extract " + this.getContentFileName() + " " + e.getMessage());
            throw new FileHandlerException(e);
        }
        catch (IOException e) {
            logger.info("Cannot extract " + this.getContentFileName() + " " + e.getMessage());
            throw new FileHandlerException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String extractContent(InputStream is) {
        SAXBuilder builder = new SAXBuilder();
        StringBuilder content = new StringBuilder();
        try {
            Document doc = builder.build(is);
            XPath xpath = XPath.newInstance(this.getXPath());
            List res = xpath.selectNodes(doc);
            for (Object element : res) {
                Element el = (Element)element;
                content.append(" ");
                content.append(el.getTextTrim());
            }
            return content.toString();
        }
        catch (NullPointerException e) {
            logger.warn("Caught NullPointerException: " + e);
        }
        catch (JDOMException e) {
            logger.info("Cannot parse OO content: " + e);
        }
        catch (IOException e) {
            logger.info("Cannot parse OO content: " + e);
        }
        return "";
    }
}

