/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file.path;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.file.path.FileObjectPathCreator;
import de.ilias.services.lucene.index.file.path.PathCreator;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class FileObjectPathCreator7
implements PathCreator {
    private static final Logger logger = Logger.getLogger(FileObjectPathCreator.class);
    protected String basePath = "storage";
    protected static final String BIN_NAME = "data";

    public void setBasePath(String bp) {
        this.basePath = bp;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public File buildFile(CommandQueueElement el, ResultSet res) throws PathCreatorException {
        int objId = el.getObjId();
        StringBuilder fullPath = new StringBuilder();
        StringBuilder versionPath = new StringBuilder();
        try {
            int versionCode = 1;
            int resVersion = res.getInt("version");
            if (resVersion > 0) {
                versionCode = resVersion;
            }
            String rid = res.getString("rid");
            String resourcePath = "";
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getDataDirectory().getAbsolutePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getClient());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(this.getBasePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(rid.replaceAll("-", System.getProperty("file.separator")));
            versionPath.append((CharSequence)fullPath);
            versionPath.append(System.getProperty("file.separator"));
            versionPath.append(String.valueOf(versionCode));
            versionPath.append(System.getProperty("file.separator"));
            versionPath.append(BIN_NAME);
            logger.info("Detected file object path is: " + versionPath.toString());
            File file = new File(versionPath.toString());
            if (file.exists() && file.canRead()) {
                return file;
            }
            return null;
        }
        catch (ConfigurationException e) {
            throw new PathCreatorException(e);
        }
        catch (SQLException e) {
            throw new PathCreatorException(e);
        }
        catch (NullPointerException e) {
            throw new PathCreatorException(e);
        }
    }

    @Override
    public File buildFile(CommandQueueElement el) throws PathCreatorException {
        return this.buildFile(el, null);
    }

    @Override
    public String getExtension(CommandQueueElement el, ResultSet res) {
        StringBuilder extension = new StringBuilder();
        try {
            String fileName = res.getString("file_name");
            int dotIndex = fileName.lastIndexOf(".");
            if (dotIndex > 0 && dotIndex < fileName.length()) {
                extension.append(fileName.substring(dotIndex + 1, fileName.length()));
            }
            logger.info("Extraced extension: " + extension.toString() + " from file name: " + fileName);
        }
        catch (SQLException ex) {
            logger.error(ex.toString());
        }
        return extension.toString();
    }
}

