/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file.path;

import java.util.Vector;
import org.apache.log4j.Logger;

public class PathUtils {
    protected static final int FACTOR = 100;
    protected static final int MAX_EXPONENT = 3;
    protected static Logger logger = Logger.getLogger(PathUtils.class);

    public static String buildSplittedPathFromId(int objId) {
        int i;
        boolean found = false;
        int num = objId;
        Vector<String> path = new Vector<String>();
        StringBuilder pathString = new StringBuilder();
        for (i = 3; i > 0; --i) {
            int tmp = 0;
            int factor = (int)Math.pow(100.0, i);
            tmp = num / factor;
            if (tmp == 0 && !found) continue;
            path.add(String.valueOf(tmp));
            num %= factor;
            found = true;
        }
        for (i = 0; i < path.size(); ++i) {
            pathString.append((String)path.get(i));
            pathString.append(System.getProperty("file.separator"));
        }
        return pathString.toString();
    }

    public static String buildSplittedPathFromId(int objId, String name) {
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(PathUtils.buildSplittedPathFromId(objId));
        if (fullPath.length() == 0) {
            return "";
        }
        fullPath.append(name);
        fullPath.append('_');
        fullPath.append(String.valueOf(objId));
        fullPath.append(System.getProperty("file.separator"));
        return fullPath.toString();
    }

    public static String buildVersionDirectory(int version) {
        StringBuilder directoryName = new StringBuilder();
        if (version < 10) {
            directoryName.append("00");
            directoryName.append(String.valueOf(version));
            return directoryName.toString();
        }
        if (version < 100) {
            directoryName.append("0");
            directoryName.append(String.valueOf(version));
            return directoryName.toString();
        }
        directoryName.append(String.valueOf(version));
        return directoryName.toString();
    }
}

