/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search;

import de.ilias.services.lucene.index.FieldInfo;
import de.ilias.services.lucene.index.FieldInfoUser;
import de.ilias.services.lucene.search.QueryRewriter;
import de.ilias.services.lucene.search.SearchHolder;
import de.ilias.services.lucene.search.SearchResultWriter;
import de.ilias.services.lucene.search.highlight.HitHighlighter;
import de.ilias.services.lucene.settings.LuceneSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;

public class RPCSearchHandler {
    Logger logger = Logger.getLogger(RPCSearchHandler.class);

    public String search(String clientKey, String queryString, int pageNumber) {
        LocalSettings.setClientKey(clientKey);
        this.logger.info("Query is: " + queryString);
        try {
            long start = new Date().getTime();
            FieldInfo fieldInfo = FieldInfo.getInstance(LocalSettings.getClientKey());
            LuceneSettings luceneSettings = LuceneSettings.getInstance(LocalSettings.getClientKey());
            IndexSearcher searcher = SearchHolder.getInstance().getSearcher();
            QueryRewriter rewriter = new QueryRewriter(1, queryString);
            String rewrittenQuery = rewriter.rewrite();
            Vector<BooleanClause.Occur> occurs = new Vector<BooleanClause.Occur>();
            for (int i = 0; i < fieldInfo.getFieldSize(); ++i) {
                occurs.add(BooleanClause.Occur.SHOULD);
            }
            MultiFieldQueryParser multiParser = new MultiFieldQueryParser(fieldInfo.getFieldsAsStringArray(), (Analyzer)new StandardAnalyzer());
            multiParser.setAllowLeadingWildcard(luceneSettings.isPrefixWildcardQueryEnabled());
            if (luceneSettings.getDefaultOperator() == 1) {
                multiParser.setDefaultOperator(QueryParser.Operator.AND);
            } else {
                multiParser.setDefaultOperator(QueryParser.Operator.OR);
            }
            BooleanQuery.setMaxClauseCount(10000);
            BooleanQuery query = (BooleanQuery)multiParser.parse(rewrittenQuery);
            this.logger.info("Max clauses allowed: " + BooleanQuery.getMaxClauseCount());
            for (String f : fieldInfo.getFields()) {
                this.logger.info(f.toString());
            }
            TopScoreDocCollector collector = TopScoreDocCollector.create(1000);
            long s_start = new Date().getTime();
            searcher.search((Query)query, collector);
            long s_end = new Date().getTime();
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            SearchResultWriter writer = new SearchResultWriter(hits);
            writer.setOffset(SearchHolder.SEARCH_LIMIT * (pageNumber - 1));
            writer.write();
            long end = new Date().getTime();
            this.logger.info("Total time: " + (end - start));
            this.logger.info("Query time: " + (s_end - s_start));
            this.logger.info("Num hits: " + collector.topDocs().totalHits);
            return writer.toXML();
        }
        catch (ConfigurationException e) {
            this.logger.error(e);
        }
        catch (IOException e) {
            this.logger.warn(e);
        }
        catch (ParseException e) {
            this.logger.info(e);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        return "";
    }

    public String searchUsers(String clientKey, String queryString) {
        LocalSettings.setClientKey(clientKey);
        try {
            long start = new Date().getTime();
            FieldInfoUser fieldInfo = FieldInfoUser.getInstance(LocalSettings.getClientKey());
            LuceneSettings luceneSettings = LuceneSettings.getInstance();
            QueryRewriter rewriter = new QueryRewriter(4, queryString);
            String rewrittenQuery = rewriter.rewrite();
            IndexSearcher searcher = SearchHolder.getInstance().getSearcher();
            Vector<BooleanClause.Occur> occurs = new Vector<BooleanClause.Occur>();
            for (int i = 0; i < fieldInfo.getFieldSize(); ++i) {
                occurs.add(BooleanClause.Occur.SHOULD);
            }
            MultiFieldQueryParser multiParser = new MultiFieldQueryParser(fieldInfo.getFieldsAsStringArray(), (Analyzer)new StandardAnalyzer());
            multiParser.setAllowLeadingWildcard(luceneSettings.isPrefixWildcardQueryEnabled());
            if (luceneSettings.getDefaultOperator() == 1) {
                multiParser.setDefaultOperator(QueryParser.Operator.AND);
            } else {
                multiParser.setDefaultOperator(QueryParser.Operator.OR);
            }
            BooleanQuery.setMaxClauseCount(10000);
            BooleanQuery query = (BooleanQuery)multiParser.parse(rewrittenQuery);
            this.logger.info("Max clauses allowed: " + BooleanQuery.getMaxClauseCount());
            this.logger.info("Rewritten query is: " + query.toString());
            TopScoreDocCollector collector = TopScoreDocCollector.create(1000);
            searcher.search((Query)query, collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            long h_start = new Date().getTime();
            HitHighlighter hh = new HitHighlighter(query, hits);
            hh.highlight();
            long h_end = new Date().getTime();
            long end = new Date().getTime();
            this.logger.info("Highlighter time: " + (h_end - h_start));
            this.logger.info("Total time: " + (end - start));
            return hh.toXML();
        }
        catch (IOException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.fatal(writer.toString());
        }
        catch (ConfigurationException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.fatal(writer.toString());
        }
        catch (ParseException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.fatal(writer.toString());
        }
        catch (SQLException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.fatal(writer.toString());
        }
        catch (InvalidTokenOffsetsException ex) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            this.logger.fatal(writer.toString());
        }
        return "";
    }

    public String highlight(String clientKey, Vector<Integer> objIds, String queryString) {
        LocalSettings.setClientKey(clientKey);
        try {
            FieldInfo fieldInfo = FieldInfo.getInstance(LocalSettings.getClientKey());
            LuceneSettings luceneSettings = LuceneSettings.getInstance(LocalSettings.getClientKey());
            long start = new Date().getTime();
            QueryRewriter rewriter = new QueryRewriter(2, queryString);
            String rewrittenQuery = rewriter.rewrite(objIds);
            this.logger.info("Searching for: " + rewrittenQuery);
            IndexSearcher searcher = SearchHolder.getInstance().getSearcher();
            Vector<BooleanClause.Occur> occurs = new Vector<BooleanClause.Occur>();
            for (int i = 0; i < fieldInfo.getFieldSize(); ++i) {
                occurs.add(BooleanClause.Occur.SHOULD);
            }
            MultiFieldQueryParser multi = new MultiFieldQueryParser(fieldInfo.getFieldsAsStringArray(), (Analyzer)new StandardAnalyzer());
            multi.setAllowLeadingWildcard(luceneSettings.isPrefixWildcardQueryEnabled());
            multi.setDefaultOperator(QueryParser.Operator.OR);
            Query query = searcher.rewrite(MultiFieldQueryParser.parse(rewrittenQuery, fieldInfo.getFieldsAsStringArray(), occurs.toArray(new BooleanClause.Occur[0]), (Analyzer)new StandardAnalyzer()));
            this.logger.info("What occurs" + occurs.toString());
            this.logger.info("Rewritten query is: " + query.toString());
            TopScoreDocCollector collector = TopScoreDocCollector.create(1000);
            searcher.search(query, collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            long h_start = new Date().getTime();
            HitHighlighter hh = new HitHighlighter(query, hits);
            hh.highlight();
            long h_end = new Date().getTime();
            long end = new Date().getTime();
            this.logger.info("Highlighter time: " + (h_end - h_start));
            this.logger.info("Total time: " + (end - start));
            this.logger.info("Num hits: " + collector.topDocs().totalHits);
            return hh.toXML();
        }
        catch (CorruptIndexException e) {
            this.logger.fatal(e);
        }
        catch (ConfigurationException e) {
            this.logger.error(e);
        }
        catch (ParseException e) {
            this.logger.warn(e);
        }
        catch (IOException e) {
            this.logger.error(e);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        return "";
    }

    public String searchMail(String clientKey, int userId, String queryString, int folderId) {
        LocalSettings.setClientKey(clientKey);
        try {
            FieldInfo fieldInfo = FieldInfo.getInstance(LocalSettings.getClientKey());
            long start = new Date().getTime();
            QueryRewriter rewriter = new QueryRewriter(3, queryString);
            String rewrittenQuery = rewriter.rewrite(userId, folderId);
            this.logger.info("Searching for: " + rewrittenQuery);
            IndexSearcher searcher = SearchHolder.getInstance().getSearcher();
            Vector<BooleanClause.Occur> occurs = new Vector<BooleanClause.Occur>();
            for (int i = 0; i < fieldInfo.getFieldSize(); ++i) {
                occurs.add(BooleanClause.Occur.SHOULD);
            }
            Query query = searcher.rewrite(MultiFieldQueryParser.parse(rewrittenQuery, fieldInfo.getFieldsAsStringArray(), occurs.toArray(new BooleanClause.Occur[0]), (Analyzer)new StandardAnalyzer()));
            this.logger.info("Rewritten query is: " + query.toString());
            TopScoreDocCollector collector = TopScoreDocCollector.create(500);
            searcher.search(query, collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            long h_start = new Date().getTime();
            HitHighlighter hh = new HitHighlighter(query, hits);
            hh.highlight();
            long h_end = new Date().getTime();
            long end = new Date().getTime();
            this.logger.info("Highlighter time: " + (h_end - h_start));
            this.logger.info("Total time: " + (end - start));
            return hh.toXML();
        }
        catch (CorruptIndexException e) {
            this.logger.fatal(e);
        }
        catch (ConfigurationException e) {
            this.logger.error(e);
        }
        catch (ParseException e) {
            this.logger.warn(e);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        return "";
    }
}

