/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search;

import de.ilias.services.lucene.index.IndexDirectoryFactory;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.FSDirectory;

public class SearchHolder {
    public static int SEARCH_LIMIT = 100;
    protected static Logger logger = Logger.getLogger(IndexHolder.class);
    private static HashMap<String, SearchHolder> instances = new HashMap();
    private IndexSearcher searcher = null;

    private SearchHolder() throws ConfigurationException, IOException {
        this.init();
    }

    public void init() throws ConfigurationException, IOException {
        ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
        FSDirectory directory = IndexDirectoryFactory.getDirectory(client.getIndexPath());
        DirectoryReader reader = DirectoryReader.open(directory);
        this.searcher = new IndexSearcher(reader);
    }

    public void reInit(IndexWriter writer) throws ConfigurationException, IOException {
        DirectoryReader reader = DirectoryReader.open(writer);
        this.searcher = new IndexSearcher(reader);
    }

    public static synchronized SearchHolder getInstance(String clientKey) throws IOException, ConfigurationException {
        String hash = clientKey;
        if (instances.containsKey(hash)) {
            return instances.get(hash);
        }
        instances.put(hash, new SearchHolder());
        return instances.get(hash);
    }

    public static synchronized SearchHolder getInstance() throws IOException, ConfigurationException {
        return SearchHolder.getInstance(LocalSettings.getClientKey());
    }

    public IndexSearcher getSearcher() {
        return this.searcher;
    }
}

