/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search;

import de.ilias.services.lucene.search.SearchHits;
import de.ilias.services.lucene.search.SearchHolder;
import de.ilias.services.lucene.search.SearchObject;
import de.ilias.services.settings.ConfigurationException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SearchResultWriter {
    protected Logger logger = Logger.getLogger(SearchResultWriter.class);
    private IndexSearcher searcher = null;
    private ScoreDoc[] hits = null;
    private SearchHits result = null;
    private int offset = 0;

    public SearchResultWriter(ScoreDoc[] hits) throws IOException, ConfigurationException {
        this.hits = hits;
        this.searcher = SearchHolder.getInstance().getSearcher();
        this.result = new SearchHits();
    }

    public void write() throws CorruptIndexException, IOException {
        this.result.setTotalHits(this.hits.length);
        this.logger.info("Found " + this.result.getTotalHits() + " hits!");
        this.result.setLimit(SearchHolder.SEARCH_LIMIT);
        for (int i = 0; i < this.hits.length; ++i) {
            if (i == 0) {
                this.result.setMaxScore(this.hits[i].score);
            }
            if (i < this.getOffset()) continue;
            if (i >= this.getOffset() + SearchHolder.SEARCH_LIMIT) {
                this.logger.debug("Reached result limit. Aborting!");
                break;
            }
            try {
                this.logger.debug("Added object");
                SearchObject object = new SearchObject();
                org.apache.lucene.document.Document hitDoc = this.searcher.doc(this.hits[i].doc);
                object.setId(Integer.parseInt(hitDoc.get("objId")));
                object.setAbsoluteScore(this.hits[i].score);
                this.result.addObject(object);
                continue;
            }
            catch (NumberFormatException e) {
                this.logger.warn("Found invalid document (missing objId) with document id: " + this.hits[i].doc);
            }
        }
    }

    public String toXML() {
        Document doc = new Document(this.result.addXML());
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(doc);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }
}

