/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.settings;

import de.ilias.services.db.DBFactory;
import de.ilias.services.settings.LocalSettings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LuceneSettings {
    public static final int OPERATOR_AND = 1;
    public static final int OPERATOR_OR = 2;
    protected static Logger logger = Logger.getLogger(LuceneSettings.class);
    private static HashMap<String, LuceneSettings> instances = new HashMap();
    private int fragmentSize = 30;
    private int numFragments = 3;
    private int defaultOperator = 1;
    private Date lastIndexTime = new Date();
    private int prefixWildcard = 0;

    public LuceneSettings() throws SQLException {
        this.readSettings();
    }

    public static LuceneSettings getInstance() throws SQLException {
        return LuceneSettings.getInstance(LocalSettings.getClientKey());
    }

    public static LuceneSettings getInstance(String clientKey) throws SQLException {
        if (instances.containsKey(clientKey)) {
            return instances.get(clientKey);
        }
        instances.put(clientKey, new LuceneSettings());
        return instances.get(clientKey);
    }

    public boolean refresh() throws SQLException {
        this.readSettings();
        return true;
    }

    public int getFragmentSize() {
        return this.fragmentSize;
    }

    public void setFragmentSize(int fragmentSize) {
        this.fragmentSize = fragmentSize;
    }

    public int getNumFragments() {
        return this.numFragments;
    }

    public void setNumFragments(int numFragments) {
        this.numFragments = numFragments;
    }

    public int getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(int defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public boolean isPrefixWildcardQueryEnabled() {
        return this.prefixWildcard > 0;
    }

    public void enablePrefixWildcardQuery(int stat) {
        this.prefixWildcard = stat;
    }

    public static void writeLastIndexTime() throws SQLException {
        Statement sta = DBFactory.factory().createStatement();
        sta.executeUpdate("DELETE FROM settings WHERE module = 'common' AND keyword = 'lucene_last_index_time'");
        try {
            sta.close();
        }
        catch (SQLException e) {
            logger.warn(e);
        }
        String query = "INSERT INTO settings (value,module,keyword) VALUES (?,?,?) ";
        PreparedStatement pst = DBFactory.getPreparedStatement(query);
        pst.setString(1, String.valueOf(new Date().getTime() / 1000L));
        pst.setString(2, "common");
        pst.setString(3, "lucene_last_index_time");
        pst.executeUpdate();
        DBFactory.closePreparedStatement(query);
    }

    public void setLastIndexTime(Date date) {
        this.lastIndexTime = date;
    }

    public Date getLastIndexTime() {
        return this.lastIndexTime;
    }

    private void readSettings() throws SQLException {
        Statement sta = DBFactory.factory().createStatement();
        ResultSet res = sta.executeQuery("SELECT value FROM settings WHERE module = 'common' AND keyword = 'lucene_default_operator'");
        while (res.next()) {
            this.setDefaultOperator(Integer.parseInt(res.getString("value")));
            logger.info("Default Operator is: " + this.getDefaultOperator());
        }
        res = sta.executeQuery("SELECT value FROM settings WHERE module = 'common' AND keyword = 'lucene_prefix_wildcard'");
        while (res.next()) {
            try {
                if (res.getString("value").length() > 0) {
                    this.enablePrefixWildcardQuery(Integer.parseInt(res.getString("value")));
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Read invalid setting: " + e.getMessage());
                this.enablePrefixWildcardQuery(0);
            }
            logger.info("Prefix wildcard queries enabled: " + (this.isPrefixWildcardQueryEnabled() ? "yes" : "no"));
        }
        res = sta.executeQuery("SELECT value FROM settings WHERE module = 'common' AND keyword = 'lucene_fragment_size'");
        while (res.next()) {
            this.setFragmentSize(Integer.parseInt(res.getString("value")));
            logger.info("Fragment size is: " + this.getFragmentSize());
        }
        res = sta.executeQuery("SELECT value FROM settings WHERE module = 'common' AND keyword = 'lucene_fragment_count'");
        while (res.next()) {
            this.setNumFragments(Integer.parseInt(res.getString("value")));
            logger.info("Number of fragments is: " + this.getNumFragments());
        }
        res = sta.executeQuery("SELECT value FROM settings WHERE module = 'common' AND keyword = 'lucene_last_index_time'");
        while (res.next()) {
            logger.info("Date:" + res.getString("value"));
            Date date = new Date((long)Integer.parseInt(res.getString("value")) * 1000L);
            logger.info(date);
            this.setLastIndexTime(new Date((long)Integer.parseInt(res.getString("value")) * 1000L));
        }
        try {
            sta.close();
            res.close();
        }
        catch (SQLException e) {
            logger.warn(e);
        }
    }
}

