/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.object.DataSource;
import de.ilias.services.object.DirectoryDataSource;
import de.ilias.services.object.FileDataSource;
import de.ilias.services.object.JDBCDataSource;
import de.ilias.services.object.ObjectDefinitionException;
import org.apache.log4j.Logger;

public class DataSourceFactory {
    protected static Logger logger = Logger.getLogger(DataSourceFactory.class);

    public static DataSource factory(int type) throws ObjectDefinitionException {
        switch (type) {
            case 1: {
                return new JDBCDataSource(type);
            }
            case 2: {
                return new FileDataSource(type);
            }
            case 3: {
                return new DirectoryDataSource(type);
            }
        }
        throw new ObjectDefinitionException("Invalid type: " + type);
    }

    public static DataSource factory(String type) throws ObjectDefinitionException {
        logger.info("Type: " + type);
        if (type.equalsIgnoreCase("JDBC")) {
            return DataSourceFactory.factory(1);
        }
        if (type.equalsIgnoreCase("File")) {
            return DataSourceFactory.factory(2);
        }
        if (type.equalsIgnoreCase("Directory")) {
            logger.info("Directory DataSource");
            return DataSourceFactory.factory(3);
        }
        throw new ObjectDefinitionException("Invalid type: " + type);
    }
}

