/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandler;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.DocumentHolder;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.object.DataSource;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DocumentDefinition
implements DocumentHandler {
    protected Logger logger = Logger.getLogger(DocumentDefinition.class);
    private String type;
    private Vector<DataSource> dataSource = new Vector();

    public DocumentDefinition(String type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Vector<DataSource> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Vector<DataSource> dataSource) {
        this.dataSource = dataSource;
    }

    public void addDataSource(DataSource source) {
        this.dataSource.add(source);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Document of type = " + this.getType());
        out.append("\n");
        for (DataSource doc : this.getDataSource()) {
            out.append(((Object)doc).toString());
            out.append("\n");
        }
        return out.toString();
    }

    @Override
    public void writeDocument(CommandQueueElement el) throws DocumentHandlerException, IOException {
        this.writeDocument(el, null);
    }

    @Override
    public void writeDocument(CommandQueueElement el, ResultSet res) throws DocumentHandlerException {
        DocumentHolder doc = DocumentHolder.factory();
        doc.newDocument();
        for (int i = 0; i < this.getDataSource().size(); ++i) {
            try {
                this.getDataSource().get(i).writeDocument(el);
                continue;
            }
            catch (IOException e) {
                this.logger.warn("Cannot parse data source: " + e);
                continue;
            }
            catch (DocumentHandlerException e) {
                this.logger.warn(e);
            }
        }
        try {
            IndexHolder writer = IndexHolder.getInstance();
            if (doc.getDocument() == null) {
                this.logger.warn("Found empty document.");
            } else {
                writer.getWriter().addDocument(doc.getDocument());
            }
        }
        catch (IOException e) {
            this.logger.warn(e);
        }
    }
}

