/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.DocumentHolder;
import de.ilias.services.lucene.index.transform.ContentTransformer;
import de.ilias.services.lucene.index.transform.TransformerFactory;
import de.ilias.services.object.TransformerDefinition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;

public class FieldDefinition {
    protected static Logger logger = Logger.getLogger(FieldDefinition.class);
    public static final int INDEX_NO = 0;
    public static final int INDEX_ANALYZED = 1;
    public static final int INDEX_NOT_ANALYZED = 2;
    private Field.Store store = Field.Store.NO;
    public int indexType = 0;
    private String name;
    private String column;
    private String type = "text";
    private boolean global = false;
    private boolean isDynamic = false;
    Vector<TransformerDefinition> transformers = new Vector();

    public FieldDefinition(String store, String index, String name, String column, String type, String isGlobal, String dynamicName) {
        if (store.equalsIgnoreCase("YES")) {
            this.store = Field.Store.YES;
        }
        if (index.equalsIgnoreCase("NO")) {
            this.indexType = 0;
        } else if (index.equalsIgnoreCase("ANALYZED")) {
            this.indexType = 1;
        } else if (index.equalsIgnoreCase("NOT_ANALYZED")) {
            this.indexType = 2;
        }
        if (isGlobal == null || isGlobal.equalsIgnoreCase("YES")) {
            this.global = true;
        }
        if (dynamicName != null) {
            this.name = dynamicName;
            this.isDynamic = true;
        } else {
            this.name = name;
        }
        this.column = column;
        if (type != null && type.length() != 0) {
            this.type = type;
        }
    }

    public Integer getIndexType() {
        return this.indexType;
    }

    public void setIndexType(int type) {
        this.indexType = type;
    }

    public Field.Store getStore() {
        return this.store;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String parseName(ResultSet res) throws SQLException {
        if (!this.isDynamic) {
            return this.getName();
        }
        if (res != null) {
            String value;
            if (this.getType().equalsIgnoreCase("clob")) {
                value = DBFactory.getCLOB(res, this.getName());
            } else if (this.getType().equalsIgnoreCase("text")) {
                value = DBFactory.getString(res, this.getName());
            } else if (this.getType().equalsIgnoreCase("integer")) {
                value = DBFactory.getInt(res, this.getName());
            } else {
                logger.warn("Unknown type given for Field name: " + this.getName());
                return "";
            }
            if (value != null) {
                logger.debug("Dynamic name value: " + value);
                logger.debug("Dynamic name:" + this.getName());
                return value;
            }
        }
        throw new SQLException("Invalid result set for dynamic field name: " + this.getName());
    }

    public Vector<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Vector<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    public void addTransformer(TransformerDefinition trans) {
        this.transformers.add(trans);
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.getIndexType() + " " + this.getColumn() + " " + this.getName());
        out.append("\n");
        for (TransformerDefinition tr : this.getTransformers()) {
            out.append(((Object)tr).toString());
            out.append("\n");
        }
        return out.toString();
    }

    public void writeDocument(ResultSet res) throws SQLException {
        try {
            String value;
            boolean indexed = false;
            if (this.getType().equalsIgnoreCase("clob")) {
                value = DBFactory.getCLOB(res, this.getColumn());
            } else if (this.getType().equalsIgnoreCase("text")) {
                value = DBFactory.getString(res, this.getColumn());
            } else if (this.getType().equalsIgnoreCase("integer")) {
                value = DBFactory.getInt(res, this.getColumn());
            } else {
                logger.warn("Unknown type given for Field name: " + this.getName());
                return;
            }
            if (value != null && value.length() > 0) {
                String purged = this.callTransformers(value);
                String fieldName = this.parseName(res);
                logger.debug("Found value: " + purged + " for name: " + fieldName);
                if (this.getIndexType().equals(1)) {
                    indexed = true;
                }
                DocumentHolder.factory().add(fieldName, purged, this.isGlobal(), this.store, indexed);
            }
            return;
        }
        catch (NullPointerException e) {
            logger.error("Caught NullPointerException: " + e.getMessage());
            return;
        }
    }

    public void writeDocument(String content) {
        boolean indexed = false;
        if (content != null && content.length() != 0) {
            String purged = this.callTransformers(content);
            if (this.getIndexType().equals(1)) {
                indexed = true;
            }
            DocumentHolder.factory().add(this.getName(), purged, this.isGlobal(), this.store, indexed);
        }
    }

    private String callTransformers(String value) {
        ContentTransformer trans = TransformerFactory.factory("WhitespaceSanitizer");
        value = trans.transform(value);
        for (int i = 0; i < this.getTransformers().size(); ++i) {
            logger.debug(this.getTransformers().get(i).getName());
            trans = TransformerFactory.factory(this.getTransformers().get(i).getName());
            if (trans == null) continue;
            value = trans.transform(value);
        }
        trans = TransformerFactory.factory("TagSanitizer");
        return trans.transform(value);
    }
}

