/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandler;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.DocumentHolder;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.object.DataSource;
import de.ilias.services.object.FieldDefinition;
import de.ilias.services.object.ParameterDefinition;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class JDBCDataSource
extends DataSource {
    String query;
    Vector<ParameterDefinition> parameters = new Vector();

    public JDBCDataSource(int type) {
        super(type);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public PreparedStatement getStatement() throws SQLException {
        return DBFactory.getPreparedStatement(this.getQuery());
    }

    public Vector<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(ParameterDefinition parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("New JDBC Data Source");
        out.append("\n");
        out.append("Query: " + this.getQuery());
        out.append("\n");
        for (ParameterDefinition param : this.getParameters()) {
            out.append(((Object)param).toString());
        }
        out.append(super.toString());
        return out.toString();
    }

    @Override
    public void writeDocument(CommandQueueElement el) throws DocumentHandlerException, IOException {
        this.writeDocument(el, null);
    }

    @Override
    public void writeDocument(CommandQueueElement el, ResultSet parentResult) throws DocumentHandlerException {
        logger.debug("Handling data source: " + this.getType());
        try {
            DocumentHolder doc = DocumentHolder.factory();
            int paramNumber = 1;
            for (ParameterDefinition parameterDefinition : this.getParameters()) {
                parameterDefinition.writeParameter(this.getStatement(), paramNumber++, el, parentResult);
            }
            logger.debug(this.getStatement());
            ResultSet res = this.getStatement().executeQuery();
            while (res.next()) {
                logger.debug("Found new result");
                for (FieldDefinition fieldDefinition : this.getFields()) {
                    fieldDefinition.writeDocument(res);
                }
                for (DataSource dataSource : this.getDataSources()) {
                    ((DocumentHandler)dataSource).writeDocument(el, res);
                }
                if (!this.getAction().equalsIgnoreCase("create")) continue;
                logger.debug("Adding new document...");
                IndexHolder indexHolder = IndexHolder.getInstance();
                indexHolder.getWriter().addDocument(doc.getDocument());
                doc.newDocument();
            }
            try {
                res.close();
            }
            catch (SQLException sQLException) {
                logger.warn("Cannot close result set");
            }
        }
        catch (SQLException e) {
            logger.error("Cannot parse data source.");
            throw new DocumentHandlerException(e);
        }
        catch (IOException e) {
            logger.error("Cannot parse data source.");
            throw new DocumentHandlerException(e);
        }
    }
}

