/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.settings.ConfigurationException;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ObjectDefinitionReader {
    private static Logger logger = Logger.getLogger(ObjectDefinitionReader.class);
    private static HashMap<File, ObjectDefinitionReader> instances = new HashMap();
    public static final String objectPropertyName = "LuceneObjectDefinition.xml";
    public static final String pluginPath = "Customizing/global/plugins";
    private Vector<File> objectPropertyFiles = new Vector();
    File absolutePath;

    private ObjectDefinitionReader(File absolutePath) throws ConfigurationException {
        this.absolutePath = absolutePath;
        this.read();
    }

    public static ObjectDefinitionReader getInstance(File absolutePath) throws ConfigurationException {
        if (instances.containsKey(absolutePath)) {
            logger.debug("Using cached properties.");
            return instances.get(absolutePath);
        }
        instances.put(absolutePath, new ObjectDefinitionReader(absolutePath));
        return instances.get(absolutePath);
    }

    public File getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(File absolutePath) {
        this.absolutePath = absolutePath;
    }

    public Vector<File> getObjectPropertyFiles() {
        return this.objectPropertyFiles;
    }

    private void read() throws ConfigurationException {
        logger.debug("Start reading search index definitions...");
        if (!this.absolutePath.isDirectory()) {
            throw new ConfigurationException("Absolute path required. Path: " + this.absolutePath.getAbsolutePath());
        }
        File start = new File(this.absolutePath.getAbsoluteFile() + System.getProperty("file.separator") + "Modules");
        logger.debug("Start path is : " + start.getAbsoluteFile());
        this.traverse(start);
        File services = new File(this.absolutePath.getAbsoluteFile() + System.getProperty("file.separator") + "Services");
        logger.debug("Start path is : " + start.getAbsoluteFile());
        this.traverse(services);
        File plugin = new File(this.absolutePath.getAbsoluteFile() + System.getProperty("file.separator") + pluginPath);
        logger.debug("Start path is : " + plugin.getAbsoluteFile());
        this.traverse(plugin);
    }

    private void traverse(File dir) {
        if (dir == null) {
            return;
        }
        logger.debug("Start path is : " + dir.getAbsoluteFile());
        File[] entries = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                if (path.isDirectory()) {
                    return !path.getName().equals(".svn");
                }
                if (path.getName().equalsIgnoreCase(ObjectDefinitionReader.objectPropertyName)) {
                    logger.info("Found: " + path.getAbsolutePath());
                    ObjectDefinitionReader.this.objectPropertyFiles.add(path);
                }
                return false;
            }
        });
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            this.traverse(entries[i]);
        }
    }
}

