/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandlerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ParameterDefinition {
    public static final int FORMAT_LIST = 1;
    public static final int TYPE_INT = 1;
    public static final int TYPE_STRING = 2;
    protected Logger logger = Logger.getLogger(ParameterDefinition.class);
    private int format;
    private int type;
    private String value;

    public ParameterDefinition(int format, int type, String value) {
        this.format = format;
        this.type = type;
        this.value = value;
    }

    public ParameterDefinition(String format, String type, String value) {
        if (format.equals("format")) {
            this.format = 1;
        }
        if (type.equals("int")) {
            this.type = 1;
        }
        if (type.equals("string")) {
            this.type = 2;
        }
        this.value = value;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Parameter " + this.format + " " + this.type + " " + this.value);
        out.append("\n");
        return out.toString();
    }

    public void writeParameter(PreparedStatement pst, int index, CommandQueueElement el, ResultSet parentResult) throws SQLException, DocumentHandlerException {
        switch (this.getType()) {
            case 1: {
                this.logger.debug("ID: " + this.getParameterValue(el, parentResult));
                pst.setInt(index, this.getParameterValue(el, parentResult));
                break;
            }
            case 2: {
                this.logger.debug("ID: " + this.getParameterValue(el, parentResult));
                pst.setString(index, this.getParameterString(el, parentResult));
                break;
            }
            default: {
                throw new DocumentHandlerException("Invalid parameter type given. Type " + this.getType());
            }
        }
    }

    private int getParameterValue(CommandQueueElement el, ResultSet parentResult) throws SQLException {
        if (parentResult != null) {
            this.logger.debug("Trying to read parameter from parent result set...");
            try {
                this.logger.debug(parentResult.getInt(this.getValue()));
                return parentResult.getInt(this.getValue());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.getValue().equals("objId")) {
            this.logger.debug(el.getObjId());
            return el.getObjId();
        }
        if (this.getValue().equals("metaObjId")) {
            this.logger.debug(el.getObjId());
            return el.getObjId();
        }
        if (this.getValue().equals("metaRbacId")) {
            this.logger.debug(el.getObjId());
            return el.getObjId();
        }
        return 0;
    }

    private String getParameterString(CommandQueueElement el, ResultSet parentResult) throws SQLException {
        if (parentResult != null) {
            this.logger.debug("Trying to read parameter from parent result set...");
            try {
                this.logger.debug(parentResult.getString(this.getValue()).trim());
                return DBFactory.getString(parentResult, this.getValue());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.getValue().equals("objType")) {
            this.logger.debug(el.getObjType());
            return el.getObjType();
        }
        if (this.getValue().equals("metaType")) {
            this.logger.debug(el.getObjType());
            return el.getObjType();
        }
        return "";
    }
}

