/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.transformation;

import de.ilias.services.transformation.TransformationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.PageSequenceResults;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class FO2PDF {
    private static FO2PDF instance = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private String foString = null;
    private byte[] pdfByteArray = null;
    private FopFactory fopFactory = null;

    public FO2PDF() {
        try {
            URL fopConfigUrl = this.getClass().getResource("/de/ilias/config/fopConfig.xml");
            this.logger.info("Using config uri: " + fopConfigUrl.toURI());
            DefaultConfigurationBuilder config = new DefaultConfigurationBuilder();
            Configuration cfg = config.build(fopConfigUrl.toURI().toString());
            this.fopFactory = FopFactory.newInstance();
            this.fopFactory.setUserConfig(cfg);
            this.fopFactory.getFontManager().deleteCache();
            this.fopFactory.getFontManager().useCache();
        }
        catch (SAXException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
        catch (IOException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
        catch (URISyntaxException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
    }

    public void clearCache() {
        this.fopFactory.getImageManager().getCache().clearCache();
    }

    public static FO2PDF getInstance() {
        if (instance == null) {
            instance = new FO2PDF();
            return instance;
        }
        return instance;
    }

    public void transform() throws TransformationException {
        try {
            this.logger.info("Starting fop transformation...");
            FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Fop fop = this.fopFactory.newFop("application/pdf", foUserAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(this.getFoInputStream());
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
            FormattingResults foResults = fop.getResults();
            List pageSequences = foResults.getPageSequences();
            for (PageSequenceResults pageSequenceResults : pageSequences) {
                this.logger.debug("PageSequenze " + (String.valueOf(pageSequenceResults.getID()).length() > 0 ? pageSequenceResults.getID() : "<no id>") + " generated " + pageSequenceResults.getPageCount() + " pages.");
            }
            this.logger.info("Generated " + foResults.getPageCount() + " pages in total.");
            this.setPdf(out.toByteArray());
        }
        catch (SAXException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
        catch (IOException ex) {
            this.logger.error("Cannot load fop configuration:" + ex);
        }
        catch (TransformerConfigurationException e) {
            this.logger.warn("Configuration exception: " + e);
            throw new TransformationException(e);
        }
        catch (TransformerException e) {
            this.logger.warn("Transformer exception: " + e);
            throw new TransformationException(e);
        }
    }

    public String getFoString() {
        return this.foString;
    }

    public void setFoString(String foString) {
        this.foString = foString;
    }

    public byte[] getPdf() {
        return this.pdfByteArray;
    }

    public void setPdf(byte[] ba) {
        this.pdfByteArray = ba;
    }

    private InputStream getFoInputStream() throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.getFoString().getBytes("utf8"));
    }
}

