/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFFontROS;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CIDKeyedFDSelect;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.IndexData;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.charset.CFFExpertCharset;
import org.apache.fontbox.cff.charset.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.charset.CFFISOAdobeCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;
import org.apache.fontbox.cff.encoding.CFFExpertEncoding;
import org.apache.fontbox.cff.encoding.CFFStandardEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFParser {
    private CFFDataInput input = null;
    private Header header = null;
    private IndexData nameIndex = null;
    private IndexData topDictIndex = null;
    private IndexData stringIndex = null;

    public List<CFFFont> parse(byte[] bytes) throws IOException {
        this.input = new CFFDataInput(bytes);
        this.header = CFFParser.readHeader(this.input);
        this.nameIndex = CFFParser.readIndexData(this.input);
        this.topDictIndex = CFFParser.readIndexData(this.input);
        this.stringIndex = CFFParser.readIndexData(this.input);
        IndexData globalSubrIndex = CFFParser.readIndexData(this.input);
        ArrayList<CFFFont> fonts = new ArrayList<CFFFont>();
        for (int i = 0; i < this.nameIndex.getCount(); ++i) {
            CFFFont font = this.parseFont(i);
            font.setGlobalSubrIndex(globalSubrIndex);
            fonts.add(font);
        }
        return fonts;
    }

    private static Header readHeader(CFFDataInput input) throws IOException {
        Header header = new Header();
        header.major = input.readCard8();
        header.minor = input.readCard8();
        header.hdrSize = input.readCard8();
        header.offSize = input.readOffSize();
        return header;
    }

    private static IndexData readIndexData(CFFDataInput input) throws IOException {
        int count = input.readCard16();
        IndexData index = new IndexData(count);
        if (count == 0) {
            return index;
        }
        int offSize = input.readOffSize();
        for (int i = 0; i <= count; ++i) {
            index.setOffset(i, input.readOffset(offSize));
        }
        int dataSize = index.getOffset(count) - index.getOffset(0);
        index.initData(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            index.setData(i, input.readCard8());
        }
        return index;
    }

    private static DictData readDictData(CFFDataInput input) throws IOException {
        DictData dict = new DictData();
        dict.entries = new ArrayList();
        while (input.hasRemaining()) {
            DictData.Entry entry = CFFParser.readEntry(input);
            dict.entries.add(entry);
        }
        return dict;
    }

    private static DictData.Entry readEntry(CFFDataInput input) throws IOException {
        int b0;
        DictData.Entry entry;
        block3: {
            entry = new DictData.Entry();
            while (true) {
                if ((b0 = input.readUnsignedByte()) >= 0 && b0 <= 21) break block3;
                if (b0 == 28 || b0 == 29) {
                    entry.operands.add(CFFParser.readIntegerNumber(input, b0));
                    continue;
                }
                if (b0 == 30) {
                    entry.operands.add(CFFParser.readRealNumber(input, b0));
                    continue;
                }
                if (b0 < 32 || b0 > 254) break;
                entry.operands.add(CFFParser.readIntegerNumber(input, b0));
            }
            throw new IllegalArgumentException();
        }
        entry.operator = CFFParser.readOperator(input, b0);
        return entry;
    }

    private static CFFOperator readOperator(CFFDataInput input, int b0) throws IOException {
        CFFOperator.Key key = CFFParser.readOperatorKey(input, b0);
        return CFFOperator.getOperator(key);
    }

    private static CFFOperator.Key readOperatorKey(CFFDataInput input, int b0) throws IOException {
        if (b0 == 12) {
            int b1 = input.readUnsignedByte();
            return new CFFOperator.Key(b0, b1);
        }
        return new CFFOperator.Key(b0);
    }

    private static Integer readIntegerNumber(CFFDataInput input, int b0) throws IOException {
        if (b0 == 28) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            return (short)(b1 << 8 | b2);
        }
        if (b0 == 29) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            int b3 = input.readUnsignedByte();
            int b4 = input.readUnsignedByte();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(CFFDataInput input, int b0) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        while (!done) {
            int[] nibbles;
            int b = input.readUnsignedByte();
            block10: for (int nibble : nibbles = new int[]{b / 16, b % 16}) {
                switch (nibble) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        sb.append(nibble);
                        continue block10;
                    }
                    case 10: {
                        sb.append(".");
                        continue block10;
                    }
                    case 11: {
                        sb.append("E");
                        continue block10;
                    }
                    case 12: {
                        sb.append("E-");
                        continue block10;
                    }
                    case 13: {
                        continue block10;
                    }
                    case 14: {
                        sb.append("-");
                        continue block10;
                    }
                    case 15: {
                        done = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        return Double.valueOf(sb.toString());
    }

    private CFFFont parseFont(int index) throws IOException {
        CFFEncoding encoding;
        int encodingId;
        CFFCharset charset;
        int charsetId;
        CFFFont font = null;
        DataInput nameInput = new DataInput(this.nameIndex.getBytes(index));
        String name = nameInput.getString();
        CFFDataInput topDictInput = new CFFDataInput(this.topDictIndex.getBytes(index));
        DictData topDict = CFFParser.readDictData(topDictInput);
        DictData.Entry syntheticBaseEntry = topDict.getEntry("SyntheticBase");
        if (syntheticBaseEntry != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        DictData.Entry rosEntry = topDict.getEntry("ROS");
        if (rosEntry != null) {
            font = new CFFFontROS();
            ((CFFFontROS)font).setRegistry(this.readString(rosEntry.getNumber(0).intValue()));
            ((CFFFontROS)font).setOrdering(this.readString(rosEntry.getNumber(1).intValue()));
            ((CFFFontROS)font).setSupplement(rosEntry.getNumber(2).intValue());
        }
        if (font == null) {
            font = new CFFFont();
        }
        font.setName(name);
        font.addValueToTopDict("version", this.getString(topDict, "version"));
        font.addValueToTopDict("Notice", this.getString(topDict, "Notice"));
        font.addValueToTopDict("Copyright", this.getString(topDict, "Copyright"));
        font.addValueToTopDict("FullName", this.getString(topDict, "FullName"));
        font.addValueToTopDict("FamilyName", this.getString(topDict, "FamilyName"));
        font.addValueToTopDict("Weight", this.getString(topDict, "Weight"));
        font.addValueToTopDict("isFixedPitch", this.getBoolean(topDict, "isFixedPitch", false));
        font.addValueToTopDict("ItalicAngle", this.getNumber(topDict, "ItalicAngle", 0));
        font.addValueToTopDict("UnderlinePosition", this.getNumber(topDict, "UnderlinePosition", -100));
        font.addValueToTopDict("UnderlineThickness", this.getNumber(topDict, "UnderlineThickness", 50));
        font.addValueToTopDict("PaintType", this.getNumber(topDict, "PaintType", 0));
        font.addValueToTopDict("CharstringType", this.getNumber(topDict, "CharstringType", 2));
        font.addValueToTopDict("FontMatrix", this.getArray(topDict, "FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        font.addValueToTopDict("UniqueID", this.getNumber(topDict, "UniqueID", null));
        font.addValueToTopDict("FontBBox", this.getArray(topDict, "FontBBox", Arrays.asList(0, 0, 0, 0)));
        font.addValueToTopDict("StrokeWidth", this.getNumber(topDict, "StrokeWidth", 0));
        font.addValueToTopDict("XUID", this.getArray(topDict, "XUID", null));
        DictData.Entry charStringsEntry = topDict.getEntry("CharStrings");
        int charStringsOffset = charStringsEntry.getNumber(0).intValue();
        this.input.setPosition(charStringsOffset);
        IndexData charStringsIndex = CFFParser.readIndexData(this.input);
        DictData.Entry charsetEntry = topDict.getEntry("charset");
        int n = charsetId = charsetEntry != null ? charsetEntry.getNumber(0).intValue() : 0;
        if (charsetId == 0) {
            charset = CFFISOAdobeCharset.getInstance();
        } else if (charsetId == 1) {
            charset = CFFExpertCharset.getInstance();
        } else if (charsetId == 2) {
            charset = CFFExpertSubsetCharset.getInstance();
        } else {
            this.input.setPosition(charsetId);
            charset = this.readCharset(this.input, charStringsIndex.getCount());
        }
        font.setCharset(charset);
        font.getCharStringsDict().put(".notdef", charStringsIndex.getBytes(0));
        int[] gids = new int[charStringsIndex.getCount()];
        List<CFFCharset.Entry> glyphEntries = charset.getEntries();
        for (int i = 1; i < charStringsIndex.getCount(); ++i) {
            CFFCharset.Entry glyphEntry = glyphEntries.get(i - 1);
            gids[i - 1] = glyphEntry.getSID();
            font.getCharStringsDict().put(glyphEntry.getName(), charStringsIndex.getBytes(i));
        }
        DictData.Entry encodingEntry = topDict.getEntry("Encoding");
        int n2 = encodingId = encodingEntry != null ? encodingEntry.getNumber(0).intValue() : 0;
        if (encodingId == 0 || rosEntry != null) {
            encoding = CFFStandardEncoding.getInstance();
        } else if (encodingId == 1) {
            encoding = CFFExpertEncoding.getInstance();
        } else {
            this.input.setPosition(encodingId);
            encoding = this.readEncoding(this.input, gids);
        }
        font.setEncoding(encoding);
        if (rosEntry != null) {
            DictData.Entry fdArrayEntry = topDict.getEntry("FDArray");
            if (fdArrayEntry == null) {
                throw new IOException("FDArray is missing for a CIDKeyed Font.");
            }
            int fontDictOffset = fdArrayEntry.getNumber(0).intValue();
            this.input.setPosition(fontDictOffset);
            IndexData fdIndex = CFFParser.readIndexData(this.input);
            LinkedList<Map<String, Object>> privateDictionaries = new LinkedList<Map<String, Object>>();
            LinkedList<Map<String, Object>> fontDictionaries = new LinkedList<Map<String, Object>>();
            CFFFontROS fontRos = (CFFFontROS)font;
            for (int i = 0; i < fdIndex.getCount(); ++i) {
                byte[] b = fdIndex.getBytes(i);
                CFFDataInput fontDictInput = new CFFDataInput(b);
                DictData fontDictData = CFFParser.readDictData(fontDictInput);
                LinkedHashMap<String, Object> fontDictMap = new LinkedHashMap<String, Object>();
                fontDictMap.put("FontName", this.getString(fontDictData, "FontName"));
                fontDictMap.put("FontType", this.getNumber(fontDictData, "FontType", 0));
                fontDictMap.put("FontBBox", this.getDelta(fontDictData, "FontBBox", null));
                fontDictMap.put("FontMatrix", this.getDelta(fontDictData, "FontMatrix", null));
                fontDictionaries.add(fontDictMap);
                DictData.Entry privateEntry = fontDictData.getEntry("Private");
                if (privateEntry == null) {
                    throw new IOException("Missing Private Dictionary");
                }
                int privateOffset = privateEntry.getNumber(1).intValue();
                this.input.setPosition(privateOffset);
                int privateSize = privateEntry.getNumber(0).intValue();
                CFFDataInput privateDictData = new CFFDataInput(this.input.readBytes(privateSize));
                DictData privateDict = CFFParser.readDictData(privateDictData);
                LinkedHashMap<String, Object> privDict = new LinkedHashMap<String, Object>();
                privDict.put("BlueValues", this.getDelta(privateDict, "BlueValues", null));
                privDict.put("OtherBlues", this.getDelta(privateDict, "OtherBlues", null));
                privDict.put("FamilyBlues", this.getDelta(privateDict, "FamilyBlues", null));
                privDict.put("FamilyOtherBlues", this.getDelta(privateDict, "FamilyOtherBlues", null));
                privDict.put("BlueScale", this.getNumber(privateDict, "BlueScale", 0.039625));
                privDict.put("BlueShift", this.getNumber(privateDict, "BlueShift", 7));
                privDict.put("BlueFuzz", this.getNumber(privateDict, "BlueFuzz", 1));
                privDict.put("StdHW", this.getNumber(privateDict, "StdHW", null));
                privDict.put("StdVW", this.getNumber(privateDict, "StdVW", null));
                privDict.put("StemSnapH", this.getDelta(privateDict, "StemSnapH", null));
                privDict.put("StemSnapV", this.getDelta(privateDict, "StemSnapV", null));
                privDict.put("ForceBold", this.getBoolean(privateDict, "ForceBold", false));
                privDict.put("LanguageGroup", this.getNumber(privateDict, "LanguageGroup", 0));
                privDict.put("ExpansionFactor", this.getNumber(privateDict, "ExpansionFactor", 0.06));
                privDict.put("initialRandomSeed", this.getNumber(privateDict, "initialRandomSeed", 0));
                privDict.put("defaultWidthX", this.getNumber(privateDict, "defaultWidthX", 0));
                privDict.put("nominalWidthX", this.getNumber(privateDict, "nominalWidthX", 0));
                int localSubrOffset = (Integer)this.getNumber(privateDict, "Subrs", 0);
                if (localSubrOffset == 0) {
                    font.setLocalSubrIndex(new IndexData(0));
                } else {
                    this.input.setPosition(privateOffset + localSubrOffset);
                    font.setLocalSubrIndex(CFFParser.readIndexData(this.input));
                }
                privateDictionaries.add(privDict);
            }
            fontRos.setFontDict(fontDictionaries);
            fontRos.setPrivDict(privateDictionaries);
            DictData.Entry fdSelectEntry = topDict.getEntry("FDSelect");
            int fdSelectPos = fdSelectEntry.getNumber(0).intValue();
            this.input.setPosition(fdSelectPos);
            CIDKeyedFDSelect fdSelect = this.readFDSelect(this.input, charStringsIndex.getCount(), fontRos);
            font.addValueToPrivateDict("defaultWidthX", 1000);
            font.addValueToPrivateDict("nominalWidthX", 0);
            fontRos.setFdSelect(fdSelect);
        } else {
            DictData.Entry privateEntry = topDict.getEntry("Private");
            int privateOffset = privateEntry.getNumber(1).intValue();
            this.input.setPosition(privateOffset);
            int privateSize = privateEntry.getNumber(0).intValue();
            CFFDataInput privateDictData = new CFFDataInput(this.input.readBytes(privateSize));
            DictData privateDict = CFFParser.readDictData(privateDictData);
            font.addValueToPrivateDict("BlueValues", this.getDelta(privateDict, "BlueValues", null));
            font.addValueToPrivateDict("OtherBlues", this.getDelta(privateDict, "OtherBlues", null));
            font.addValueToPrivateDict("FamilyBlues", this.getDelta(privateDict, "FamilyBlues", null));
            font.addValueToPrivateDict("FamilyOtherBlues", this.getDelta(privateDict, "FamilyOtherBlues", null));
            font.addValueToPrivateDict("BlueScale", this.getNumber(privateDict, "BlueScale", 0.039625));
            font.addValueToPrivateDict("BlueShift", this.getNumber(privateDict, "BlueShift", 7));
            font.addValueToPrivateDict("BlueFuzz", this.getNumber(privateDict, "BlueFuzz", 1));
            font.addValueToPrivateDict("StdHW", this.getNumber(privateDict, "StdHW", null));
            font.addValueToPrivateDict("StdVW", this.getNumber(privateDict, "StdVW", null));
            font.addValueToPrivateDict("StemSnapH", this.getDelta(privateDict, "StemSnapH", null));
            font.addValueToPrivateDict("StemSnapV", this.getDelta(privateDict, "StemSnapV", null));
            font.addValueToPrivateDict("ForceBold", this.getBoolean(privateDict, "ForceBold", false));
            font.addValueToPrivateDict("LanguageGroup", this.getNumber(privateDict, "LanguageGroup", 0));
            font.addValueToPrivateDict("ExpansionFactor", this.getNumber(privateDict, "ExpansionFactor", 0.06));
            font.addValueToPrivateDict("initialRandomSeed", this.getNumber(privateDict, "initialRandomSeed", 0));
            font.addValueToPrivateDict("defaultWidthX", this.getNumber(privateDict, "defaultWidthX", 0));
            font.addValueToPrivateDict("nominalWidthX", this.getNumber(privateDict, "nominalWidthX", 0));
            int localSubrOffset = (Integer)this.getNumber(privateDict, "Subrs", 0);
            if (localSubrOffset == 0) {
                font.setLocalSubrIndex(new IndexData(0));
            } else {
                this.input.setPosition(privateOffset + localSubrOffset);
                font.setLocalSubrIndex(CFFParser.readIndexData(this.input));
            }
        }
        return font;
    }

    private String readString(int index) throws IOException {
        if (index >= 0 && index <= 390) {
            return CFFStandardString.getName(index);
        }
        if (index - 391 <= this.stringIndex.getCount()) {
            DataInput dataInput = new DataInput(this.stringIndex.getBytes(index - 391));
            return dataInput.getString();
        }
        return CFFStandardString.getName(0);
    }

    private String getString(DictData dict, String name) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? this.readString(entry.getNumber(0).intValue()) : null;
    }

    private Boolean getBoolean(DictData dict, String name, boolean defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getBoolean(0) : defaultValue;
    }

    private Number getNumber(DictData dict, String name, Number defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? (Number)entry.getNumber(0) : (Number)defaultValue;
    }

    private List<Number> getArray(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private List<Number> getDelta(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private CFFEncoding readEncoding(CFFDataInput dataInput, int[] gids) throws IOException {
        int format = dataInput.readCard8();
        int baseFormat = format & 0x7F;
        if (baseFormat == 0) {
            return this.readFormat0Encoding(dataInput, format, gids);
        }
        if (baseFormat == 1) {
            return this.readFormat1Encoding(dataInput, format, gids);
        }
        throw new IllegalArgumentException();
    }

    private Format0Encoding readFormat0Encoding(CFFDataInput dataInput, int format, int[] gids) throws IOException {
        Format0Encoding encoding = new Format0Encoding();
        encoding.format = format;
        encoding.nCodes = dataInput.readCard8();
        Format0Encoding.access$1302(encoding, new int[encoding.nCodes]);
        for (int i = 0; i < encoding.code.length; ++i) {
            ((Format0Encoding)encoding).code[i] = dataInput.readCard8();
            encoding.register(encoding.code[i], gids[i]);
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private Format1Encoding readFormat1Encoding(CFFDataInput dataInput, int format, int[] gids) throws IOException {
        Format1Encoding encoding = new Format1Encoding();
        encoding.format = format;
        encoding.nRanges = dataInput.readCard8();
        int count = 0;
        Format1Encoding.access$1702(encoding, new Format1Encoding.Range1[encoding.nRanges]);
        for (int i = 0; i < encoding.range.length; ++i) {
            Format1Encoding.Range1 range = new Format1Encoding.Range1();
            range.first = dataInput.readCard8();
            range.nLeft = dataInput.readCard8();
            ((Format1Encoding)encoding).range[i] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                encoding.register(range.first + j, gids[count + j]);
            }
            count += 1 + range.nLeft;
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private void readSupplement(CFFDataInput dataInput, EmbeddedEncoding encoding) throws IOException {
        encoding.nSups = dataInput.readCard8();
        EmbeddedEncoding.access$2202(encoding, new EmbeddedEncoding.Supplement[encoding.nSups]);
        for (int i = 0; i < encoding.supplement.length; ++i) {
            EmbeddedEncoding.Supplement supplement = new EmbeddedEncoding.Supplement();
            supplement.code = dataInput.readCard8();
            supplement.glyph = dataInput.readSID();
            ((EmbeddedEncoding)encoding).supplement[i] = supplement;
        }
    }

    private CIDKeyedFDSelect readFDSelect(CFFDataInput dataInput, int nGlyphs, CFFFontROS ros) throws IOException {
        int format = dataInput.readCard8();
        if (format == 0) {
            return this.readFormat0FDSelect(dataInput, format, nGlyphs, ros);
        }
        if (format == 3) {
            return this.readFormat3FDSelect(dataInput, format, nGlyphs, ros);
        }
        throw new IllegalArgumentException();
    }

    private Format0FDSelect readFormat0FDSelect(CFFDataInput dataInput, int format, int nGlyphs, CFFFontROS ros) throws IOException {
        Format0FDSelect fdselect = new Format0FDSelect(ros);
        fdselect.format = format;
        Format0FDSelect.access$2702(fdselect, new int[nGlyphs]);
        for (int i = 0; i < fdselect.fds.length; ++i) {
            ((Format0FDSelect)fdselect).fds[i] = dataInput.readCard8();
        }
        return fdselect;
    }

    private Format3FDSelect readFormat3FDSelect(CFFDataInput dataInput, int format, int nGlyphs, CFFFontROS ros) throws IOException {
        Format3FDSelect fdselect = new Format3FDSelect(ros);
        fdselect.format = format;
        fdselect.nbRanges = dataInput.readCard16();
        Format3FDSelect.access$3102(fdselect, new Range3[fdselect.nbRanges]);
        for (int i = 0; i < fdselect.nbRanges; ++i) {
            Range3 r3 = new Range3();
            r3.first = dataInput.readCard16();
            r3.fd = dataInput.readCard8();
            ((Format3FDSelect)fdselect).range3[i] = r3;
        }
        fdselect.sentinel = dataInput.readCard16();
        return fdselect;
    }

    private CFFCharset readCharset(CFFDataInput dataInput, int nGlyphs) throws IOException {
        int format = dataInput.readCard8();
        if (format == 0) {
            return this.readFormat0Charset(dataInput, format, nGlyphs);
        }
        if (format == 1) {
            return this.readFormat1Charset(dataInput, format, nGlyphs);
        }
        if (format == 2) {
            return this.readFormat2Charset(dataInput, format, nGlyphs);
        }
        throw new IllegalArgumentException();
    }

    private Format0Charset readFormat0Charset(CFFDataInput dataInput, int format, int nGlyphs) throws IOException {
        Format0Charset charset = new Format0Charset();
        charset.format = format;
        Format0Charset.access$3802(charset, new int[nGlyphs - 1]);
        for (int i = 0; i < charset.glyph.length; ++i) {
            ((Format0Charset)charset).glyph[i] = dataInput.readSID();
            charset.register(charset.glyph[i], this.readString(charset.glyph[i]));
        }
        return charset;
    }

    private Format1Charset readFormat1Charset(CFFDataInput dataInput, int format, int nGlyphs) throws IOException {
        Format1Charset.Range1 range;
        Format1Charset charset = new Format1Charset();
        charset.format = format;
        ArrayList<Format1Charset.Range1> ranges = new ArrayList<Format1Charset.Range1>();
        for (int i = 0; i < nGlyphs - 1; i += 1 + range.nLeft) {
            range = new Format1Charset.Range1();
            range.first = dataInput.readSID();
            range.nLeft = dataInput.readCard8();
            ranges.add(range);
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                charset.register(range.first + j, this.readString(range.first + j));
            }
        }
        Format1Charset.access$4402(charset, ranges.toArray(new Format1Charset.Range1[0]));
        return charset;
    }

    private Format2Charset readFormat2Charset(CFFDataInput dataInput, int format, int nGlyphs) throws IOException {
        Format2Charset.Range2 range;
        Format2Charset charset = new Format2Charset();
        charset.format = format;
        Format2Charset.access$4702(charset, new Format2Charset.Range2[0]);
        for (int i = 0; i < nGlyphs - 1; i += 1 + range.nLeft) {
            Format2Charset.Range2[] newRange = new Format2Charset.Range2[charset.range.length + 1];
            System.arraycopy(charset.range, 0, newRange, 0, charset.range.length);
            Format2Charset.access$4702(charset, newRange);
            range = new Format2Charset.Range2();
            range.first = dataInput.readSID();
            range.nLeft = dataInput.readCard16();
            ((Format2Charset)charset).range[((Format2Charset)charset).range.length - 1] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                charset.register(range.first + j, this.readString(range.first + j));
            }
        }
        return charset;
    }

    private static class Format2Charset
    extends EmbeddedCharset {
        private int format;
        private Range2[] range;

        private Format2Charset() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", range=" + Arrays.toString(this.range) + "]";
        }

        static /* synthetic */ Range2[] access$4702(Format2Charset x0, Range2[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range2 {
            private int first;
            private int nLeft;

            private Range2() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format1Charset
    extends EmbeddedCharset {
        private int format;
        private Range1[] range;

        private Format1Charset() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", range=" + Arrays.toString(this.range) + "]";
        }

        static /* synthetic */ Range1[] access$4402(Format1Charset x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Charset
    extends EmbeddedCharset {
        private int format;
        private int[] glyph;

        private Format0Charset() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", glyph=" + Arrays.toString(this.glyph) + "]";
        }

        static /* synthetic */ int[] access$3802(Format0Charset x0, int[] x1) {
            x0.glyph = x1;
            return x1;
        }
    }

    static abstract class EmbeddedCharset
    extends CFFCharset {
        EmbeddedCharset() {
        }

        public boolean isFontSpecific() {
            return true;
        }
    }

    private static class Format1Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nRanges;
        private Range1[] range;

        private Format1Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nRanges=" + this.nRanges + ", range=" + Arrays.toString(this.range) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ Range1[] access$1702(Format1Encoding x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nCodes;
        private int[] code;

        private Format0Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nCodes=" + this.nCodes + ", code=" + Arrays.toString(this.code) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ int[] access$1302(Format0Encoding x0, int[] x1) {
            x0.code = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EmbeddedEncoding
    extends CFFEncoding {
        private int nSups;
        private Supplement[] supplement;

        EmbeddedEncoding() {
        }

        @Override
        public boolean isFontSpecific() {
            return true;
        }

        List<Supplement> getSupplements() {
            if (this.supplement == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.supplement);
        }

        static /* synthetic */ Supplement[] access$2202(EmbeddedEncoding x0, Supplement[] x1) {
            x0.supplement = x1;
            return x1;
        }

        static class Supplement {
            private int code;
            private int glyph;

            Supplement() {
            }

            int getCode() {
                return this.code;
            }

            int getGlyph() {
                return this.glyph;
            }

            public String toString() {
                return this.getClass().getName() + "[code=" + this.code + ", glyph=" + this.glyph + "]";
            }
        }
    }

    private static class DictData {
        private List<Entry> entries = null;

        private DictData() {
        }

        public Entry getEntry(CFFOperator.Key key) {
            return this.getEntry(CFFOperator.getOperator(key));
        }

        public Entry getEntry(String name) {
            return this.getEntry(CFFOperator.getOperator(name));
        }

        private Entry getEntry(CFFOperator operator2) {
            for (Entry entry : this.entries) {
                if (entry == null || entry.operator == null || !entry.operator.equals(operator2)) continue;
                return entry;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[entries=" + this.entries + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry {
            private List<Number> operands = new ArrayList<Number>();
            private CFFOperator operator = null;

            private Entry() {
            }

            public Number getNumber(int index) {
                return this.operands.get(index);
            }

            public Boolean getBoolean(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    switch (operand.intValue()) {
                        case 0: {
                            return Boolean.FALSE;
                        }
                        case 1: {
                            return Boolean.TRUE;
                        }
                    }
                }
                throw new IllegalArgumentException();
            }

            public Integer getSID(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    return (Integer)operand;
                }
                throw new IllegalArgumentException();
            }

            public List<Number> getArray() {
                return this.operands;
            }

            public List<Number> getDelta() {
                return this.operands;
            }

            public String toString() {
                return this.getClass().getName() + "[operands=" + this.operands + ", operator=" + this.operator + "]";
            }
        }
    }

    private static class Header {
        private int major;
        private int minor;
        private int hdrSize;
        private int offSize;

        private Header() {
        }

        public String toString() {
            return this.getClass().getName() + "[major=" + this.major + ", minor=" + this.minor + ", hdrSize=" + this.hdrSize + ", offSize=" + this.offSize + "]";
        }
    }

    private static class Format0FDSelect
    extends CIDKeyedFDSelect {
        private int format;
        private int[] fds;

        private Format0FDSelect(CFFFontROS _owner) {
            super(_owner);
        }

        public int getFd(int glyph) {
            for (CFFFont.Mapping mapping : this.owner.getMappings()) {
                if (mapping.getSID() != glyph) continue;
                int index = 0;
                Map<String, byte[]> charString = this.owner.getCharStringsDict();
                Set<String> keys = charString.keySet();
                for (String str : keys) {
                    if (mapping.getName().equals(str)) {
                        return this.fds[index];
                    }
                    ++index;
                }
            }
            return -1;
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", fds=" + Arrays.toString(this.fds) + "]";
        }

        static /* synthetic */ int[] access$2702(Format0FDSelect x0, int[] x1) {
            x0.fds = x1;
            return x1;
        }
    }

    private static class Range3 {
        private int first;
        private int fd;

        private Range3() {
        }

        public String toString() {
            return this.getClass().getName() + "[first=" + this.first + ", fd=" + this.fd + "]";
        }
    }

    private static class Format3FDSelect
    extends CIDKeyedFDSelect {
        private int format;
        private int nbRanges;
        private Range3[] range3;
        private int sentinel;

        private Format3FDSelect(CFFFontROS _owner) {
            super(_owner);
        }

        public int getFd(int glyph) {
            for (int i = 0; i < this.nbRanges; ++i) {
                if (this.range3[i].first < glyph) continue;
                if (i + 1 < this.nbRanges) {
                    if (this.range3[i + 1].first <= glyph) continue;
                    return this.range3[i].fd;
                }
                if (this.sentinel > glyph) {
                    return this.range3[i].fd;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + " nbRanges=" + this.nbRanges + ", range3=" + Arrays.toString(this.range3) + " sentinel=" + this.sentinel + "]";
        }

        static /* synthetic */ Range3[] access$3102(Format3FDSelect x0, Range3[] x1) {
            x0.range3 = x1;
            return x1;
        }
    }
}

