/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.util.ImageParameters;

public class PDFOperator {
    private String theOperator;
    private byte[] imageData;
    private ImageParameters imageParameters;
    private static Map operators = Collections.synchronizedMap(new HashMap());

    private PDFOperator(String aOperator) {
        this.theOperator = aOperator;
        if (aOperator.startsWith("/")) {
            throw new RuntimeException("Operators are not allowed to start with / '" + aOperator + "'");
        }
    }

    public static PDFOperator getOperator(String operator2) {
        PDFOperator operation = null;
        if (operator2.equals("ID") || operator2.equals("BI")) {
            operation = new PDFOperator(operator2);
        } else {
            operation = (PDFOperator)operators.get(operator2);
            if (operation == null) {
                operation = new PDFOperator(operator2);
                operators.put(operator2, operation);
            }
        }
        return operation;
    }

    public String getOperation() {
        return this.theOperator;
    }

    public String toString() {
        return "PDFOperator{" + this.theOperator + "}";
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageDataArray) {
        this.imageData = imageDataArray;
    }

    public ImageParameters getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(ImageParameters params) {
        this.imageParameters = params;
    }
}

