/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.util.PDFMarkedContentExtractor;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator2, List<COSBase> arguments) throws IOException {
        COSName name = (COSName)arguments.get(0);
        Map<String, PDXObject> xobjects = this.context.getXObjects();
        PDXObject xobject = xobjects.get(name.getName());
        if (this.context instanceof PDFMarkedContentExtractor) {
            ((PDFMarkedContentExtractor)this.context).xobject(xobject);
        }
        if (xobject instanceof PDXObjectForm) {
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream invoke = (COSStream)form.getCOSObject();
            PDResources pdResources = form.getResources();
            PDPage page = this.context.getCurrentPage();
            if (pdResources == null) {
                pdResources = page.findResources();
            }
            this.getContext().processSubStream(page, pdResources, invoke);
        }
    }
}

