/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetNonStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetNonStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetNonStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetNonStrokingRGBColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNonStrokingDeviceN
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(SetNonStrokingDeviceN.class);

    @Override
    public void process(PDFOperator operator2, List<COSBase> arguments) throws IOException {
        PDColorState colorInstance = this.context.getGraphicsState().getNonStrokingColor();
        PDColorSpace colorSpace = colorInstance.getColorSpace();
        if (colorSpace != null) {
            List<COSBase> argList = arguments;
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceN) {
                PDDeviceN sep = (PDDeviceN)colorSpace;
                colorSpace = sep.getAlternateColorSpace();
                argList = sep.calculateColorValues(arguments).toList();
            }
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetNonStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetNonStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetNonStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetNonStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetNonStrokingCalRGBColor();
            }
            if (newOperator != null) {
                colorInstance.setColorSpace(colorSpace);
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator2, argList);
            } else {
                log.warn("Not supported colorspace " + colorSpace.getName() + " within operator " + operator2.getOperation());
            }
        }
    }
}

