/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.BasicStroke;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrokePath
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(StrokePath.class);

    @Override
    public void process(PDFOperator operator2, List<COSBase> arguments) throws IOException {
        try {
            BasicStroke stroke;
            PageDrawer drawer = (PageDrawer)this.context;
            float lineWidth = (float)this.context.getGraphicsState().getLineWidth();
            Matrix ctm = this.context.getGraphicsState().getCurrentTransformationMatrix();
            if (ctm != null && ctm.getXScale() > 0.0f) {
                lineWidth *= ctm.getXScale();
            }
            if ((stroke = drawer.getStroke()) == null) {
                drawer.setStroke(new BasicStroke(lineWidth));
            } else {
                drawer.setStroke(new BasicStroke(lineWidth, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()));
            }
            drawer.strokePath();
        }
        catch (Exception exception) {
            log.warn(exception, exception);
        }
    }
}

