/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.io.IOException;
import org.apache.poi.hslf.blip.Bitmap;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;

public final class DIB
extends Bitmap {
    private static final int HEADER_SIZE = 14;

    @Override
    public PictureData.PictureType getType() {
        return PictureData.PictureType.DIB;
    }

    @Override
    public int getSignature() {
        return this.uidInstanceCount == 1 ? 31360 : 31376;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 31360: {
                this.uidInstanceCount = 1;
                break;
            }
            case 31376: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for DIB");
            }
        }
    }

    @Override
    public byte[] getData() {
        return DIB.addBMPHeader(super.getData());
    }

    public static byte[] addBMPHeader(byte[] data) {
        byte[] header = new byte[14];
        LittleEndian.putInt(header, 0, 19778);
        int imageSize = LittleEndian.getInt(data, 20);
        int fileSize = data.length + 14;
        int offset = fileSize - imageSize;
        LittleEndian.putInt(header, 2, fileSize);
        LittleEndian.putInt(header, 6, 0);
        LittleEndian.putInt(header, 10, offset);
        byte[] dib = new byte[header.length + data.length];
        System.arraycopy(header, 0, dib, 0, header.length);
        System.arraycopy(data, 0, dib, header.length, data.length);
        return dib;
    }

    @Override
    public void setData(byte[] data) throws IOException {
        byte[] dib = new byte[data.length - 14];
        System.arraycopy(data, 14, dib, 0, dib.length);
        super.setData(dib);
    }
}

