/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.Units;

public final class EMF
extends Metafile {
    @Override
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16);
            long len = ((InputStream)is).skip(header.getSize() + 16);
            assert (len == (long)(header.getSize() + 16));
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    public void setData(byte[] data) throws IOException {
        byte[] compressed = EMF.compress(data, 0, data.length);
        NativeHeader nHeader = new NativeHeader(data, 0);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length;
        header.bounds = nHeader.deviceBounds;
        Dimension nDim = nHeader.getSize();
        header.size = new Dimension(Units.toEMU(nDim.getWidth()), Units.toEMU(nDim.getHeight()));
        header.zipsize = compressed.length;
        byte[] checksum = EMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        if (this.uidInstanceCount == 2) {
            out.write(checksum);
        }
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public PictureData.PictureType getType() {
        return PictureData.PictureType.EMF;
    }

    @Override
    public int getSignature() {
        return this.uidInstanceCount == 1 ? 15680 : 15696;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 15680: {
                this.uidInstanceCount = 1;
                break;
            }
            case 15696: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for EMF");
            }
        }
    }

    public static class NativeHeader {
        private final Rectangle deviceBounds;
        private static final String EMF_SIGNATURE = " EMF";

        public NativeHeader(byte[] data, int offset) {
            int type = (int)LittleEndian.getUInt(data, offset);
            offset += 4;
            if (type != 1) {
                throw new HSLFException("Invalid EMF picture");
            }
            int left = LittleEndian.getInt(data, offset += 4);
            int top = LittleEndian.getInt(data, offset += 4);
            int right = LittleEndian.getInt(data, offset += 4);
            int bottom = LittleEndian.getInt(data, offset += 4);
            offset += 4;
            this.deviceBounds = new Rectangle(left, top, right - left, bottom - top);
            String signature = new String(data, offset += 16, EMF_SIGNATURE.length(), LocaleUtil.CHARSET_1252);
            if (!EMF_SIGNATURE.equals(signature)) {
                throw new HSLFException("Invalid EMF picture");
            }
        }

        public Dimension getSize() {
            return this.deviceBounds.getSize();
        }
    }
}

