/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import org.apache.poi.hslf.blip.Bitmap;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.PngUtils;

public final class PNG
extends Bitmap {
    @Override
    public byte[] getData() {
        byte[] data = super.getData();
        if (PngUtils.matchesPngHeader(data, 16)) {
            byte[] png = new byte[data.length - 16];
            System.arraycopy(data, 16, png, 0, png.length);
            data = png;
        }
        return data;
    }

    @Override
    public PictureData.PictureType getType() {
        return PictureData.PictureType.PNG;
    }

    @Override
    public int getSignature() {
        return this.uidInstanceCount == 1 ? 28160 : 28176;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 28160: {
                this.uidInstanceCount = 1;
                break;
            }
            case 28176: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for PNG");
            }
        }
    }
}

