/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;

public final class PPT2PNG {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            PPT2PNG.usage();
            return;
        }
        int slidenum = -1;
        float scale = 1.0f;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-scale".equals(args[i])) {
                    scale = Float.parseFloat(args[++i]);
                    continue;
                }
                if (!"-slide".equals(args[i])) continue;
                slidenum = Integer.parseInt(args[++i]);
                continue;
            }
            file = args[i];
        }
        if (file == null) {
            PPT2PNG.usage();
            return;
        }
        FileInputStream is = new FileInputStream(file);
        HSLFSlideShow ppt = new HSLFSlideShow(is);
        is.close();
        Dimension pgsize = ppt.getPageSize();
        int width = (int)((float)pgsize.width * scale);
        int height = (int)((float)pgsize.height * scale);
        for (HSLFSlide slide : ppt.getSlides()) {
            if (slidenum != -1 && slidenum != slide.getSlideNumber()) continue;
            String title = slide.getTitle();
            System.out.println("Rendering slide " + slide.getSlideNumber() + (title == null ? "" : ": " + title));
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            graphics.scale((double)width / (double)pgsize.width, (double)height / (double)pgsize.height);
            slide.draw(graphics);
            String fname = file.replaceAll("\\.ppt", "-" + slide.getSlideNumber() + ".png");
            FileOutputStream out = new FileOutputStream(fname);
            ImageIO.write((RenderedImage)img, "png", out);
            out.close();
        }
    }

    private static void usage() {
        System.out.println("Usage: PPT2PNG [-scale <scale> -slide <num>] ppt");
    }
}

