/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JApplet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.view.SViewerPanel;

public class SViewer
extends JApplet {
    private SViewerPanel panel;
    boolean isStandalone = false;
    String filename = null;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    @Override
    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void jbInit() throws Exception {
        InputStream i = null;
        boolean isurl = false;
        if (this.filename == null) {
            this.filename = this.getParameter("filename");
        }
        if (this.filename == null || this.filename.substring(0, 7).equals("http://")) {
            isurl = true;
            if (this.filename == null) {
                this.filename = this.getParameter("url");
            }
            i = this.getXLSFromURL(this.filename);
        }
        HSSFWorkbook wb = null;
        wb = isurl ? this.constructWorkbook(i) : this.constructWorkbook(this.filename);
        this.panel = new SViewerPanel(wb, false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
    }

    private HSSFWorkbook constructWorkbook(String filename) throws FileNotFoundException, IOException {
        HSSFWorkbook wb = null;
        FileInputStream in = new FileInputStream(filename);
        wb = new HSSFWorkbook(in);
        in.close();
        return wb;
    }

    private HSSFWorkbook constructWorkbook(InputStream in) throws IOException {
        HSSFWorkbook wb = null;
        wb = new HSSFWorkbook(in);
        in.close();
        return wb;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getAppletInfo() {
        return "Applet Information";
    }

    @Override
    public String[][] getParameterInfo() {
        return null;
    }

    private InputStream getXLSFromURL(String urlstring) throws MalformedURLException, IOException {
        URL url = new URL(urlstring);
        URLConnection uc = url.openConnection();
        String field = uc.getHeaderField(0);
        int i = 0;
        while (field != null) {
            System.out.println(field);
            field = uc.getHeaderField(i);
            ++i;
        }
        BufferedInputStream is = new BufferedInputStream(uc.getInputStream());
        return is;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("A filename to view must be supplied as the first argument, but none was given");
        }
        SViewer applet = new SViewer();
        applet.isStandalone = true;
        applet.filename = args[0];
        Frame frame = new Frame(){

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            @Override
            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Applet Frame");
        frame.add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(400, 320);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

