/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.LFO;
import org.apache.poi.hwpf.model.LFOData;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class PlfLfo {
    private static POILogger log = POILogFactory.getLogger(PlfLfo.class);
    private int _lfoMac;
    private LFO[] _rgLfo;
    private LFOData[] _rgLfoData;

    PlfLfo(byte[] tableStream, int fcPlfLfo, int lcbPlfLfo) {
        int x;
        int offset = fcPlfLfo;
        long lfoMacLong = LittleEndian.getUInt(tableStream, offset);
        offset += 4;
        if (lfoMacLong > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Apache POI doesn't support rgLfo/rgLfoData size large than 2147483647 elements");
        }
        this._lfoMac = (int)lfoMacLong;
        this._rgLfo = new LFO[this._lfoMac];
        this._rgLfoData = new LFOData[this._lfoMac];
        for (x = 0; x < this._lfoMac; ++x) {
            LFO lfo = new LFO(tableStream, offset);
            offset += LFO.getSize();
            this._rgLfo[x] = lfo;
        }
        for (x = 0; x < this._lfoMac; ++x) {
            LFOData lfoData = new LFOData(tableStream, offset, this._rgLfo[x].getClfolvl());
            offset += lfoData.getSizeInBytes();
            this._rgLfoData[x] = lfoData;
        }
        if (offset - fcPlfLfo != lcbPlfLfo && log.check(5)) {
            log.log(5, new Object[]{"Actual size of PlfLfo is " + (offset - fcPlfLfo) + " bytes, but expected " + lcbPlfLfo});
        }
    }

    void add(LFO lfo, LFOData lfoData) {
        this._rgLfo = Arrays.copyOf(this._rgLfo, this._lfoMac + 1);
        this._rgLfo[this._lfoMac] = lfo;
        this._rgLfoData = Arrays.copyOf(this._rgLfoData, this._lfoMac + 1);
        this._rgLfoData[this._lfoMac] = lfoData;
        ++this._lfoMac;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlfLfo other = (PlfLfo)obj;
        return this._lfoMac == other._lfoMac && Arrays.equals(this._rgLfo, other._rgLfo) && Arrays.equals(this._rgLfoData, other._rgLfoData);
    }

    public int getLfoMac() {
        return this._lfoMac;
    }

    public int getIlfoByLsid(int lsid) {
        for (int i = 0; i < this._lfoMac; ++i) {
            if (this._rgLfo[i].getLsid() != lsid) continue;
            return i + 1;
        }
        throw new NoSuchElementException("LFO with lsid " + lsid + " not found");
    }

    public LFO getLfo(int ilfo) throws NoSuchElementException {
        if (ilfo <= 0 || ilfo > this._lfoMac) {
            throw new NoSuchElementException("LFO with ilfo " + ilfo + " not found. lfoMac is " + this._lfoMac);
        }
        return this._rgLfo[ilfo - 1];
    }

    public LFOData getLfoData(int ilfo) throws NoSuchElementException {
        if (ilfo <= 0 || ilfo > this._lfoMac) {
            throw new NoSuchElementException("LFOData with ilfo " + ilfo + " not found. lfoMac is " + this._lfoMac);
        }
        return this._rgLfoData[ilfo - 1];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._lfoMac;
        result = 31 * result + Arrays.hashCode(this._rgLfo);
        result = 31 * result + Arrays.hashCode(this._rgLfoData);
        return result;
    }

    void writeTo(FileInformationBlock fib, HWPFOutputStream outputStream) throws IOException {
        int i;
        int offset = outputStream.getOffset();
        fib.setFcPlfLfo(offset);
        LittleEndian.putUInt(this._lfoMac, outputStream);
        byte[] bs = new byte[LFO.getSize() * this._lfoMac];
        for (i = 0; i < this._lfoMac; ++i) {
            this._rgLfo[i].serialize(bs, i * LFO.getSize());
        }
        outputStream.write(bs, 0, LFO.getSize() * this._lfoMac);
        for (i = 0; i < this._lfoMac; ++i) {
            this._rgLfoData[i].writeTo(outputStream);
        }
        fib.setLcbPlfLfo(outputStream.getOffset() - offset);
    }
}

