/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples;

import java.io.Closeable;
import java.io.File;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class LoadEmbedded {
    public static void main(String[] args) throws Exception {
        Workbook wb = WorkbookFactory.create(new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws Exception {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws Exception {
        for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            Closeable closeable;
            DirectoryNode dn;
            String oleName = obj.getOLE2ClassName();
            if (oleName.equals("Worksheet")) {
                dn = (DirectoryNode)obj.getDirectory();
                closeable = new HSSFWorkbook(dn, false);
                continue;
            }
            if (oleName.equals("Document")) {
                dn = (DirectoryNode)obj.getDirectory();
                closeable = new HWPFDocument(dn);
                continue;
            }
            if (oleName.equals("Presentation")) {
                dn = (DirectoryNode)obj.getDirectory();
                closeable = new HSLFSlideShow(dn);
                continue;
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] byArray = obj.getObjectData();
        }
    }

    public static void loadEmbedded(XSSFWorkbook workbook) throws Exception {
        for (PackagePart pPart : workbook.getAllEmbedds()) {
            POIXMLDocument pOIXMLDocument;
            Closeable docPackage;
            Closeable closeable;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                closeable = new HSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                docPackage = OPCPackage.open(pPart.getInputStream());
                pOIXMLDocument = new XSSFWorkbook((OPCPackage)docPackage);
                continue;
            }
            if (contentType.equals("application/msword")) {
                docPackage = new HWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                docPackage = OPCPackage.open(pPart.getInputStream());
                pOIXMLDocument = new XWPFDocument((OPCPackage)docPackage);
                continue;
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                docPackage = new HSLFSlideShow(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                docPackage = OPCPackage.open(pPart.getInputStream());
                pOIXMLDocument = new XSLFSlideShow((OPCPackage)docPackage);
                continue;
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            closeable = pPart.getInputStream();
        }
    }
}

