/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.impl.CTRowImpl;

public class AligningCells {
    public static void main(String[] args) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        XSSFRow row = sheet.createRow(2);
        row.setHeightInPoints(30.0f);
        for (int i = 0; i < 8; ++i) {
            sheet.setColumnWidth(i, 3840);
        }
        AligningCells.createCell(wb, row, (short)0, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
        AligningCells.createCell(wb, row, (short)1, HorizontalAlignment.CENTER_SELECTION, VerticalAlignment.BOTTOM);
        AligningCells.createCell(wb, row, (short)2, HorizontalAlignment.FILL, VerticalAlignment.CENTER);
        AligningCells.createCell(wb, row, (short)3, HorizontalAlignment.GENERAL, VerticalAlignment.CENTER);
        AligningCells.createCell(wb, row, (short)4, HorizontalAlignment.JUSTIFY, VerticalAlignment.JUSTIFY);
        AligningCells.createCell(wb, row, (short)5, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
        AligningCells.createCell(wb, row, (short)6, HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
        row = sheet.createRow(3);
        AligningCells.centerAcrossSelection(wb, row, (short)1, (short)3, VerticalAlignment.CENTER);
        FileOutputStream fileOut = new FileOutputStream("xssf-align.xlsx");
        wb.write(fileOut);
        fileOut.close();
        wb.close();
    }

    private static void createCell(XSSFWorkbook wb, XSSFRow row, short column, HorizontalAlignment halign, VerticalAlignment valign) {
        XSSFCell cell = row.createCell(column);
        cell.setCellValue(new XSSFRichTextString("Align It"));
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        cell.setCellStyle(cellStyle);
    }

    private static void centerAcrossSelection(XSSFWorkbook wb, XSSFRow row, short start_column, short end_column, VerticalAlignment valign) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        cellStyle.setVerticalAlignment(valign);
        for (int i = start_column; i <= end_column; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellStyle(cellStyle);
        }
        XSSFCell cell = row.getCell(start_column);
        cell.setCellValue(new XSSFRichTextString("Align It"));
        CTRowImpl ctRow = (CTRowImpl)row.getCTRow();
        String span = start_column + ":" + end_column;
        ArrayList<String> spanList = new ArrayList<String>();
        spanList.add(span);
        ctRow.setSpans(spanList);
    }
}

