/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.Closeable;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class EmbeddedObjects {
    public static void main(String[] args) throws Exception {
        OPCPackage pkg = OPCPackage.open(args[0]);
        XSSFWorkbook workbook = new XSSFWorkbook(pkg);
        for (PackagePart pPart : workbook.getAllEmbedds()) {
            Closeable closeable;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                closeable = new HSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                closeable = new XSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/msword")) {
                closeable = new HWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                closeable = new XWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                closeable = new HSLFSlideShowImpl(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                OPCPackage docPackage = OPCPackage.open(pPart.getInputStream());
                XSLFSlideShow xSLFSlideShow = new XSLFSlideShow(docPackage);
                continue;
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            closeable = pPart.getInputStream();
        }
        pkg.close();
    }
}

