<?php
/* Copyright (c) 1998-2017 ILIAS open source, Extended GPL, see docs/LICENSE */

require_once 'Services/Xml/classes/class.ilXmlWriter.php';
require_once 'Modules/Chatroom/classes/class.ilChatroom.php';

/**
 * Class ilChatroomXMLWriter
 */
class ilChatroomXMLWriter extends ilXmlWriter
{
    /**
     * @var ilObjChatroom
     */
    protected $chat;

    /**
     * @var ilChatroom
     */
    protected $room;

    /**
     * ilChatroomXMLWriter constructor.
     * @param ilObjChatroom $chat
     */
    public function __construct(ilObjChatroom $chat)
    {
        $this->chat = $chat;

        $this->room = ilChatroom::byObjectId($this->chat->getId());
        if (!$this->room) {
            $this->room = new ilChatroom();
            $this->room->setSetting('object_id', $this->chat->getId());
        }

        parent::__construct();
    }

    /**
     *
     */
    public function start()
    {
        $this->xmlStartTag('Chatroom', null);

        $this->xmlElement('ObjId', null, (int) $this->chat->getId());
        $this->xmlElement('RoomId', null, (int) $this->room->getRoomId());
        $this->xmlElement('Title', null, $this->chat->getTitle());
        $this->xmlElement('Description', null, $this->chat->getDescription());
        $this->xmlElement('OnlineStatus', null, (int) $this->room->getSetting('online_status'));
        $this->xmlElement('AllowAnonymousAccess', null, (int) $this->room->getSetting('allow_anonymous'));
        $this->xmlElement('AllowCustomUsernames', null, (int) $this->room->getSetting('allow_custom_usernames'));
        $this->xmlElement('EnableHistory', null, (int) $this->room->getSetting('enable_history'));
        $this->xmlElement('RestrictHistory', null, (int) $this->room->getSetting('restrict_history'));
        $this->xmlElement('PrivateRoomsEnabled', null, (int) $this->room->getSetting('private_rooms_enabled'));
        $this->xmlElement('DisplayPastMessages', null, (int) $this->room->getSetting('display_past_msgs'));
        $this->xmlElement('AutoGeneratedUsernameSchema', null, $this->room->getSetting('autogen_usernames'));

        if ((int) $this->room->getRoomId() > 0) {
            $this->exportData();
        }

        $this->xmlEndTag('Chatroom');
    }

    /**
     *
     */
    private function exportData()
    {
        $privateRooms = $this->room->getPrivateRooms();
        if (count($privateRooms) > 0) {
            $this->xmlStartTag('SubRooms', null);
            foreach ($privateRooms as $privateRoom) {
                $this->xmlStartTag('SubRoom', null);
                $this->xmlElement('SubRoomId', null, (int) $privateRoom['proom_id']);
                $this->xmlElement('Title', null, $privateRoom['title']);
                $this->xmlElement('Owner', null, (int) $privateRoom['owner']);
                $this->xmlElement('Closed', null, (int) $privateRoom['closed']);
                $this->xmlElement('Public', null, (int) $privateRoom['is_public']);
                $this->xmlElement('CreatedTimestamp', null, (int) $privateRoom['created']);

                foreach ($this->room->getPrivilegedUsersForPrivateRoom((int) $privateRoom['proom_id']) as $usrId) {
                    $this->xmlElement('PrivilegedUserId', null, $usrId);
                }

                $this->xmlEndTag('SubRoom');
            }
            $this->xmlEndTag('SubRooms');
        }

        $history = $this->room->getHistory(null, null, null, null, false);
        if (count($history) > 0) {
            $this->xmlStartTag('Messages', null);
            foreach ($history as $entry) {
                $this->xmlStartTag('Message', null);
                $this->xmlElement('SubRoomId', null, (int) $entry['sub_room']);
                $this->xmlElement('Body', null, json_encode($entry['message']));
                $this->xmlElement('CreatedTimestamp', null, (int) $entry['timestamp']);
                $this->xmlEndTag('Message');
            }
            $this->xmlEndTag('Messages');
        }
    }

    /**
     * @return string
     */
    public function getXML()
    {
        // Replace ascii code 11 characters because of problems with xml sax parser
        return str_replace('&#11;', '', $this->xmlDumpMem(false));
    }
}
