<?php

require_once 'class.ilChatroomAbstractTest.php';

/**
 * Class ilObjChatroomTest
 * @author Thomas Joußen <tjoussen@gmx.de>
 */
class ilObjChatroomTest extends ilChatroomAbstractTest
{

    /**
     * @var PHPUnit_Framework_TestCase|ilObjChatroom
     */
    protected $object;

    protected function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        require_once './Modules/Chatroom/classes/class.ilObjChatroom.php';

        $this->createIlChatroomUserMock();

        $this->object = $this->createMock(
            'ilObjChatroom',
            array('createDefaultRole')
        );
    }

    public function testConstructor()
    {
        $this->assertInstanceOf('ilObjChatroom', $this->object);
    }

    public function testGetPersonalInformation()
    {
        $this->ilChatroomUserMock->expects($this->once())->method('getUserId')->will($this->returnValue(6));
        $this->ilChatroomUserMock->expects($this->once())->method('getUsername')->will($this->returnValue('username'));

        $userInfo = $this->object->getPersonalInformation($this->ilChatroomUserMock);

        $this->assertInstanceOf('stdClass', $userInfo);
        $this->assertEquals('username', $userInfo->username);
        $this->assertEquals(6, $userInfo->id);
    }

    public function test_GetPublicRefId()
    {
        $this->assertEquals(0, $this->object->_getPublicRefId());
    }

    public function test_GetPublicObjId()
    {
        $this->createGlobalIlDBMock();

        $query = 'SELECT object_id FROM chatroom_settings WHERE room_type=default';
        $GLOBALS['ilDB']->expects($this->once())->method('query')->with($this->equalTo($query));
        $GLOBALS['ilDB']->expects($this->once())->method('quote')->with($this->equalTo('default'))->will($this->returnValue('default'));
        $GLOBALS['ilDB']->expects($this->once())->method('fetchAssoc')->will($this->returnValue(array('object_id' => '6')));

        $this->assertEquals(6, $this->object->_getPublicObjId());
    }

    public function test_GetPublicObjIdDefaultValue()
    {
        $this->createGlobalIlDBMock();

        $query = 'SELECT object_id FROM chatroom_settings WHERE room_type=default';
        $GLOBALS['ilDB']->expects($this->once())->method('query')->with($this->equalTo($query));
        $GLOBALS['ilDB']->expects($this->once())->method('quote')->with($this->equalTo('default'))->will($this->returnValue('default'));
        $GLOBALS['ilDB']->expects($this->once())->method('fetchAssoc')->will($this->returnValue(null));

        $this->assertEquals(0, $this->object->_getPublicObjId());
    }

    public function testInitDefaultRoles()
    {
        //include_once './Services/AccessControl/classes/class.ilObjRole.php';
        $this->backupStaticAttributes = true;
        $this->object->expects($this->once())->method('createDefaultRole');
        $this->assertEmpty($this->object->initDefaultRoles());
    }
}
