<?php

/**
 * Class ilCloudGroupedListGUI
 *
 * @author      Fabian Schmid <fs@studer-raimann.ch>
 *
 * @description Unfortunatelly there's no possibility to get the amount of titems out of ilGroupedListGUI. therefore this class can help...
 */
class ilCloudGroupedListGUI extends ilGroupedListGUI
{

    /**
     * @var int
     */
    protected $count = 0;


    /**
     * @param        $a_content
     * @param string $a_href
     * @param string $a_target
     * @param string $a_onclick
     * @param string $a_add_class
     * @param string $a_id
     * @param string $a_ttip
     * @param string $a_tt_my
     * @param string $a_tt_at
     * @param bool   $a_tt_use_htmlspecialchars
     */
    public function addEntry(
        $a_content,
        $a_href = '',
        $a_target = '',
        $a_onclick = '',
        $a_add_class = '',
        $a_id = '',
        $a_ttip = '',
        $a_tt_my = 'right center',
        $a_tt_at = 'left center',
        $a_tt_use_htmlspecialchars = true
    ) {
        $this->count++;
        parent::addEntry($a_content, $a_href, $a_target, $a_onclick, $a_add_class, $a_id, $a_ttip, $a_tt_my, $a_tt_at, $a_tt_use_htmlspecialchars); // TODO: Change the autogenerated stub
    }


    /**
     * @param        $a_content
     * @param string $a_add_class
     */
    public function addGroupHeader($a_content, $a_add_class = "")
    {
        $this->count++;
        parent::addGroupHeader($a_content, $a_add_class); // TODO: Change the autogenerated stub
    }


    public function addSeparator()
    {
        $this->count++;
        parent::addSeparator(); // TODO: Change the autogenerated stub
    }


    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }


    /**
     * @return bool
     */
    public function hasItems()
    {
        return $this->getCount() > 0;
    }
}
