<?php

use ILIAS\Refinery;
use ILIAS\Setup;

class ilFileObjectMigrationAgent implements Setup\Agent
{

    protected $refinery;

    public function __construct(Refinery\Factory $refinery)
    {
        $this->refinery = $refinery;
    }

    /**
     * @inheritdoc
     */
    public function hasConfig() : bool
    {
        return false;
    }

    /**
     * @inheritdoc
     */
    public function getArrayToConfigTransformation() : Refinery\Transformation
    {
        throw new \LogicException("Agent has no config.");
    }

    /**
     * @inheritdoc
     */
    public function getInstallObjective(Setup\Config $config = null) : Setup\Objective
    {
        return new ilFileSystemComponentDataDirectoryCreatedObjective(
            'storage',
            ilFileSystemComponentDataDirectoryCreatedObjective::DATADIR
        );
    }

    /**
     * @inheritdoc
     */
    public function getUpdateObjective(Setup\Config $config = null) : Setup\Objective
    {
        return new ilFileSystemComponentDataDirectoryCreatedObjective(
            'storage',
            ilFileSystemComponentDataDirectoryCreatedObjective::DATADIR
        );
    }

    /**
     * @inheritdoc
     */
    public function getBuildArtifactObjective() : Setup\Objective
    {
        return new Setup\Objective\NullObjective();
    }

    /**
     * @inheritdoc
     */
    public function getStatusObjective(Setup\Metrics\Storage $storage) : Setup\Objective
    {
        return new Setup\Objective\NullObjective();
    }

    /**
     * @inheritDoc
     */
    public function getMigrations() : array
    {
        return [
            new ilFileObjectToStorageMigration()
        ];
    }

}
