<?php

/**
 * Trait ilObjFilePreviewHandler
 * @author Fabian Schmid <fs@studer-raimann.ch>
 */
trait ilObjFilePreviewHandler
{
    /**
     * Deletes the preview of the file object.
     */
    protected function deletePreview() : void
    {
        // only normal files are supported
        if ($this->getMode() !== self::MODE_OBJECT) {
            return;
        }
        ilPreview::deletePreview($this->getId());
    }

    /**
     * Creates a preview for the file object.
     * @param bool $force true, to force the creation of the preview; false, to create the preview
     *                    only if the file is newer.
     */
    protected function createPreview($force = false) : void
    {
        // only normal files are supported
        if ($this->getMode() != self::MODE_OBJECT) {
            return;
        }
        ilPreview::createPreview($this, $force);
    }
}
