<?php

/* Copyright (c) 1998-2010 ILIAS open source, Extended GPL, see docs/LICENSE */

require_once("./Modules/Scorm2004/classes/class.ilSCORM2004NodeGUI.php");
require_once("./Modules/Scorm2004/classes/class.ilSCORM2004Sco.php");
require_once("./Modules/Scorm2004/classes/seq_editor/class.ilSCORM2004Objective.php");

/**
 * Class ilSCORM2004ScoGUI
 *
 * User Interface for Scorm 2004 SCO Nodes
 *
 * @author Alex Killing <alex.killing@gmx.de>
 * @version $Id$
 *
 * @ilCtrl_Calls ilSCORM2004ScoGUI: ilObjectMetaDataGUI, ilNoteGUI, ilPCQuestionGUI, ilSCORM2004PageGUI, ilAssGenFeedbackPageGUI
 *
 * @ingroup ModulesScorm2004
 */
class ilSCORM2004ScoGUI extends ilSCORM2004NodeGUI
{
    /**
     * @var ilHelpGUI
     */
    protected $help;

    /**
     * @var ilErrorHandling
     */
    protected $error;


    /**
     * Constructor
     * @access	public
     */

    public $ctrl = null;

    public function __construct($a_slm_obj, $a_node_id = 0)
    {
        global $DIC;

        $this->ctrl = $DIC->ctrl();
        $this->tpl = $DIC["tpl"];
        $this->tabs = $DIC->tabs();
        $this->lng = $DIC->language();
        $this->help = $DIC["ilHelp"];
        $this->error = $DIC["ilErr"];
        $ilCtrl = $DIC->ctrl();

        $ilCtrl->saveParameter($this, "obj_id");
        $this->ctrl = &$ilCtrl;

        parent::__construct($a_slm_obj, $a_node_id);
    }

    /**
     * Get Node Type
     */
    public function getType()
    {
        return "sco";
    }

    /**
     * execute command
     */
    public function executeCommand()
    {
        $tpl = $this->tpl;
        $ilCtrl = $this->ctrl;
        $ilTabs = $this->tabs;

        $tpl->loadStandardTemplate();

        $next_class = $ilCtrl->getNextClass($this);
        $cmd = $ilCtrl->getCmd();

        switch ($next_class) {
            // notes
            case "ilnotegui":
                switch ($_GET["notes_mode"]) {
                    default:
                        $ilTabs->setTabActive("sahs_organization");
                        return $this->showOrganization();
                }
                break;

            case 'ilobjectmetadatagui':
                $this->setTabs();
                $this->setLocator();
                                include_once 'Services/Object/classes/class.ilObjectMetaDataGUI.php';
                $md_gui = new ilObjectMetaDataGUI(
                    $this->slm_object,
                    $this->node_object->getType(),
                    $this->node_object->getId()
                );
                $md_gui->addMDObserver($this->node_object, 'MDUpdateListener', 'General');
                $ilCtrl->forwardCommand($md_gui);
                break;
                
            case 'ilscorm2004pagegui':
                include_once("./Modules/Scorm2004/classes/class.ilSCORM2004PageGUI.php");
                $page_obj = new ilSCORM2004PageGUI("sahs", $_GET["pg_id"]);
                //$page_obj->setPresentationTitle($page["title"]);
                $page_obj->setOutputMode(ilPageObjectGUI::PREVIEW);
                $ilCtrl->forwardCommand($page_obj);
                break;

            // mainly to fix #21631
            case "ilassgenfeedbackpagegui":
                break;

            default:
                $cmd = $ilCtrl->getCmd("showOrganization");
                $ret = $this->$cmd();
                break;
        }
    }

    /**
     * Show learning objectives
     */
    public function showProperties()
    {
        $tpl = $this->tpl;
        $lng = $this->lng;
        $ilTabs = $this->tabs;
        $ilCtrl = $this->ctrl;

        $this->setTabs();
        $this->setLocator();
        $ilTabs->setTabActive("sahs_desc_objectives");

        include_once("./Services/Form/classes/class.ilPropertyFormGUI.php");
        $form = new ilPropertyFormGUI();

        // hide objectives page
        $cb = new ilCheckboxInputGUI($lng->txt("sahs_hide_objectives_page"), "hide_objectives_page");
        $cb->setInfo($lng->txt("sahs_hide_objectives_page_info"));
        $form->addItem($cb);
        $cb->setChecked($this->node_object->getHideObjectivePage());

        // description
        $ta = new ilTextAreaInputGUI($lng->txt("description"), "desc");
        $ta->setRows(4);
        $ta->setCols(55);
        $ta->setInfo($lng->txt("sahs_list_info"));
        $form->setTitle($lng->txt("properties"));
        $form->addItem($ta);
        include_once "./Services/MetaData/classes/class.ilMD.php";
        $meta = new ilMD($this->node_object->getSLMId(), $this->node_object->getId(), $this->node_object->getType());
        $desc_ids = $meta->getGeneral()->getDescriptionIds();
        $ta->setValue($meta->getGeneral()->getDescription($desc_ids[0])->getDescription());

        // objectives
        $sh = new ilFormSectionHeaderGUI();
        $sh->setTitle($lng->txt("sahs_learning_objectives"));
        $form->addItem($sh);

        $objectives = $this->node_object->getObjectives();

        foreach ($objectives as $ob) {
            // map info
            $mappings = $ob->getMappings();
            $mapinfo = null;
            foreach ($mappings as $map) {
                $mapinfo .= $map->getTargetObjectiveID();
            }

            if ($mapinfo == null) {
                $mapinfo = "local";
            } else {
                $mapinfo = "global to " . $mapinfo;
            }

            // objective
            $ta = new ilTextAreaInputGUI(
                $mapinfo,
                "obj_" . $ob->getId()
            );
            $ta->setCols(55);
            $ta->setRows(4);
            $ta->setInfo($lng->txt("sahs_list_info"));
            $form->addItem($ta);
            $ta->setValue($ob->getObjectiveID());
        }
        $form->setFormAction($ilCtrl->getFormAction($this));
        $form->addCommandButton(
            "updateProperties",
            $lng->txt("save")
        );
        $tpl->setContent($form->getHTML());
    }

    /**
     * update Properties
     */
    public function updateProperties()
    {
        $tpl = $this->tpl;
        $lng = $this->lng;
        $empty = false;

        foreach ($_POST as $key => $value) {
            if (preg_match('/(obj_)(.+)/', $key, $match)) {
                $objective = new ilScorm2004Objective($this->node_object->getId(), $match[2]);
                //				if (!$value)
                //				{
                //					$empty=true;
                //				} else {
                $objective->setObjectiveID(ilUtil::stripSlashes($value));
                $objective->updateObjective();
                //				}
            }
        }

        $this->node_object->setHideObjectivePage(ilUtil::stripSlashes($_POST["hide_objectives_page"]));
        $this->node_object->update();

        include_once "./Services/MetaData/classes/class.ilMD.php";
        $meta = new ilMD($this->node_object->getSLMId(), $this->node_object->getId(), $this->node_object->getType());
        $gen = $meta->getGeneral();
        $desc_ids = $gen->getDescriptionIds();
        $des = $gen->getDescription($desc_ids[0]);
        $des->setDescription(ilUtil::stripSlashes($_POST["desc"]));
        $des->update();
        $gen->update();

        if (!$empty) {
            ilUtil::sendInfo($lng->txt("saved_successfully"), true);
        } else {
            ilUtil::sendFailure($lng->txt("sahs_empty_objectives_are_not_allowed"), true);
        }
        $this->showProperties();
    }

    public function sahs_questions()
    {
        $this->setTabs();
        $this->setLocator();

        $tree = new ilTree($this->slm_object->getId());
        $tree->setTableNames('sahs_sc13_tree', 'sahs_sc13_tree_node');
        $tree->setTreeTablePK("slm_id");
        $questions = [];
        foreach ($tree->getSubTree($tree->getNodeData($this->node_object->getId()), true, 'page') as $page) {
            // get question ids
            $qids = ilPCQuestion::_getQuestionIdsForPage("sahs", $page["obj_id"]);
            if (count($qids) > 0) {
                // output questions
                foreach ($qids as $qid) {
                    $questions[] = [
                        "page" => $page,
                        "qid" => $qid
                    ];
                }
            }
        }

        $tab = new ILIAS\Scorm2004\Editor\ilSCORMQuestionOverviewTableGUI($this, "sahs_questions");
        $tab->setData($questions);
        $this->tpl->setContent($tab->getHTML());
    }

    public function getEditTree()
    {
        die("deprecated");
        $slm_tree = new ilTree($this->node_object->getId(), $this->slm_object->getId());
        $slm_tree->setTreeTablePK("slm_id");
        $slm_tree->setTableNames('sahs_sc13_tree', 'sahs_sc13_tree_node');
        return $slm_tree;
    }

    /**
     * output tabs
     */
    public function setTabs()
    {
        $ilTabs = $this->tabs;
        $ilCtrl = $this->ctrl;
        $tpl = $this->tpl;
        $lng = $this->lng;
        $ilHelp = $this->help;

        $ilHelp->setScreenIdComponent("sahsed");

        // subelements
        $ilTabs->addTarget(
            "sahs_organization",
            $ilCtrl->getLinkTarget($this, 'showOrganization'),
            "showOrganization",
            get_class($this)
        );

        // properties (named learning objectives, since here is currently
        // no other property)
        $ilTabs->addTarget(
            "sahs_desc_objectives",
            $ilCtrl->getLinkTarget($this, 'showProperties'),
            "showProperties",
            get_class($this)
        );

        // questions
        $ilTabs->addTarget(
            "sahs_questions",
            $ilCtrl->getLinkTarget($this, 'sahs_questions'),
            "sahs_questions",
            get_class($this)
        );

        // resources
        $ilTabs->addTarget(
            "cont_files",
            $ilCtrl->getLinkTarget($this, 'sco_resources'),
            "sco_resources",
            get_class($this)
        );
        
        // metadata
        include_once "Services/Object/classes/class.ilObjectMetaDataGUI.php";
        $mdgui = new ilObjectMetaDataGUI(
            $this->slm_object,
            $this->node_object->getType(),
            $this->node_object->getId()
        );
        $mdtab = $mdgui->getTab();
        if ($mdtab) {
            $ilTabs->addTarget(
                "meta_data",
                $mdtab,
                "",
                "ilmdeditorgui"
            );
        }
        
        // export
        $ilTabs->addTarget(
            "export",
            $ilCtrl->getLinkTarget($this, "showExportList"),
            "showExportList",
            get_class($this)
        );
        
        // import
        $ilTabs->addTarget(
            "import",
            $ilCtrl->getLinkTarget($this, "import"),
            "import",
            get_class($this)
        );
        
        // preview
        $ilTabs->addNonTabbedLink(
            "preview",
            $lng->txt("cont_preview"),
            $ilCtrl->getLinkTarget($this, 'sco_preview'),
            "_blank"
        );
        
        $tpl->setTitleIcon(ilUtil::getImagePath("icon_sco.svg"));
        $tpl->setTitle(
            $lng->txt("sahs_unit") . ": " . $this->node_object->getTitle()
        );
    }

    /**
     * Perform drag and drop action
     */
    public function proceedDragDrop()
    {
        $ilCtrl = $this->ctrl;

        //echo "-".$_POST["il_hform_source_id"]."-".$_POST["il_hform_target_id"]."-".$_POST["il_hform_fc"]."-";
        $this->slm_object->executeDragDrop(
            $_POST["il_hform_source_id"],
            $_POST["il_hform_target_id"],
            $_POST["il_hform_fc"],
            $_POST["il_hform_as_subitem"]
        );
        $ilCtrl->redirect($this, "showOrganization");
    }

    /**
     * SCO preview
     */
    public function sco_preview()
    {
        global $DIC;
        $tpl = $DIC['tpl'];

        $ilCtrl = $this->ctrl;
        
        // init main template
        $tpl = new ilGlobalTemplate("tpl.legacy_main.html", true, true, "Modules/Scorm2004");
        include_once("./Services/Style/Content/classes/class.ilObjStyleSheet.php");
        $tpl->setVariable("LOCATION_STYLESHEET", ilUtil::getStyleSheetLocation());
        $tpl->setBodyClass("");
        $tpl->setCurrentBlock("ContentStyle");
        $tpl->setVariable(
            "LOCATION_CONTENT_STYLESHEET",
            ilObjStyleSheet::getContentStylePath($this->slm_object->getStyleSheetId())
        );
        $tpl->parseCurrentBlock();
        
        // get javascript
        include_once("./Services/jQuery/classes/class.iljQueryUtil.php");
        iljQueryUtil::initjQuery($tpl);
        iljQueryUtil::initjQueryUI($tpl);
        $tpl->addJavaScript("./Modules/Scorm2004/scripts/questions/pure.js");
        $tpl->addJavaScript("./Modules/Scorm2004/scripts/pager.js");
        $tpl->addJavaScript("./Services/COPage/js/ilCOPagePres.js");
        $tpl->addJavascript(iljQueryUtil::getLocalMaphilightPath());
        $tpl->addCss("./Modules/Test/templates/default/ta.css");

        $tpl->addOnLoadCode("pager.Init();");
        
        $tree = new ilTree($this->slm_object->getId());
        $tree->setTableNames('sahs_sc13_tree', 'sahs_sc13_tree_node');
        $tree->setTreeTablePK("slm_id");
        include_once "./Modules/Scorm2004/classes/class.ilSCORM2004PageGUI.php";
        include_once "./Services/MetaData/classes/class.ilMD.php";
        
        $meta = new ilMD($this->node_object->getSLMId(), $this->node_object->getId(), $this->node_object->getType());
        $desc_ids = $meta->getGeneral()->getDescriptionIds();
        $sco_description = $meta->getGeneral()->getDescription($desc_ids[0])->getDescription();
        
        // get sco template
        $sco_tpl = new ilTemplate("tpl.sco.html", true, true, "Modules/Scorm2004");
        
        // navigation
        $lk = ilObjSAHSLearningModule::getAffectiveLocalization($this->node_object->getSLMId());
        ilSCORM2004Asset::renderNavigation($sco_tpl, "", $lk);

        // meta page (description and objectives)
        ilSCORM2004Asset::renderMetaPage(
            $sco_tpl,
            $this->node_object,
            $this->node_object->getType()
        );
                
        // init export (this initialises glossary template)
        ilSCORM2004PageGUI::initExport();
        $terms = $this->node_object->getGlossaryTermIds();
        
        // render page
        foreach ($tree->getSubTree($tree->getNodeData($this->node_object->getId()), true, 'page') as $page) {
            $page_obj = new ilSCORM2004PageGUI(
                $this->node_object->getType(),
                $page["obj_id"],
                0,
                $this->slm_object->getId()
            );
            $page_obj->setPresentationTitle($page["title"]);
            $page_obj->setOutputMode(ilPageObjectGUI::PREVIEW);
            $page_obj->setStyleId($this->slm_object->getStyleSheetId());
            if (count($terms) > 1) {
                $page_obj->setGlossaryOverviewInfo(
                    ilSCORM2004ScoGUI::getGlossaryOverviewId(),
                    $this->node_object
                );
            }
            $sco_tpl->setCurrentBlock("page_preview");
            $html = $ilCtrl->getHTML($page_obj);
            //$sco_tpl->setVariable("PAGE_PRV", $page_obj->showPage("export"));
            $sco_tpl->setVariable("PAGE_PRV", $html);
            $sco_tpl->parseCurrentBlock();
        }

        $output = $sco_tpl->get();
                    
        // append glossary entries on the sco level
        $output .= ilSCORM2004PageGUI::getGlossaryHTML($this->node_object);
        
        //insert questions
        require_once './Modules/Scorm2004/classes/class.ilQuestionExporter.php';
        $output = preg_replace_callback("/{{{{{(Question;)(il__qst_[0-9]+)}}}}}/", array(get_class($this), 'insertQuestion'), $output);
        $output = "<script>var ScormApi=null;" . ilQuestionExporter::questionsJS() . "</script>" . $output;
        
        $lk = ilObjSAHSLearningModule::getAffectiveLocalization($this->node_object->getSLMId());

        $tpl->addJavaScript("./Modules/Scorm2004/scripts/questions/question_handling.js");
        $tpl->addCss("./Modules/Scorm2004/templates/default/question_handling.css");
        
        include_once("./Services/UIComponent/Overlay/classes/class.ilOverlayGUI.php");
        ilOverlayGUI::initJavascript();
        
        //inline JS
        $output .= '<script type="text/javascript" src="./Modules/Scorm2004/scripts/questions/question_handling.js"></script>';
        $tpl->addOnLoadCode("ilias.questions.refresh_lang();");
        $tpl->setVariable("CONTENT", $output);
        $tpl->printToStdout();
        exit;
    }
    
    //callback function for question export
    private static function insertQuestion($matches)
    {
        $q_exporter = new ilQuestionExporter(false);
        return $q_exporter->exportQuestion($matches[2]);
    }

    /**
    * Select the export type of the SCORM 2004 module
    */
    public function selectExport()
    {
        switch ($_POST['select_export']) {
            case "exportScorm12":
            case "exportScorm2004_3rd":
            case "exportScorm2004_4th":
            case "exportPDF":
            case "exportHTML":
                $this->ctrl->redirect($this, $_POST['select_export']);
                break;
            default:
                $this->ctrl->redirect($this, 'showExportList');
                break;
        }
    }
    
    public function showExportList()
    {
        $tpl = $this->tpl;
        $ilCtrl = $this->ctrl;
        $lng = $this->lng;
        
        $this->setTabs();
        $this->setLocator();
        

        $template = new ilTemplate("tpl.scorm2004_export_buttons.html", true, true, 'Modules/Scorm2004');

        $buttons = array(
            "exportScorm2004_3rd" => $lng->txt("scorm_create_export_file_scrom2004"),
            "exportScorm2004_4th" => $lng->txt("scorm_create_export_file_scrom2004_4th"),
            "exportScorm12" => $lng->txt("scorm_create_export_file_scrom12"),
            "exportPDF" => $lng->txt("scorm_create_export_file_pdf"),
            "exportHTML" => $lng->txt("scorm_create_export_file_html")
        );
        foreach ($buttons as $value => $text) {
            $template->setCurrentBlock('option');
            $template->setVariable('OPTION_VALUE', $value);
            $template->setVariable('OPTION_TITLE', ilUtil::prepareFormOutput($text));
            $template->parseCurrentBlock();
        }
        $template->setVariable('EXPORT_TITLE', $lng->txt('export'));
        $template->setVariable('EXPORT_LABEL', $lng->txt('type'));
        $template->setVariable('FORMACTION', $ilCtrl->getFormAction($this, 'selectExport'));

        $export_files = $this->node_object->getExportFiles();

        include_once "./Modules/Scorm2004/classes/class.ilSCORM2004ExportTableGUI.php";
        $table_gui = new ilSCORM2004ExportTableGUI($this, 'showExportList');
        $data = array();
        foreach ($export_files as $exp_file) {
            $filetype = $exp_file['type'];
            $public_str = "";
            //	$public_str = ($exp_file["file"] == $this->object->getPublicExportFile($filetype))
            //		? " <b>(".$this->lng->txt("public").")<b>"
            //		: "";
            $file_arr = explode("__", $exp_file["file"]);
            array_push($data, array('file' => $exp_file['file'], 'filetype' => $filetype, 'date' => ilDatePresentation::formatDate(new ilDateTime($file_arr[0], IL_CAL_UNIX)), 'size' => $exp_file['size'], 'type' => $exp_file['type'] . $public_str));
        }
        $table_gui->setData($data);
        $tpl->setVariable('ADM_CONTENT', $template->get() . "\n" . $table_gui->getHTML());
    }

    public function exportScorm2004_4th()
    {
        $export = new ilScorm2004Export($this->node_object, 'SCORM 2004 4th');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }

    
    public function exportScorm2004_3rd()
    {
        $export = new ilScorm2004Export($this->node_object, 'SCORM 2004 3rd');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }
    
    public function exportScorm12()
    {
        $export = new ilScorm2004Export($this->node_object, 'SCORM 1.2');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }
    
    public function exportHTML()
    {
        $export = new ilScorm2004Export($this->node_object, 'HTML');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }

    public function exportISO()
    {
        $export = new ilScorm2004Export($this->node_object, 'ISO');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }
    
    public function exportPDF()
    {
        $export = new ilScorm2004Export($this->node_object, 'PDF');
        $export->buildExportFile();
        $this->ctrl->redirect($this, "showExportList");
    }
    
    public function downloadExportFile()
    {
        $file = str_replace("..", "", $_GET['file']);
        $export = new ilSCORM2004Export($this->node_object);
        $export_dir = $export->getExportDirectoryForType($_GET['type']);
        ilUtil::deliverFile($export_dir . "/" . $file, $file);
    }
    
    /**
    * confirmation screen for export file deletion
    */
    public function confirmDeleteExportFile()
    {
        $lng = $this->lng;
        $tpl = $this->tpl;
        
        if (!isset($_POST["file"])) {
            ilUtil::sendInfo($lng->txt("no_checkbox"), true);
            $this->ctrl->redirect($this, "showExportList");
        }

        ilUtil::sendQuestion($lng->txt("info_delete_sure"));
        $export_files = $this->node_object->getExportFiles();

        include_once "./Modules/Scorm2004/classes/class.ilSCORM2004ExportTableGUI.php";
        $table_gui = new ilSCORM2004ExportTableGUI($this, 'showExportList', true);
        $data = array();
        foreach ($export_files as $exp_file) {
            foreach ($_POST['file'] as $delete_file) {
                if (strcmp($delete_file, $exp_file['file']) == 0) {
                    $public_str = "";
                    //		$public_str = ($exp_file["file"] == $this->object->getPublicExportFile($exp_file["type"]))
                    //			? " <b>(".$this->lng->txt("public").")<b>"
                    //			: "";
                    $file_arr = explode("__", $exp_file["file"]);
                    array_push($data, array('file' => $exp_file['file'], 'date' => ilDatePresentation::formatDate(new ilDateTime($file_arr[0], IL_CAL_UNIX)), 'size' => $exp_file['size'], 'type' => $exp_file['type'] . $public_str));
                }
            }
        }
        $table_gui->setData($data);
        $tpl->setVariable('ADM_CONTENT', $table_gui->getHTML());
    }

    /**
    * cancel deletion of export files
    */
    public function cancelDeleteExportFile()
    {
        ilSession::clear("ilExportFiles");
        $this->ctrl->redirect($this, "showExportList");
    }


    /**
    * delete export files
    */
    public function deleteExportFile()
    {
        $lng = $this->lng;
        include_once "./Services/Utilities/classes/class.ilUtil.php";
        $export = new ilSCORM2004Export($this->node_object);
        foreach ($_POST['file'] as $idx => $file) {
            $export_dir = $export->getExportDirectoryForType($_POST['type'][$idx]);
            $exp_file = $export_dir . "/" . $file;
            if (@is_file($exp_file)) {
                unlink($exp_file);
            }
        }
        ilUtil::sendSuccess($lng->txt('msg_deleted_export_files'), true);
        $this->ctrl->redirect($this, "showExportList");
    }
    
    public function getExportResources()
    {
        $export_files = array();
        
        require_once "./Modules/Scorm2004/classes/class.ilSCORM2004Page.php";
        include_once "./Services/MediaObjects/classes/class.ilObjMediaObject.php";
        include_once "./Modules/File/classes/class.ilObjFile.php";
        $tree = new ilTree($this->slm_object->getId());
        $tree->setTableNames('sahs_sc13_tree', 'sahs_sc13_tree_node');
        $tree->setTreeTablePK("slm_id");
        $i = 0;
        foreach ($tree->getSubTree($tree->getNodeData($this->node_object->getId()), true, 'page') as $page) {
            $page_obj = new ilSCORM2004Page($page["obj_id"]);
            $page_obj->buildDom();
            $mob_ids = $page_obj->collectMediaObjects(false);
            foreach ($mob_ids as $mob_id) {
                if ($mob_id > 0 && ilObject::_exists($mob_id)) {
                    $path = ilObjMediaObject::_lookupStandardItemPath($mob_id, false, false);
                        
                    $media_obj = new ilObjMediaObject($mob_id);
                    $export_files[$i]["date"] = $media_obj->getCreateDate();
                    $export_files[$i]["size"] = @filesize($path); // could be remote, e.g. youtube video
                    $export_files[$i]["file"] = $media_obj->getTitle();
                    $export_files[$i]["type"] = $media_obj->getDescription();
                    $export_files[$i]["path"] = $path;
                    $this->ctrl->setParameter(
                        $this,
                        "resource",
                        rawurlencode(ilObjMediaObject::_lookupStandardItemPath($mob_id, false, false))
                        );
                    $export_files[$i]["link"] = $this->ctrl->getLinkTarget($this, "downloadResource");
                    $i++;
                }
            }
            include_once("./Services/COPage/classes/class.ilPCFileList.php");
            $file_ids = ilPCFileList::collectFileItems($page_obj, $page_obj->getDomDoc());
            foreach ($file_ids as $file_id) {
                $file_obj = new ilObjFile($file_id, false);
                $export_files[$i]["date"] = $file_obj->getCreateDate();
                $export_files[$i]["size"] = $file_obj->getFileSize();
                $export_files[$i]["file"] = $file_obj->getFileName();
                $export_files[$i]["type"] = $file_obj->getFileType();
                $export_files[$i]["file_id"] = $file_id;
                $this->ctrl->setParameter($this, "file_id", $file_id);
                $export_files[$i]["link"] = $this->ctrl->getLinkTarget($this, "downloadFile", "");
                $i++;
            }
            unset($page_obj);
        }
        
        return $export_files;
    }
    
    public function sco_resources()
    {
        $this->setTabs();
        $this->setLocator();
        $export_files = $this->getExportResources();

        $tab = new \ILIAS\Scorm2004\Editor\ilSCORMMediaOverviewTableGUI($this, "sco_resources");
        $tab->setData($export_files);

        $this->tpl->setContent($tab->getHTML());
    }
    
    public function downloadResource()
    {
        $export_files = $this->getExportResources();

        if ($_GET["file_id"] > 0) {
            $file = new ilObjFile($_GET["file_id"], false);
        }

        // check that file really belongs to SCORM module (security)
        foreach ($export_files as $f) {
            if (is_object($file)) {
                if ($f["file"] == $file->getFileName()) {
                    $file->sendFile();
                }
            } else {
                if ($f["path"] == $_GET["resource"]) {
                    if (is_file($f["path"])) {
                        ilUtil::deliverFile($f["path"], $f["file"]);
                    }
                }
            }
        }
        exit;
    }
    
    public function downloadFile()
    {
        $file = explode("_", $_GET["file_id"]);
        require_once("./Modules/File/classes/class.ilObjFile.php");
        $fileObj = new ilObjFile($file[count($file) - 1], false);
        $fileObj->sendFile();
        exit;
    }
    
    public function import()
    {
        $tpl = $this->tpl;
        $lng = $this->lng;
        
        $this->setTabs();
        $this->setLocator();
        
        $tpl->addBlockFile("ADM_CONTENT", "adm_content", "tpl.scormeditor_sco_import.html", "Modules/Scorm2004");
        
        $tpl->setVariable("TYPE_IMG", ilUtil::getImagePath('icon_lm.svg'));
        $tpl->setVariable("ALT_IMG", $lng->txt("obj_sahs"));
        
        $tpl->setVariable("FORMACTION", $this->ctrl->getFormAction($this));

        $tpl->setVariable("BTN_NAME", "importSave");
        
        // this leads to _top target which removes the left organization frame
        //$tpl->setVariable("TARGET", ' target="'.ilFrameTargetInfo::_getFrame("MainContent").'" ');

        $tpl->setVariable("TXT_UPLOAD", $lng->txt("upload"));
        $tpl->setVariable("TXT_CANCEL", $lng->txt("cancel"));
        $tpl->setVariable("TXT_IMPORT_SCO", $lng->txt("import_sco_object"));
        $tpl->setVariable("TXT_SELECT_FILE", $lng->txt("select_file"));
        $tpl->setVariable("TXT_VALIDATE_FILE", $lng->txt("cont_validate_file"));

        // get the value for the maximal uploadable filesize from the php.ini (if available)
        $umf = get_cfg_var("upload_max_filesize");
        // get the value for the maximal post data from the php.ini (if available)
        $pms = get_cfg_var("post_max_size");
        
        //convert from short-string representation to "real" bytes
        $multiplier_a = array("K" => 1024, "M" => 1024 * 1024, "G" => 1024 * 1024 * 1024);
        
        $umf_parts = preg_split("/(\d+)([K|G|M])/", $umf, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
        $pms_parts = preg_split("/(\d+)([K|G|M])/", $pms, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
        
        if (count($umf_parts) == 2) {
            $umf = $umf_parts[0] * $multiplier_a[$umf_parts[1]];
        }
        if (count($pms_parts) == 2) {
            $pms = $pms_parts[0] * $multiplier_a[$pms_parts[1]];
        }
        
        // use the smaller one as limit
        $max_filesize = min($umf, $pms);

        if (!$max_filesize) {
            $max_filesize = max($umf, $pms);
        }
    
        //format for display in mega-bytes
        $max_filesize = sprintf("%.1f MB", $max_filesize / 1024 / 1024);

        // gives out the limit as a little notice
        $tpl->setVariable("TXT_FILE_INFO", $lng->txt("file_notice") . " $max_filesize");
    }
    
    public function importSave()
    {
        $lng = $this->lng;
        $ilErr = $this->error;

        // check if file was uploaded
        $source = $_FILES["scormfile"]["tmp_name"];
        if (($source == 'none') || (!$source)) {
            $ilErr->raiseError("No file selected!", $ilErr->MESSAGE);
        }
        // get_cfg_var("upload_max_filesize"); // get the may filesize form t he php.ini
        switch ($_FILES["scormfile"]["error"]) {
            case UPLOAD_ERR_INI_SIZE:
                $ilErr->raiseError($lng->txt("err_max_file_size_exceeds"), $ilErr->MESSAGE);
                break;

            case UPLOAD_ERR_FORM_SIZE:
                $ilErr->raiseError($lng->txt("err_max_file_size_exceeds"), $ilErr->MESSAGE);
                break;

            case UPLOAD_ERR_PARTIAL:
                $ilErr->raiseError($lng->txt("err_partial_file_upload"), $ilErr->MESSAGE);
                break;

            case UPLOAD_ERR_NO_FILE:
                $ilErr->raiseError($lng->txt("err_no_file_uploaded"), $ilErr->MESSAGE);
                break;
        }

        $file = pathinfo($_FILES["scormfile"]["name"]);
        $name = substr($file["basename"], 0, strlen($file["basename"]) - strlen($file["extension"]) - 1);
        $file_path = $this->slm_object->getDataDirectory() . "/" . $this->node_object->getId() . "/" . $_FILES["scormfile"]["name"];
        ilUtil::createDirectory($this->slm_object->getDataDirectory() . "/" . $this->node_object->getId());
        ilUtil::moveUploadedFile($_FILES["scormfile"]["tmp_name"], $_FILES["scormfile"]["name"], $file_path);
        ilUtil::unzip($file_path);
        ilUtil::renameExecutables($this->slm_object->getDataDirectory() . "/" . $this->node_object->getId());
        
        include_once("./Modules/Scorm2004/classes/ilSCORM13Package.php");
        $newPack = new ilSCORM13Package();
        $newPack->il_importSco($this->slm_object->getId(), $this->node_object->getId(), $this->slm_object->getDataDirectory() . "/" . $this->node_object->getId());
            
        $this->ctrl->redirect($this, "showOrganization");
    }
    
    /**
    * Cancel action
    */
    public function cancel()
    {
        $this->ctrl->redirect($this, "showOrganization");
    }
    
    /**
     * Get sco glossary overlay id
     *
     * @param
     * @return
     */
    public static function getGlossaryOverviewId()
    {
        return "sco_glo_ov";
    }
    
    /**
     * des
     *
     * @param
     * @return
     */
    public static function getGloOverviewOv($a_sco)
    {
        global $DIC;

        $lng = $DIC->language();
        
        $tpl = new ilTemplate("tpl.sco_glossary_overview.html", true, true, "Modules/Scorm2004");
        
        $terms = $a_sco->getGlossaryTermIds();
        $lk = ilObjSAHSLearningModule::getAffectiveLocalization($a_sco->getSLMId());
        foreach ($terms as $k => $t) {
            $tpl->setCurrentBlock("link");
            $tpl->setVariable("TXT_LINK", $t);
            $tpl->setVariable("ID_LINK", "glo_ov_t" . $k);
            $tpl->parseCurrentBlock();
        }

        $tpl->setVariable("DIV_ID", ilSCORM2004ScoGUI::getGlossaryOverviewId());
        $tpl->setVariable("TXT_SCO_GLOSSARY", $lng->txtlng("content", "cont_sco_glossary", $lk));
        $tpl->setVariable("TXT_CLOSE", $lng->txtlng("common", "close", $lk));

        if (count($terms) > 1) {
            return $tpl->get();
        } else {
            return "";
        }
    }
}
