<?php

/**
 * Class ilADNAbstractGUI
 * @author            Fabian Schmid <fs@studer-raimann.ch>
 */
abstract class ilADNAbstractGUI
{
    const IDENTIFIER = 'identifier';

    /**
     * @var \ILIAS\DI\UIServices
     */
    protected $ui;
    /**
     * @var \ILIAS\DI\HTTPServices
     */
    protected $http;
    /**
     * @var ilToolbarGUI
     */
    protected $toolbar;
    /**
     * @var ilADNTabHandling
     */
    protected $tab_handling;
    /**
     * @var ilTabsGUI
     */
    protected $tabs;
    /**
     * @var ilLanguage
     */
    public $lng;
    /**
     * @var ilCtrl
     */
    protected $ctrl;
    /**
     * @var ilTemplate
     */
    public $tpl;
    /**
     * @var ilTree
     */
    public $tree;
    /**
     * @var ilObjAdministrativeNotificationAccess
     */
    protected $access;

    /**
     * ilADNAbstractGUI constructor.
     * @param ilADNTabHandling $tab_handling
     */
    public function __construct(ilADNTabHandling $tab_handling)
    {
        global $DIC;

        $this->tab_handling = $tab_handling;
        $this->tabs         = $DIC['ilTabs'];
        $this->lng          = $DIC->language();
        $this->ctrl         = $DIC['ilCtrl'];
        $this->tpl          = $DIC['tpl'];
        $this->tree         = $DIC['tree'];
        $this->toolbar      = $DIC['ilToolbar'];
        $this->http         = $DIC->http();
        $this->ui           = $DIC->ui();
        $this->access       = new ilObjAdministrativeNotificationAccess();

        $this->lng->loadLanguageModule('form');
    }

    /**
     * @param string|null $standard
     * @return string
     * @throws ilException
     */
    protected function determineCommand(string $standard = null) : ?string
    {
        $this->access->checkAccessAndThrowException('visible,read');
        $cmd = $this->ctrl->getCmd();
        if ($cmd !== '') {
            return $cmd;
        }

        return $standard;
    }

    abstract protected function dispatchCommand(string $cmd) : string;

    public function executeCommand() : void
    {
        $next_class = $this->ctrl->getNextClass();

        if ($next_class === '') {
            $cmd = $this->determineCommand();
            $this->tpl->setContent($this->dispatchCommand($cmd));

            return;
        }

        switch ($next_class) {
            case strtolower(ilADNNotificationGUI::class):
                $this->tab_handling->initTabs(ilObjAdministrativeNotificationGUI::TAB_MAIN, ilADNNotificationGUI::TAB_TABLE, false);
                $g = new ilADNNotificationGUI($this->tab_handling);
                $this->ctrl->forwardCommand($g);
                break;
            default:
                break;
        }
    }

}
