<?php

interface ilPDFRenderer
{
    /**
     * @param string              $service
     * @param string              $purpose
     * @param array               $config
     * @param \ilPDFGenerationJob $job
     *
     * @return void
     */
    public function generatePDF($service, $purpose, $config, $job);


    /**
     * Prepare the content processing at the beginning of a PDF generation request
     * Should be used to initialize the processing of latex code
     * The PDF renderers require different image formats generated by the MathJax service
     *
     * @param string              $service
     * @param string              $purpose
     * @return void
     */
    public function prepareGenerationRequest($service, $purpose);
}
