<?php

/* Copyright (c) 1998-2018 ILIAS open source, Extended GPL, see docs/LICENSE */

/**
 * Derived task data object
 *
 * @author killing@leifos.de
 * @ingroup ServicesTasks
 */
class ilDerivedTask
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var int
     */
    protected $ref_id;

    /**
     * @var int
     */
    protected $deadline;

    /**
     * @var int
     */
    protected $starting_time;

    /**
     * @var int
     */
    protected $wsp_id;

    /** @var string */
    protected $url = '';

    /**
     * Constructor
     * @param string $title
     * @param int $ref_id
     * @param int $deadline
     * @param int $starting_time
     * @param int $wsp_id
     */
    public function __construct(string $title, int $ref_id, int $deadline, int $starting_time, int $wsp_id)
    {
        $this->title = $title;
        $this->ref_id = $ref_id;
        $this->deadline = $deadline;
        $this->starting_time = $starting_time;
        $this->wsp_id = $wsp_id;
    }

    /**
     * Get ref id
     *
     * @return int
     */
    public function getRefId()
    {
        return $this->ref_id;
    }

    /**
     * Get wsp id
     *
     * @return int
     */
    public function getWspId()
    {
        return $this->wsp_id;
    }

    /**
     * @return int
     */
    public function getDeadline()
    {
        return $this->deadline;
    }

    /**
     * @return int
     */
    public function getStartingTime()
    {
        return $this->starting_time;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $url
     * @return ilDerivedTask
     */
    public function withUrl(string $url) : self
    {
        $clone = clone $this;
        $clone->url = $url;

        return $clone;
    }

    /**
     * @return string
     */
    public function getUrl() : string
    {
        return $this->url;
    }
}
