# Accessibility Guidelines

## PREAMBLE
According the [Strategy 2017](http://www.ilias.de/docu/goto_docu_file_5585_download.html)
ILIAS aims to to be "Usable for Everyone" including users with special needs.
ILIAS is to be perceivable, operable, understandable and of robust use for all users.
ILIAS enables users to locate, identify, access, and operate objects and services provided. 
These guidelines outline functional accessibility requirements as set out by EN 301 549. V2.1.2 of August 2018. Please consult [https://www.etsi.org/deliver/etsi_en/301500_301599/301549/02.01.02_30/en_301549v020102v.pdf](url)
EN 301 549 reflects WCAG 2.1 Recommendation Level A and AA. Please consult [https://www.w3.org/TR/WCAG21/] this document is referenced below. For each success criterion there are additional links provided on "Understanding this Particular Success Criterion" and "How to Meet this particular Success Criterion": We encourage developers to look up this information as it is a valuable self-education resource. 
These guidelines reference both documents. 
Because ILIAS is rendered in a browser it is categorised as a ‘web page’ by EN 301 549, even though this might not feel right to us. ```

CAVEAT: ILIAS purpose however is to facilitate learning which typically involves content. This content is categorised either as ‘non-web document’ or as ‘web page’. The content is generated by users and beyond the control of ILIAS and thus not covered by these guidelines. Editors and forms allowing users to generate content are to encourage producing accessible output if possible.

HTML-Content rendered by ILIAS shall conform to EN 301 549 / WCAG 2.1 Recommendation Level A and AA. 
1.	Controls provide at least one mode of operation that does not require vision. 
2.	Visual modes of operation provide features enabling users to make better use of their limited vision. 
3.	No mode of operation relies exclusively on the perception of colour, there is at least one additional method of distinction. 
4.	If there ever was an auditory mode of operation, there must be at least one mode of operation that does not require hearing. 
5.	If there ever was a vocal mode of operation, there must be at least one mode that can be operated without vocal output. 
6.	Controls that require manual action provide at least one mode of operation that does not require manipulation or hand strength. 
7.	No control has the potential for triggering photosensitive seizures. 
8.	We will do our best to accommodate users with limited cognitive, language or learning abilities. 
9.	ILIAS can be operated with assistive technology without compromising the privacy of a user. 

If proposing a new KS component, one MUST make sure the element conforms with the guideline listed here. If the conformity can only be achieved by the client of the element, one has to state a rule refering back to the corresponding rule in this document

## Principle 1: Perceivable
Reference: WCAG 2.1 > 1 / EN 301 549 > 9.1 

Information and user interface components MUST be presentable to users in ways they can perceive.

### Guideline Text Alternatives
Reference: WCAG 2.1 > 1.1 / EN 301 549 > 9.1.1

One MUST provide text alternatives for any non-text content so that it can be changed into other
forms people need, such as large print, braille, speech, symbols or simpler language.
  
#### Success Criterion Non-text Content
Reference: WCAG 2.1 > 1.1.1 Level A / EN 301 549 > 9.1.1.1

Target group: creator of content, developers for non-text-controls

[Understanding Non-text Content](https://www.w3.org/WAI/WCAG21/Understanding/non-text-content.html)

[Meeting Non-text Content](https://www.w3.org/WAI/WCAG21/quickref/#non-text-content)

All non-text content that is presented to the user MUST have a text
alternative that serves the equivalent purpose, except for the situations listed below:

  - **Controls, Input**: If non-text content is a control or accepts user input, then it
  MUST have a name that describes its purpose.

  - **Time-Based Media**: If non-text content is time-based media, then text alternatives
  MUST at least provide descriptive identification of the non-text content.

  - **Test**: If non-text content is a test or exercise that would be invalid if presented in text, then text alternatives MUST at least provide descriptive identification of the non-text content.
  
  - **Sensory**: If non-text content is primarily intended to create a specific sensory experience, then text alternatives MUST at least provide descriptive identification of the non-text content.

  - **CAPTCHA**: If the purpose of non-text content is to confirm that content is being
  accessed by a person rather than a computer, then text alternatives that identify and
  describe the purpose of the non-text content MUST be provided, and alternative forms of
  CAPTCHA using output modes for different types of sensory perception MUST be provided to
  accommodate different disabilities.

  - **Decoration, Formatting, Invisible**: If non-text content is pure decoration, is used
  only for visual formatting, or is not presented to users, then it SHOULD be implemented in a
  way that it can be ignored by assistive technology. 

### Guideline Time-based Media
Reference: WCAG 2.1 > 1.2 / EN 301 549 > 9.1.2

One MUST provide alternatives for time-based media.

#### Success Criterion Audio-only and Video-only (Prerecorded)
Reference: WCAG 2.1 > 1.2.1 Level A / EN 301 549 > 9.1.2.1

Target group: creator of content

[Understanding Audio-only and Video-only (Prerecorded)](https://www.w3.org/WAI/WCAG21/Understanding/audio-only-and-video-only-prerecorded.html)

[Meeting Audio-only and Video-only (Prerecorded)](https://www.w3.org/WAI/WCAG21/quickref/#audio-only-and-video-only-prerecorded)

An alternative for time-based media or audio description of the prerecorded video content MUST be provided for synchronized media, except when the media is a media alternative for text and is clearly labeled as such.

 - **Prerecorded Audio-only**: An alternative for time-based media MUST be provided that presents equivalent information for prerecorded audio-only content.
 - **Prerecorded Video-only**: Either an alternative for time-based media or an audio track MUST be provided that presents equivalent information for prerecorded video-only content.

#### Success Criterion Captions (Prerecorded)
Reference: WCAG 2.1 > 1.2.2 Level A / EN 301 549 > 9.1.2.2 

Target group: creator of content

[Understanding Captions (Prerecorded)](https://www.w3.org/WAI/WCAG21/Understanding/captions-prerecorded.html)

[Meeting Captions (Prerecorded)](https://www.w3.org/WAI/WCAG21/quickref/#captions-prerecorded)

Captions MUST be provided for all prerecorded audio content in synchronized media, except when the media is a media alternative for text and is clearly labeled as such.

#### Success Criterion Audio Description or Media Alternative (Prerecorded)
Reference: WCAG 2.1 > 1.2.3 Level A  / EN 301 549 > 9.1.2.3

Target group: creator of content

[Understanding Audio Description or Media Alternative (Prerecorded)](https://www.w3.org/WAI/WCAG21/Understanding/audio-description-or-media-alternative-prerecorded.html)

[Meeting Audio Description or Media Alternative (Prerecorded)](https://www.w3.org/WAI/WCAG21/quickref/#audio-description-or-media-alternative-prerecorded)

An alternative for time-based media or audio description of the prerecorded video content MUST be provided for synchronized media, except when the media is a media alternative for text and is clearly labeled as such.

#### Success Criterion Captions (Live)
Reference: WCAG 2.1 > 1.2.4 Level AA  / EN 301 549 > 9.1.2.4

Target group: creator of content

[Understanding Captions (Prerecorded)](https://www.w3.org/WAI/WCAG21/Understanding/captions-prerecorded.html)

[Meeting Captions (Prerecorded)](https://www.w3.org/WAI/WCAG21/quickref/#captions-prerecorded)

Captions MUST be provided for all live audio content in synchronized media.

#### Success Criterion Audio Description (Prerecorded)
Reference: WCAG 2.1 > 1.2.5 Level AA / EN 301 549 > 9.1.2.5

Target group: creator of content

[Understanding Audio Description or Media Alternative (Prerecorded)](https://www.w3.org/WAI/WCAG21/Understanding/audio-description-or-media-alternative-prerecorded.html)

[Meeting Audio Description or Media Alternative (Prerecorded)](https://www.w3.org/WAI/WCAG21/quickref/#audio-description-or-media-alternative-prerecorded)

Audio description MUST be provided for all prerecorded video content in synchronized media.

#### Guideline Adaptable
Reference: WCAG 2.1 > 1.3 / EN 301 549 > 9.1.3

One MUST create content that can be presented in different ways (for example simpler layout)
without losing information or structure.

#### Success Criterion Info and Relationships
Reference: WCAG 2.1 > 1.3.1 Level A / EN 301 549 > 9.1.3.1

Target group: creator of content, developer

[Understanding Info and Relationships](https://www.w3.org/WAI/WCAG21/Understanding/info-and-relationships.html)

[Meeting Info and Relationships](https://www.w3.org/WAI/WCAG21/quickref/#info-and-relationships)

Information, structure, and relationships conveyed through presentation MUST be programmatically determined or are available in text.

#### Success Criterion Meaningful Sequence
Reference: WCAG 2.1 > 1.3.2 Level A / EN 301 549 > 9.1.3.1

Target group: creator of content, developer

[Understanding Meaningful Sequence](https://www.w3.org/WAI/WCAG21/Understanding/meaningful-sequence.html)

[Meeting Meaningful Sequence](https://www.w3.org/WAI/WCAG21/quickref/#meaningful-sequence)

When the sequence in which content is presented affects its meaning, a correct reading sequence MUST be programmatically determined.

#### Success Criterion Sensory Characteristics
Reference: WCAG 2.1 > 1.3.3 Level A / EN 301 549 > 9.1.3.3

Target group: creator of content, developer

[Understanding Sensory Characteristics](https://www.w3.org/WAI/WCAG21/Understanding/sensory-characteristics.html)

[Meeting Sensory Characteristics](https://www.w3.org/WAI/WCAG21/quickref/#sensory-characteristics)

Instructions provided for understanding and operating content MUST not rely solely on sensory characteristics of components such as shape, size, visual location, orientation, or sound.

#### Success Criterion Criterion Orientation
Reference: WCAG 2.1 > 1.3.4 Level AA / EN 301 549 > 9.1.3.4

Target group: creator of content, developer

[Understanding Orientation](https://www.w3.org/WAI/WCAG21/Understanding/orientation.html)

[Meeting Orientation](https://www.w3.org/WAI/WCAG21/quickref/#orientation)

Content MUST not restrict its view and operation to a single display orientation, such as portrait or landscape, unless a specific display orientation is essential.

#### Success Criterion Identify Input Purpose
Reference: WCAG 2.1 > 1.3.5 Level AA / EN 301 549 > 9.1.3.5

Target group: developer

[Understanding Identify Input Purpose](https://www.w3.org/WAI/WCAG21/Understanding/identify-input-purpose.html)

[Meeting Identify Input Purpose](https://www.w3.org/WAI/WCAG21/quickref/#identify-input-purpose)

The purpose of each input field collecting information about the user MUST be programmatically determined when:

- The input field serves a purpose identified in the Input Purposes for User Interface Components section; and
- The content is implemented using technologies with support for identifying the expected meaning for form input data.

### Guideline 1.4 Distinguishable
Reference: WCAG 2.1 > 1.4 / EN 301 549 > 9.1.4

One MUST make it easier for users to see and hear content including separating foreground from background.

#### Success Criterion Use of Color
Reference: WCAG 2.1 > 1.4.1 Level A / EN 301 549 > 9.1.4.1

Target group: creator of content, developer

[Understanding Use of Color](https://www.w3.org/WAI/WCAG21/Understanding/use-of-color.html)

[Meeting Use of Color](https://www.w3.org/WAI/WCAG21/quickref/#use-of-color)

Color MUST not be used as the only visual means of conveying information, indicating an action, prompting a response, or distinguishing a visual element.

#### Success Criterion Audio Control
Reference: WCAG 2.1 > 1.4.2 Level A / EN 301 549 > 9.1.4.2

Target group: creator of content

[Understanding Audio Control](https://www.w3.org/WAI/WCAG21/Understanding/audio-control.html)

[Meeting Audio Control](https://www.w3.org/WAI/WCAG21/quickref/#audio-control)

If any audio on a Web page plays automatically for more than 3 seconds, either a mechanism MUST be available to pause or stop the audio, or a mechanism MUST be available to control audio volume independently from the overall system volume level.

#### Success Criterion Contrast Minimum
Reference: WCAG 2.1 > 1.4.3 Level AA / EN 301 549 > 9.1.4.3

Target group: creator of content, developer

[Understanding Contrast Minimum](https://www.w3.org/WAI/WCAG21/Understanding/contrast-minimum.html)

[Meeting Contrast Minimum](https://www.w3.org/WAI/WCAG21/quickref/#contrast-minimum)

The visual presentation of text and images of text MUST have a contrast ratio of at least 4.5:1, except for the following:

- **Large Text**: Large-scale text and images of large-scale text MUST have a contrast ratio of at least 3:1;
- **Incidental**: Text or images of text that are part of an inactive user interface component, that are pure decoration, that are not visible to anyone, or that are part of a picture that contains significant other visual content, have no contrast requirement.
- **Logotypes**: Text that is part of a logo or brand name has no contrast requirement.

#### Success Criterion Resize text
Reference: WCAG 2.1 > 1.4.4 Level AA / EN 301 549 > 9.1.4.4

Target group: developer

[Understanding Resize text](https://www.w3.org/WAI/WCAG21/Understanding/resize-text.html)

[Meeting Resize text](https://www.w3.org/WAI/WCAG21/quickref/#resize-text)

Except for captions and images of text, it MUST be possible to resize text without assistive technology up to 200 percent without loss of content or functionality.

#### Success Criterion Images of Text
Reference: WCAG 2.1 > 1.4.5 Level AA / EN 301 549 > 9.1.4.5

Target group: creator of content, developer

[Understanding Images of Text](https://www.w3.org/WAI/WCAG21/Understanding/images-of-text.html)

[Meeting Images of Text](https://www.w3.org/WAI/WCAG21/quickref/#images-of-text)

If the technologies being used can achieve the visual presentation, text MUST be used to convey information rather than images of text except for the following:

- **Customizable**: The image of text can be visually customized to the user's requirements;
- **Essential**: A particular presentation of text is essential to the information being conveyed. Logotypes (text that is part of a logo or brand name) are considered essential.

#### Success Criterion Criterion Reflow
Reference: WCAG 2.1 > 1.4.10 Level AA / EN 301 549 > 9.1.4.10

Target group: creator of content, developer

[Understanding Reflow](https://www.w3.org/WAI/WCAG21/Understanding/reflow.html)

[Meeting Reflow](https://www.w3.org/WAI/WCAG21/quickref/#reflow)

Content MUST be presented without loss of information or functionality, and without requiring scrolling in two dimensions for:

- Vertical scrolling content at a width equivalent to 320 CSS pixels;

- Horizontal scrolling content at a height equivalent to 256 CSS pixels.

Except for parts of the content which require two-dimensional layout for usage or meaning.
Examples of content which require two-dimensional layout are images, maps, diagrams, video, games, presentations, data tables, and interfaces where it is necessary to keep toolbars in view while manipulating content.

#### Success Criterion Non-text Contrast
Reference: WCAG 2.1 > 1.4.11 Level AA / EN 301 549 > 9.1.4.11

Target group: creator of content, developer

[Understanding Non-text Contrast](https://www.w3.org/WAI/WCAG21/Understanding/non-text-contrast.html)

[Meeting Non-text Contrast](https://www.w3.org/WAI/WCAG21/quickref/#non-text-contrast)

The visual presentation of the following MUST have a contrast ratio of at least 3:1 against adjacent color(s):

- **User Interface Components**: Visual information required to identify user interface components and states, except for inactive components or where the appearance of the component is determined by the user agent and not modified by the author;

- **Graphical Objects**: Parts of graphics required to understand the content, except when a particular presentation of graphics is essential to the information being conveyed.

#### Success Criterion Text Spacing
Reference: WCAG 2.1 > 1.4.12 Level AA / EN 301 549 > 9.1.4.12

Target group: creator of content, developer

[Understanding Text Spacing](https://www.w3.org/WAI/WCAG21/Understanding/text-spacing.html)

[Meeting Text Spacing](https://www.w3.org/WAI/WCAG21/quickref/#text-spacing)

In content implemented using markup languages that support the following text style properties, no loss of content or functionality MUST occur by setting all of the following and by changing no other style property:

- Line height (line spacing) to at least 1.5 times the font size;

-	Spacing following paragraphs to at least 2 times the font size;

-	Letter spacing (tracking) to at least 0.12 times the font size;

-	Word spacing to at least 0.16 times the font size.

Exception: Human languages and scripts that do not make use of one or more of these text style properties in written text can conform using only the properties that exist for that combination of language and script.

#### Success Criterion Content on Hover or Focus
Reference: WCAG 2.1 > 1.4.13 Level AA / EN 301 549 > 9.1.4.13

Target group: developer

[Understanding Content on Hover or Focus](https://www.w3.org/WAI/WCAG21/Understanding/content-on-hover-or-focus.html)

[Meeting Content on Hover or Focus](https://www.w3.org/WAI/WCAG21/quickref/#content-on-hover-or-focus)

Where receiving and then removing pointer hover or keyboard focus triggers additional content to become visible and then hidden, the following MUST be true:

- **Dissmissable**: A mechanism is available to dismiss the additional content without moving pointer hover or keyboard focus, unless the additional content communicates an input error or does not obscure or replace other content;

- **Hoverable**: If pointer hover can trigger the additional content, then the pointer can be moved over the additional content without the additional content disappearing;

- **Persistent**: The additional content remains visible until the hover or focus trigger is removed, the user dismisses it, or its information is no longer valid.

Exception: The visual presentation of the additional content is controlled by the user agent and is not modified by the author.
Custom tooltips, sub-menus, and other nonmodal popups that display on hover and focus are examples of additional content covered by this criterion.

### Principle Operable
Reference: WCAG 2.1 > 2. / EN 301 549 > 9.2

User interface components and navigation MUST be operable.

#### Guideline Keyboard Accessible
Reference: WCAG 2.1 > 2.1 / EN 301 549 > 9.2.1

All functionality MUST be available from a keyboard.

#### Success Criterion Keyboard
Reference: WCAG 2.1 > 2.1.1 Level A / EN 301 549 > 9.2.1.1

Target group: creator of content, developer

[Understanding Keyboard](https://www.w3.org/WAI/WCAG21/Understanding/keyboard.html)

[Meeting Keyboard](https://www.w3.org/WAI/WCAG21/quickref/#keyboard)

All functionality of the content MUST be operable through a keyboard interface without requiring specific timings for individual keystrokes, except where the underlying function requires input that depends on the path of the user's movement and
not just the endpoints. This exception relates to the underlying function, not the input technique. For example, if using handwriting to enter text, the input technique (handwriting) requires path-dependent input but the underlying function (text input) does not.  This does not forbid and should not discourage providing mouse input or other input methods in addition to keyboard operation.

#### Success Criterion No Keyboard Trap
Reference: WCAG 2.1 > 2.1.2 Level A / EN 301 549 > 9.2.1.2

Target group: developer

[Understanding No Keyboard Trap](https://www.w3.org/WAI/WCAG21/Understanding/no-keyboard-trap.html)

[Meeting No Keyboard Trap](https://www.w3.org/WAI/WCAG21/quickref/#no-keyboard-trap)

If keyboard focus can be moved to a component of the page using a keyboard interface, then focus MUST be movable away from that component using only a keyboard interface, and, if it requires more than unmodified arrow or tab keys or other
standard exit methods, the user is advised of the method for moving focus away.  
Note: Since any content that does not meet this success criterion can interfere with a user's ability to use the whole page, all content on the Web page (whether it is used to meet other success criteria or not) MUST meet this success criterion.

#### Success Criterion Character Key Shortcuts
Reference: WCAG 2.1 > 2.1.4 Level A / EN 301 549 > 9.2.1.4

Target group: developer

[Understanding Character Key Shortcuts](https://www.w3.org/WAI/WCAG21/Understanding/character-key-shortcuts.html)

[Meeting Character Key Shortcuts](https://www.w3.org/WAI/WCAG21/quickref/#character-key-shortcuts)

If a keyboard shortcut is implemented in content using only letter (including upper- and lower-case letters), punctuation, number, or symbol characters, then at least one of the following MUST be true:

- **Turn off**: A mechanism is available to turn the shortcut off;
- **Remap**: A mechanism is available to remap the shortcut to use one or more non-printable keyboard characters (e.g. Ctrl, Alt, etc);
- **Active only on focus**: The keyboard shortcut for a user interface component is only active when that component has focus.

### Guideline 2.2 Enough Time
Reference: WCAG 2.1 > 2.2 / EN 301 549 > 9.2.2

Users MUST be provided enough time to read and use content.

#### Success Criterion Timing Adjustable
Reference: WCAG 2.1 > 2.2.1 Level A / EN 301 549 > 9.2.2.1

Target group: creator of content

[Understanding Timing Adjustable](https://www.w3.org/WAI/WCAG21/Understanding/timing-adjustable.html)

[Meeting Timing Adjustable](https://www.w3.org/WAI/WCAG21/quickref/#timing-adjustable)

For each time limit that is set by the content, at least one of the following MUST be true:

  - **Turn off**: The user is allowed to turn off the time limit before encountering it; or

  - **Adjust**: The user is allowed to adjust the time limit before encountering it over a
  wide range that is at least ten times the length of the default setting; or

  - **Extend**: The user is warned before time expires and given at least 20 seconds to
  extend the time limit with a simple action (for example, "press the space bar"), and
  the user is allowed to extend the time limit at least ten times; or

  - **Real-time Exception**: The time limit is a required part of a real-time event (for
  example, an auction), and no alternative to the time limit is possible; or

  - **Essential Exception**: The time limit is essential and extending it would invalidate
  the activity; or

  - **20 Hour Exception**: The time limit is longer than 20 hours.

#### Success Criterion Pause, Stop, Hide
Reference: WCAG 2.1 > 2.2.2 Level A / EN 301 549 > 9.2.2.2

Target group: creator of content

[Understanding Pause, Stop, Hide](https://www.w3.org/WAI/WCAG21/Understanding/pause-stop-hide.html)

[Meeting Pause, Stop, Hide](https://www.w3.org/WAI/WCAG21/quickref/#pause-stop-hide)

For moving, blinking, scrolling, or auto-updating information, all of the following MUST be true:

  - **Moving, blinking, scrolling**: For any moving, blinking or scrolling information that
   (1) starts automatically, (2) lasts more than five seconds, and (3) is presented in
   parallel with other content, there is a mechanism for the user to pause, stop, or
   hide it unless the movement, blinking, or scrolling is part of an activity where it
   is essential; and

  - **Auto-updating**: For any auto-updating information that (1) starts automatically and
  (2) is presented in parallel with other content, there is a mechanism for the user to
   pause, stop, or hide it or to control the frequency of the update unless the
   auto-updating is part of an activity where it is essential.

### Guideline Seizures
Reference: WCAG 2.1 > 2.3 / EN 301 549 > 9.2.3

One MUST not design content in a way that is known to cause seizures.

#### Success Criterion Three Flashes or Below Threshold
Reference: WCAG 2.1 > 2.3.1 Level A / EN 301 549 > 9.2.3.1

Target group: creator of content

[Understanding Three Flashes or Below Threshold](https://www.w3.org/WAI/WCAG21/Understanding/three-flashes-or-below-threshold.html)

[Meeting Three Flashes or Below Threshold](https://www.w3.org/WAI/WCAG21/quickref/#three-flashes-or-below-threshold)

Web pages MUST not contain anything that flashes more than three times in any one second period, or the flash is below the general flash and red flash thresholds.

### Guideline Navigable
Reference: WCAG 2.1 > 2.4 / EN 301 549 > 9.2.4

One MUST provide ways to help users navigate, find content, and determine where they are.

#### Success Criterion Bypass Blocks
Reference: WCAG 2.1 > 2.4.1 Level A / EN 301 549 > 9.2.4.1 

Target group: developer

[Understanding Bypass Blocks](https://www.w3.org/WAI/WCAG21/Understanding/bypass-blocks.html)

[Meeting Bypass Blocks](https://www.w3.org/WAI/WCAG21/quickref/#bypass-blocks)

A mechanism MUST be available to bypass blocks of content that are repeated on multiple Web pages.

#### Success Criterion Page Titled
Reference: WCAG 2.1 > 2.4.2 Level A  / EN 301 549 > 9.2.4.2

Target group: developer

[Understanding Page Titled](https://www.w3.org/WAI/WCAG21/Understanding/page-titled.html)

[Meeting Page Titled](https://www.w3.org/WAI/WCAG21/quickref/#page-titled)

Web pages MUST have titles that describe topic or purpose.

#### Success Criterion Focus Order
Reference: WCAG 2.1 > 2.4.3 Level A  / EN 301 549 > 9.2.4.3

Target group: developer

[Understanding Focus Order](https://www.w3.org/WAI/WCAG21/Understanding/focus-order.html)

[Meeting Focus Order](https://www.w3.org/WAI/WCAG21/quickref/#focus-order)

If a Web page can be navigated sequentially and the navigation sequences affect meaning or operation, focusable components MUST receive focus in an order that preserves meaning and operability.

#### Success Criterion Link Purpose (In Context)
Reference: WCAG 2.1 > 2.4.4 Level A  / EN 301 549 > 9.2.4.4

Target group: creator of content, developer

[Understanding Link Purpose (In Context)](https://www.w3.org/WAI/WCAG21/Understanding/link-purpose-in-context.html)

[Meeting Link Purpose (In Context)](https://www.w3.org/WAI/WCAG21/quickref/#link-purpose-in-context)

One MUST be able to determine the purpose of each link from the link text alone or from the link text together with its programmatically determined link context, except where the purpose of the link would be ambiguous to users in general.

#### Success Criterion Multiple Ways
Reference: WCAG 2.1 > 2.4.5 Level AA / EN 301 549 > 9.2.4.5

Target group: developer

[Understanding Multiple Ways](https://www.w3.org/WAI/WCAG21/Understanding/multiple-ways.html)

[Meeting Multiple Ways](https://www.w3.org/WAI/WCAG21/quickref/#multiple-ways)

More than one way MUST be available to locate a Web page within a set of Web pages except where the Web Page is the result of, or a step in, a process.

#### Success Criterion Headings and Labels
Reference: WCAG 2.1 > 2.4.6 Level AA / EN 301 549 > 9.2.4.6

Target group: creator of content, developer

[Understanding Headings and Labels](https://www.w3.org/WAI/WCAG21/Understanding/headings-and-labels.html)

[Meeting Headings and Labels](https://www.w3.org/WAI/WCAG21/quickref/#headings-and-labels)

Headings and labels MUST describe topic or purpose.

#### Success Criterion Focus Visible
Reference: WCAG 2.1 > 2.4.7 Level AA  / EN 301 549 > 9.2.4.7

Target group: developer

[Understanding Focus Visible](https://www.w3.org/WAI/WCAG21/Understanding/focus-visible.html)

[Meeting Focus Visible](https://www.w3.org/WAI/WCAG21/quickref/#focus-visible)

Any keyboard operable user interface MUST have a mode of operation where the keyboard focus indicator is visible.

### Guideline Modalities
Reference: WCAG 2.1 > 2.5 / EN 301 549 > 9.2.5

One SHOULD make it easier for users to operate functionality through various inputs beyond keyboard.

#### Success Criterion Pointer Gestures
Reference: WCAG 2.1 > 2.5.1 Level A / EN 301 549 > 9.2.5.1

Target group: developer

[Understanding Pointer Gestures](https://www.w3.org/WAI/WCAG21/Understanding/pointer-gestures.html)

[Meeting Pointer Gestures](https://www.w3.org/WAI/WCAG21/quickref/#pointer-gestures)

All functionality that uses multipoint or path-based gestures for operation MUST be able to be operated with a single pointer without a path-based gesture, unless a multipoint or path-based gesture is essential.
This requirement applies to web content that interprets pointer actions (i.e. this does not apply to actions that are required to operate the user agent or assistive technology).

#### Success Criterion Pointer Cancellation
Reference: WCAG 2.1 > 2.5.2 Level A / EN 301 549 > 9.2.5.2

Target group: developer

[Understanding Pointer Cancellation](https://www.w3.org/WAI/WCAG21/Understanding/pointer-cancellation.html)

[Meeting Pointer Cancellation](https://www.w3.org/WAI/WCAG21/quickref/#pointer-cancellation)

For functionality that can be operated using a single pointer, at least one of the following MUST be true:

- **No Down-Event**: The down-event of the pointer is not used to execute any part of the function;

- **Abort or Undo**: Completion of the function is on the up-event, and a mechanism is available to abort the function before completion or to undo the function after completion;

- **Up Reversal**: The up-event reverses any outcome of the preceding down-event;

- **Essential**: Completing the function on the down-event is essential.

#### Success Criterion  Label in Name
Reference: WCAG 2.1 > 2.5.3 Level A / EN 301 549 > 9.2.5.3

Target group: developer

[Understanding Label in Name](https://www.w3.org/WAI/WCAG21/Understanding/label-in-name.html)

[Meeting Label in Name](https://www.w3.org/WAI/WCAG21/quickref/#label-in-name)

For user interface components with labels that include text or images of text, the name MUST contain the text that is presented visually. A best practice is to have the text of the label at the start of the name.

#### Success Criterion Motion Actuation
Reference: WCAG 2.1 > 2.5.4 Level A / EN 301 549 > 9.2.5.4

Target group: developer

[Understanding Motion Actuation](https://www.w3.org/WAI/WCAG21/Understanding/motion-actuation.html)

[Meeting Motion Actuation](https://www.w3.org/WAI/WCAG21/quickref/#motion-actuation)

Functionality that can be operated by device motion or user motion MUST also be operable by user interface components and responding to the motion can be disabled to prevent accidental actuation, except when:

- **Supported Interface**: The motion is used to operate functionality through an accessibility supported interface;
- **Essential**: The motion is essential for the function and doing so would invalidate the activity.

## Principle Understandable
Reference: WCAG 2.1 > 3. / EN 301 549 > 9.3

Information and the operation of user interface MUST be understandable.

### Guideline Readable
Reference: WCAG 2.1 > 3.1 / EN 301 549 > 9.3.1

Text content MUST be readable and understandable.

#### Success Criterion Language of Page
Reference: WCAG 2.1 > 3.1.1 Level A / EN 301 549 > 9.3.1.1

Target group: developer

[Understanding Language of Page](https://www.w3.org/WAI/WCAG21/Understanding/language-of-page.html)

[Meeting Language of Page](https://www.w3.org/WAI/WCAG21/quickref/#language-of-page)

The default human language of each Web page MUST be determinable programmatically.

#### Success Criterion Language of Parts
Reference: WCAG 2.1 > 3.1.2 Level AA / EN 301 549 > 9.3.1.2

Target group: developer

[Understanding Language of Parts](https://www.w3.org/WAI/WCAG21/Understanding/language-of-parts.html)

[Meeting Language of Parts](https://www.w3.org/WAI/WCAG21/quickref/#language-of-parts)

The human language of each passage or phrase in the content MUST be determinable programmatically except for proper names, technical terms, words of indeterminate language, and words or phrases that have become part of the vernacular of the immediately surrounding text.

### Guideline Predictable
Reference: WCAG 2.1 > 3. / EN 301 549 > 9.3

Web pages MUST appear and operate in predictable ways.

#### Success Criterion On Focus
Reference: WCAG 2.1 > 3.2.1 Level A / EN 301 549 > 9.3.2.1

Target group: developer

[Understanding On Focus](https://www.w3.org/WAI/WCAG21/Understanding/on-focus.html)

[Meeting On Focus](https://www.w3.org/WAI/WCAG21/quickref/#on-focus)

When any component receives focus, it MUST not initiate a change of context.

#### Success Criterion On Input
Reference: WCAG 2.1 > 3.2.2 Level A / EN 301 549 > 9.3.2.2

Target group: developer

[Understanding On Input](https://www.w3.org/WAI/WCAG21/Understanding/on-input.html)

[Meeting On Input](https://www.w3.org/WAI/WCAG21/quickref/#on-input)

Changing the setting of any user interface component MUST not automatically cause a change of context unless the user has been advised of the behavior before using the component.

#### Success Criterion Consistent Navigation
Reference: WCAG 2.1 > 3.2.3 Level AA / EN 301 549 > 9.3.2.3

Target group: developer

[Understanding Consistent Navigation](https://www.w3.org/WAI/WCAG21/Understanding/consistent-navigation.html)

[Meeting Consistent Navigation](https://www.w3.org/WAI/WCAG21/quickref/#consistent-navigation)

Navigational mechanisms that are repeated on multiple Web pages within a set of Web pages MUST occur in the same relative order each time they are repeated, unless a change is initiated by the user.

#### Success Criterion Consistent Identification
Reference: WCAG 2.1 > 3.2.4 Level AA / EN 301 549 > 9.3.2.4

Target group: developer

[Understanding Consistent Identification](https://www.w3.org/WAI/WCAG21/Understanding/consistent-identification.html)

[Meeting Consistent Identification](https://www.w3.org/WAI/WCAG21/quickref/#consistent-identification)

Components that have the same functionality within a set of Web pages MUST be identified consistently.

### Guideline Input Assistance
Reference: WCAG 2.1 > 3.3 / EN 301 549 > 9.3.3

One MUST help users avoid and correct mistakes.

#### Success Criterion Error Identification
Reference: WCAG 2.1 > 3.3.1 Level A / EN 301 549 > 9.3.3.1

Target group: developer

[Understanding Error Identification](https://www.w3.org/WAI/WCAG21/Understanding/error-identification.html)

[Meeting Error Identification](https://www.w3.org/WAI/WCAG21/quickref/#error-identification)

If an input error is automatically detected, the item that is in error MUST be identified and the error MUST be described to the user in text.

#### Success Criterion Labels or Instructions
Reference: WCAG 2.1 > 3.3.2 Level A / EN 301 549 > 9.3.3.2

Target group: developer

[Understanding Labels or Instructions](https://www.w3.org/WAI/WCAG21/Understanding/labels-or-instructions.html)

[Meeting Labels or Instructions](https://www.w3.org/WAI/WCAG21/quickref/#labels-or-instructions)

Labels or instructions MUST be provided when content requires user input.

#### Success Criterion Error Suggestion
Reference: WCAG 2.1 > 3.3.3 Level AA / EN 301 549 > 9.3.3.3

Target group: developer
[Understanding Error Suggestion](https://www.w3.org/WAI/WCAG21/Understanding/error-suggestion.html)

[Meeting Error Suggestion](https://www.w3.org/WAI/WCAG21/quickref/#error-suggestion)

If an input error is automatically detected and suggestions for correction are known, then the suggestions MUST be provided to the user, unless it would jeopardize the security or purpose of the content.

#### Success Criterion Error Prevention (Legal, Financial, Data)
Reference: WCAG 2.1 > 3.3.4 Level AA / EN 301 549 > 9.3.3.4

Target group: developer

[Understanding Error Prevention (Legal, Financial, Data)](https://www.w3.org/WAI/WCAG21/Understanding/error-prevention-legal-financial-data.html)

[Meeting Error Prevention (Legal, Financial, Data)](https://www.w3.org/WAI/WCAG21/quickref/#error-prevention-legal-financial-data)

For Web pages that cause legal commitments or financial transactions for the user to occur, that modify or delete user-controllable data in data storage systems, or that submit user test responses, at least one of the following MUST be true:

- **Reversible**: Submissions are reversible.
- **Checked**: Data entered by the user is checked for input errors and the user is provided an opportunity to correct them.
- **Confirmed**: A mechanism is available for reviewing, confirming, and correcting information before finalizing the submission.

### Principle Robust
Reference: WCAG 2.1 > 4. / EN 301 549 > 9.4

Content MUST be robust enough that it can be interpreted reliably by a wide variety of user agents, including assistive technologies.

### Guideline Compatible
Reference: WCAG 2.1 > 4.1 / EN 301 549 > 9.4.1

One MUST maximize compatibility with current and future user agents, including assistive technologies.

#### Success Criterion Parsing
Reference: WCAG 2.1 > 4.1.1 Level A / EN 301 549 > 9.4.1.1

Target group: developer

[Understanding Parsing](https://www.w3.org/WAI/WCAG21/Understanding/parsing.html)

[Meeting Parsing](https://www.w3.org/WAI/WCAG21/quickref/#parsing)

In content implemented using markup languages, elements MUST have complete start and end tags, elements MUST be nested according to their specifications, elements MUST not contain duplicate attributes, and any IDs MUST be unique, except where the specifications allow these features. Start and end tags that are missing a critical character in their formation, such as a closing angle bracket or a mismatched attribute value quotation mark are not complete.

#### Success Criterion Name, Role, Value
Reference: WCAG 2.1 > 4.1.2 Level A / EN 301 549 > 9.4.1.2

Target group: developer

[Understanding Name, Role, Value](https://www.w3.org/WAI/WCAG21/Understanding/name-role-value.html)

[Meeting Name, Role, Value](https://www.w3.org/WAI/WCAG21/quickref/#name-role-value)

For all user interface components (including but not limited to: form elements, links and components generated by scripts), the name and role MUST be determinable programmatically; states, properties, and values that can be set by the user MUST be programmatically settable; and notification of changes to these items MUST be available to user agents, including assistive technologies. This success criterion is primarily for Web authors who develop or script their own user interface components. For example, standard HTML controls already meet this success criterion when used according to specification.

#### Success Criterion Status Messages
Reference: WCAG 2.1 > 4.1.3 Level AA / EN 301 549 > 9.4.1.3

Target group: developer

[Understanding Status Messages](https://www.w3.org/WAI/WCAG21/Understanding/status-messages.html)

[Meeting Status Messages](https://www.w3.org/WAI/WCAG21/quickref/#status-messages)

In content implemented using markup languages, status messages MUST be programmatically determined through role or properties such that they can be presented to the user by assistive technologies without receiving focus.

# Cheat Sheet
This list is prepared to inform developers what accessibility means for their daily work. This list was prepared by the SIG accessibility to their best knowledge. Still it may contain some errors. 
Thus, we suggest to use compliance testing as a yardstick for quality: Compliance testing is more important than these phrases, we will adapt these phrases via the jour fixe if compliance testing indicates they are erroneous or lacking information.  
We still hope the following list is helpful in everyday work.

## Structure 
Check how your suggested element fits into our semantic structures. 
1.	Write “well formed” HTML, employ HTML according to the specification with complete start and end tags and compliant nesting. Assistive technology will crash on missing start or end tags. (4.1.1)
2.	We use aria landmarks and headlines to furnish ILIAS with semantic structures. Regions of the page and navigation are structured by aria landmarks. Content gets structured by headlines. These elements provide programmatically determinable semantic structures to convey information and relationships (1.3.1).  
3.	Users must be able to skip ‘repeated content of second rank’ i.e. Secondary Panels (2.4.1). Use aria landmark role ‘complementary’ to make elements skippable. 
4.	Make the DOM order matche the visual order (1.3.2). When the source order matches the visual order, everyone will read the content and interact with it in the same (correct) order. If this will not work use tabindex 0. 
5.	Make sure that repeated navigational components occur in the same place and same relative order each time they appear. (3.2.3) 
## Headings and Labels and Language
6.	Our headings and labels have to be clear and descriptive (2.4.6). 
7.	Provide clear and descriptive labels for any field that requires input. AND one of the following (3.3.2)
	* Provide text instructions describing the necessary input in a by-line to the field.
	* Use aria-describedby property to provide information about a user interface element. 
8.	Always use the language attribute on the HTML element. Screen readers change pronunciation automatically. (3.1.1)
9.	Indicate the language for each chunk of text (3.1.2). Using the language attribute on the HTML element. Screen readers change pronunciation automatically. 
10.	Functional and informative components, i.e. labels and icons, must have consistent labels, aria-labels and alt-texts. 
## Alt-Texts and aria labels
11.	All non-text elements (icons, glyphs, images, graphs and the like) must have alt-texts (1.1.1). Do they? For all their statuses? 
12.	The aria-label for an element must contain the text the element presents (2.5.3). This is really important for speech input. 
13.	Use aria-label to provide an invisible label where a visible label cannot be used. (4.1.2)
14.	If drag & drop is used one has to make sure dropping can be cancel and that accessible names can be matched to visible labels. (2.5.2)
## Colour and Contrast
Please check your suggested element for colour and contrast issues. 

15.	Use of colour as a visual cue is only ok if it is accompanied by text or shape with alt-text 1.4.1.
16.	Text must have a contrast ratio of at least 4,5:1 to background for normal text and at least 3:1 for text bigger than 18 points in size (1.4.3). 
17.	Controls and states must have a contrast ratio of at least 3:1 against adjacent colours. Same applies for charts (result presentation) because they convey meaning (1.4.11). 
## Resize and Reflow
18.	ILIAS can be resized by up to 200 percent without loss of content or functionality (1.4.4).
19.	All Content can be presented without loss of information or functionality, and without requiring scrolling in two dimensions for: Vertical scrolling content at a width equivalent to 320 CSS pixels; Horizontal scrolling content at a height equivalent to 256 CSS pixels. 320 CSS pixels is equivalent to a starting viewport width of 1280 CSS pixels at 400% zoom. For web content which is designed to scroll horizontally (e.g., with vertical text), 256 CSS pixels is equivalent to a starting viewport height of 1024 CSS pixels at 400% zoom. (1.4.10)
## Forms
20.	Standard HTML controls meet accessibility requirements when used according to specification. If we prepare our own controls name and role MUST be determinable programmatically; states, properties, and values that can be set by the user MUST be programmatically settable; and notification of changes to these items MUST be available to user agents, including assistive technologies. (4.1.2)
21.	All input fields gathering information about the user have a label clearly stating the purpose of this field (1.3.5).
22.	Use an onchange event on a select element to update other elements i.e. in a form without causing a change of context. (3.2.2)
## Messages 
23.	Make users aware that an error has occurred and help them to determine what is wrong i.e. by indicating form fields in the error message.  Make failure messages as specific as possible.  (3.3.1)
	* Use aria-required property to identify required fields.
	* Use role aria-invalid on required fields that have no input. 
	* Use aria role alertdialog for the Failure message.  
24.	We must have confirmation dialogues before an action is taken that has serious consequences and / or cannot be reversed i.e. deleting objects. (3.3.4)
25.	Use the aria role status for status messages. (4.1.3)
## Extra Content 
26.	If an element like a tab gets keyboard focus or receives the pointer hover and then additional content i.e.  a tool tip or a popover is displayed. We have to make sure the additional content does not interfere with the usage of the rest of the page: The additional content must be dismissable for example by clicking Esc or X. The additional content must be hoverable itself and must not disappear once the trigger is left. (1.4.13)
## Tabbing and Focus
27.	All functionality must be operable by tabbing or number pad arrows. (2.1.1) 
28.	Users can tab to any control, operate it, and tab away again. (2.1.2) 
29.	Keyboard focus must be always visible. The element that has focus gets a corona. (2.4.7) 
30.	Tabbing order must be sensible and predictable. The move of focus is following the meaning of the content and can be operated by tab. Moving focus should not jump around unpredictably. (2.4.3)
31.	If an element gains focus it must not
	* transfer users to a different context automatically and without warning i.e. open a new window. 
	* Carry out an action automatically i.e. submit a form after a save-button received focus. 
Give users advanced warning when opening a new window i.e. by using the target attribute which provides an unambiguously machine-readable indication that a new window will open. (3.2.1)
Give users a submit-button to initiate change of context. 
## Access Keys
32.	Important new functionality should get Access Keys. 
33.	Access Keys can be remapped to non-prinatble characters i.e.Ctrl to avoid being carried out accidentally (2.1.4). This is important for users using speech input, which could become a nuisance.  
Moving information
34.	Any moving, blinking, scrolling, or auto-updating information that starts automatically and goes on must offer an option for users to pause, stop or hide it (2.2.2)
35.	Consult https://www.w3.org/TR/wai-aria-practices-1.2/ to obtain guidance for your respective suggestion. 
## Manipulation by gestures
36.	People must be able to operate ILIAS with a single pointer (finger or mouse) and low accuracy (2.5.1). Making people use two fingers to enlarge something is not OK. Making people grab something and accurately put it first to point A to progress to point B is not OK.
## Requirements we meet and do not have to work on 

* ILIAS deals equally well with landscape and portrait orientation. To use show/hide controls for different orientations is fine. (1.3.4)
* We do not use images of text except for the logo (1.4.5)
* Every ILIAS Installation has a title. (2.4.2)
* Colour is never used as the only way to convey information (1.4.1)
* We provide different ways to allow locating content: Search, trees, breadcrumb (2.4.5)
* In some games tilting your phone will make the car turn. We do not use shaking, tilting or the like to operate ILIAS. (2.5.4)
