# v3.16.0

## Summary

The v3.16.0 release includes features and fixes from 95 pull requests since the v3.15.1 release.  New features and improvements include:

* Add `ol.source.ImageArcGISRest` for ArcGIS REST image layer support (#3880)
* New `finishCondition` option for `ol.interaction.Draw` to control which action should finish a geometry when drawing (#5261)
* New filter API for `ol.format.WFS#writeGetFeature` for WFS queries with OGC filters (#5252)
* New `renderMode` option for `ol.layer.VectorTile` to balance between rendering performance and rendering quality (#5177)
* More flexibility for configuring attribution logos by allowing HTML elements (#5274)
* UTFGrid updates, now supporting Mapbox API v4 (#5329)
* New `condition` option for `ol.interaction.Modify` for better reliability when combining with other interactions (#5320)

In addition to these new features, the code base has been simplified and refactored in the process of removing the dependency on Closure Library and Compiler.

## Upgrade notes

#### Rendering change for tile sources

Previously, if you called `source.setUrl()` on a tile source, all currently rendered tiles would be cleared before new tiles were loaded and rendered.  This clearing of the map is undesirable if you are trying to smoothly update the tiles used by a source.  This behavior has now changed, and calling `source.setUrl()` (or `source.setUrls()`) will *not* clear currently rendered tiles before loading and rendering new tiles.  Instead, previously rendered tiles remain rendered until new tiles have loaded and can replace them.  If you want to achieve the old behavior (render a blank map before loading new tiles), you can call `source.refresh()` or you can replace the old source with a new one (using `layer.setSource()`).

#### Move of typedefs out of code and into separate file

This change should not affect the great majority of application developers, but it's possible there are edge cases when compiling application code together with the library which cause compiler errors or warnings. In this case, please raise a GitHub issue. `goog.require`s for typedefs should not be necessary.
Users compiling their code with the library should note that the following API `@typedef`s have been renamed; your code may need changing if you use these:
* `ol.format.WFS.FeatureCollectionMetadata` to `ol.WFSFeatureCollectionMetadata`
* `ol.format.WFS.TransactionResponse` to `ol.WFSTransactionResponse`

#### Removal of `opaque` option for `ol.source.VectorTile`

This option is no longer needed, so it was removed from the API.

#### XHR loading for `ol.source.TileUTFGrid`

The `ol.source.TileUTFGrid` now uses XMLHttpRequest to load UTFGrid tiles by default.  This works out of the box with the v4 Mapbox API.  To work with the v3 API, you must use the new `jsonp` option on the source.  See the examples below for detail.

```js
// To work with the v4 API
var v4source = new ol.source.TileUTFGrid({
  url: 'https://api.tiles.mapbox.com/v4/example.json?access_token=' + YOUR_KEY_HERE
});

// To work with the v3 API
var v3source = new ol.source.TileUTFGrid({
  jsonp: true, // <--- this is required for v3
  url: 'http://api.tiles.mapbox.com/v3/example.json'
});
```

## Full list of changes

* [#5377](https://github.com/openlayers/openlayers/pull/5377) - Fix link to jspdf.min.js in export-pdf example ([@fredj](https://github.com/fredj))
* [#5372](https://github.com/openlayers/openlayers/pull/5372) - Update jquery to version 2.2.4 🚀 ([@openlayers](https://github.com/openlayers))
* [#5364](https://github.com/openlayers/openlayers/pull/5364) - Make it so things don't flash so much when you change the tile source URL. ([@tschaub](https://github.com/tschaub))
* [#5368](https://github.com/openlayers/openlayers/pull/5368) - Move WFS typedefs to typedefs.js ([@probins](https://github.com/probins))
* [#5369](https://github.com/openlayers/openlayers/pull/5369) - format/igc: Remove duplicate regex exec() call ([@Turbo87](https://github.com/Turbo87))
* [#5363](https://github.com/openlayers/openlayers/pull/5363) - Convert all typedefs to CamelCase ([@probins](https://github.com/probins))
* [#5362](https://github.com/openlayers/openlayers/pull/5362) - Update vector-tile to version 1.2.1 🚀 ([@openlayers](https://github.com/openlayers))
* [#5352](https://github.com/openlayers/openlayers/pull/5352) - Add getResolutions() to ol.View ([@marlowp](https://github.com/marlowp))
* [#5359](https://github.com/openlayers/openlayers/pull/5359) - Move upgrade notes to correct place ([@probins](https://github.com/probins))
* [#5343](https://github.com/openlayers/openlayers/pull/5343) - Rename non-api sub-namespace typedefs ([@probins](https://github.com/probins))
* [#5361](https://github.com/openlayers/openlayers/pull/5361) - Fix url to maki icons ([@fredj](https://github.com/fredj))
* [#5358](https://github.com/openlayers/openlayers/pull/5358) - Handle multiple featureMember elements for different types (WFS format) ([@tsauerwein](https://github.com/tsauerwein))
* [#5355](https://github.com/openlayers/openlayers/pull/5355) - Fix navigation-controls example description ([@fredj](https://github.com/fredj))
* [#5353](https://github.com/openlayers/openlayers/pull/5353) - Add API definition to docs landing page ([@probins](https://github.com/probins))
* [#5356](https://github.com/openlayers/openlayers/pull/5356) - Update rbush to version 1.4.3 🚀 ([@openlayers](https://github.com/openlayers))
* [#5354](https://github.com/openlayers/openlayers/pull/5354) - Update eslint to version 2.10.2 🚀 ([@openlayers](https://github.com/openlayers))
* [#5347](https://github.com/openlayers/openlayers/pull/5347) - Update eslint to version 2.10.1 🚀 ([@openlayers](https://github.com/openlayers))
* [#5344](https://github.com/openlayers/openlayers/pull/5344) - Remove raster enum from test ([@probins](https://github.com/probins))
* [#5329](https://github.com/openlayers/openlayers/pull/5329) - UTFGrid updates. ([@tschaub](https://github.com/tschaub))
* [#5335](https://github.com/openlayers/openlayers/pull/5335) - Move typedefs to separate file ([@probins](https://github.com/probins))
* [#5332](https://github.com/openlayers/openlayers/pull/5332) - Warn when viewing an outdated example, and offer a redirect to latest ([@ahocevar](https://github.com/ahocevar))
* [#5342](https://github.com/openlayers/openlayers/pull/5342) - Fix incorrect source links ([@ahocevar](https://github.com/ahocevar))
* [#5339](https://github.com/openlayers/openlayers/pull/5339) - Use a div instead of alert for version warning ([@ahocevar](https://github.com/ahocevar))
* [#5320](https://github.com/openlayers/openlayers/pull/5320) - Add a 'condition' option to ol.interaction.Modify ([@fredj](https://github.com/fredj))
* [#5333](https://github.com/openlayers/openlayers/pull/5333) - Improve code readability with better comments ([@openlayers](https://github.com/openlayers))
* [#5330](https://github.com/openlayers/openlayers/pull/5330) - Fix source links, display version and warn about outdated docs ([@ahocevar](https://github.com/ahocevar))
* [#5324](https://github.com/openlayers/openlayers/pull/5324) - Remove unneeded goog.provides/requires for typedefs ([@probins](https://github.com/probins))
* [#5328](https://github.com/openlayers/openlayers/pull/5328) - Use Node 6 on Travis. ([@tschaub](https://github.com/tschaub))
* [#5313](https://github.com/openlayers/openlayers/pull/5313) - Rastersource framestate extent ([@ahocevar](https://github.com/ahocevar))
* [#5326](https://github.com/openlayers/openlayers/pull/5326) - Fix wording in tile-load-event example ([@tsauerwein](https://github.com/tsauerwein))
* [#5327](https://github.com/openlayers/openlayers/pull/5327) - Update closure-util to version 1.13.1 🚀 ([@openlayers](https://github.com/openlayers))
* [#5289](https://github.com/openlayers/openlayers/pull/5289) - Update fs-extra to version 0.30.0 🚀 ([@openlayers](https://github.com/openlayers))
* [#5319](https://github.com/openlayers/openlayers/pull/5319) - Remove outdated fixme from framestate.js. ([@probins](https://github.com/probins))
* [#5274](https://github.com/openlayers/openlayers/pull/5274) - Allow using elements in logo attribution options ([@samuellapointe](https://github.com/samuellapointe))
* [#5162](https://github.com/openlayers/openlayers/pull/5162) - Improve docs/examples for loadingstrategy ([@probins](https://github.com/probins))
* [#5314](https://github.com/openlayers/openlayers/pull/5314) - Update browserify to version 13.0.1 🚀 ([@openlayers](https://github.com/openlayers))
* [#5315](https://github.com/openlayers/openlayers/pull/5315) - Remove unused ol.TileCoordTransformType ([@probins](https://github.com/probins))
* [#5310](https://github.com/openlayers/openlayers/pull/5310) - Get raster sources working again. ([@tschaub](https://github.com/tschaub))
* [#5291](https://github.com/openlayers/openlayers/pull/5291) - Allow once listeners to dispatch events of same type ([@ahocevar](https://github.com/ahocevar))
* [#5309](https://github.com/openlayers/openlayers/pull/5309) - Update metalsmith-layouts to version 1.6.5 🚀 ([@openlayers](https://github.com/openlayers))
* [#5052](https://github.com/openlayers/openlayers/pull/5052) - Update fs-extra to version 0.26.7 🚀 ([@openlayers](https://github.com/openlayers))
* [#5306](https://github.com/openlayers/openlayers/pull/5306) - Make olx.view.FitOptions.padding optional ([@gberaudo](https://github.com/gberaudo))
* [#5302](https://github.com/openlayers/openlayers/pull/5302) - Remove use of goog.partial ([@fredj](https://github.com/fredj))
* [#5304](https://github.com/openlayers/openlayers/pull/5304) - Update sinon to version 1.17.4 🚀 ([@openlayers](https://github.com/openlayers))
* [#4644](https://github.com/openlayers/openlayers/pull/4644) - Remove check-requires script ([@fredj](https://github.com/fredj))
* [#5298](https://github.com/openlayers/openlayers/pull/5298) - Update eslint to version 2.9.0 🚀 ([@openlayers](https://github.com/openlayers))
* [#5296](https://github.com/openlayers/openlayers/pull/5296) - Document handling of KML MultiGeometries ([@probins](https://github.com/probins))
* [#5293](https://github.com/openlayers/openlayers/pull/5293) - Block removePoint while dragging ([@giohappy](https://github.com/giohappy))
* [#5285](https://github.com/openlayers/openlayers/pull/5285) - Add more tests for the scaleline control ([@marcjansen](https://github.com/marcjansen))
* [#5287](https://github.com/openlayers/openlayers/pull/5287) - Add and fix vectortile tests ([@ahocevar](https://github.com/ahocevar))
* [#5288](https://github.com/openlayers/openlayers/pull/5288) - Expose removeVertex_ as removePoint ([@giohappy](https://github.com/giohappy))
* [#5286](https://github.com/openlayers/openlayers/pull/5286) - Skip unnecessary render functions ([@ahocevar](https://github.com/ahocevar))
* [#5177](https://github.com/openlayers/openlayers/pull/5177) - Add render options for vector tile layers ([@ahocevar](https://github.com/ahocevar))
* [#5278](https://github.com/openlayers/openlayers/pull/5278) - Fix invalid generics type instantiation ([@fredj](https://github.com/fredj))
* [#5044](https://github.com/openlayers/openlayers/pull/5044) - Snap interaction now handle feature without geometry properly ([@fblackburn](https://github.com/fblackburn))
* [#5277](https://github.com/openlayers/openlayers/pull/5277) - Type cleanup ([@fredj](https://github.com/fredj))
* [#5275](https://github.com/openlayers/openlayers/pull/5275) - Fix feature-layer association on replaced selections ([@ahocevar](https://github.com/ahocevar))
* [#5252](https://github.com/openlayers/openlayers/pull/5252) - Add filter option to ol.format.WFS#writeGetFeature ([@tsauerwein](https://github.com/tsauerwein))
* [#5264](https://github.com/openlayers/openlayers/pull/5264) - Fix for close draw polygon error ([@matjos](https://github.com/matjos))
* [#5267](https://github.com/openlayers/openlayers/pull/5267) - Use ol.functions instead of goog.functions ([@ahocevar](https://github.com/ahocevar))
* [#5266](https://github.com/openlayers/openlayers/pull/5266) - Document ol.colorlike ([@ahocevar](https://github.com/ahocevar))
* [#5261](https://github.com/openlayers/openlayers/pull/5261) - add finishCondition to ol.interaction.Draw ([@giohappy](https://github.com/giohappy))
* [#5259](https://github.com/openlayers/openlayers/pull/5259) - Include squash commit merges in changelog ([@ahocevar](https://github.com/ahocevar))
* [#5257](https://github.com/openlayers/openlayers/pull/5257) - Add readFeatures and readProjection as MVT experimental API ([@bjornharrtell](https://github.com/bjornharrtell))
* [#3880](https://github.com/openlayers/openlayers/pull/3880) - Add ol.source.ImageArcGISRest ([Anna Lambrechtsen](https://github.com/search?q=Anna Lambrechtsen&type=Users))
* [#5239](https://github.com/openlayers/openlayers/pull/5239) - Update eslint to version 2.8.0 🚀 ([@openlayers](https://github.com/openlayers))
* [#5230](https://github.com/openlayers/openlayers/pull/5230) - Reuse frame state arrays ([@fredj](https://github.com/fredj))
* [#5213](https://github.com/openlayers/openlayers/pull/5213) - Remove unused ol.source.Source#setProjection function ([@fredj](https://github.com/fredj))
* [#5223](https://github.com/openlayers/openlayers/pull/5223) - Create tmpSize_ before calling calculateTileRanges_ ([@fredj](https://github.com/fredj))
* [#5225](https://github.com/openlayers/openlayers/pull/5225) - Remove unused ol.extent.transform2D function ([@fredj](https://github.com/fredj))
* [#5212](https://github.com/openlayers/openlayers/pull/5212) - KML: fix GeometryCollection write ([@probins](https://github.com/probins))
* [#5228](https://github.com/openlayers/openlayers/pull/5228) - Add 'layers' option to Translate interaction ([@adube](https://github.com/adube))
* [#5221](https://github.com/openlayers/openlayers/pull/5221) - Update jquery, bootstrap and proj4js in examples ([@fredj](https://github.com/fredj))
* [#5227](https://github.com/openlayers/openlayers/pull/5227) - Add a temporary ol.TileCoord in ol.renderer.canvas.TileLayer ([@fredj](https://github.com/fredj))
* [#5222](https://github.com/openlayers/openlayers/pull/5222) - Remove unused private variables in ol.renderer.canvas.Map ([@fredj](https://github.com/fredj))
* [#5220](https://github.com/openlayers/openlayers/pull/5220) - Externs cleanup ([@fredj](https://github.com/fredj))
* [#5224](https://github.com/openlayers/openlayers/pull/5224) - Fix jsdoc tags indentation ([@fredj](https://github.com/fredj))
* [#5218](https://github.com/openlayers/openlayers/pull/5218) - Add @api annotation to setConfig. ([@aisaacs](https://github.com/aisaacs))
* [#5215](https://github.com/openlayers/openlayers/pull/5215) - Add an optional feature filter to getClosestFeatureToCoordinate ([@fredj](https://github.com/fredj))
* [#5132](https://github.com/openlayers/openlayers/pull/5132) - Remove goog.string ([@nicholas-l](https://github.com/nicholas-l))
* [#5206](https://github.com/openlayers/openlayers/pull/5206) - Minor correction of StyleFunction docs ([@probins](https://github.com/probins))
* [#4932](https://github.com/openlayers/openlayers/pull/4932) - Remove undefined parameters to ol.format.WMSGetFeatureInfo#readFeatures_ ([@fredj](https://github.com/fredj))
* [#5207](https://github.com/openlayers/openlayers/pull/5207) - Update clean-css to version 3.4.12 🚀 ([@openlayers](https://github.com/openlayers))
* [#5201](https://github.com/openlayers/openlayers/pull/5201) - Small clarification for vector source loader docs ([@probins](https://github.com/probins))
* [#5200](https://github.com/openlayers/openlayers/pull/5200) - Fix typo in rotate control for css classList ([@bartvde](https://github.com/bartvde))
* [#5178](https://github.com/openlayers/openlayers/pull/5178) - Remove goog.global ([Nicholas Latham](https://github.com/search?q=Nicholas Latham&type=Users))
* [#5189](https://github.com/openlayers/openlayers/pull/5189) - Add rendering tests to ensure correct circle and polygon rendering ([Andreas Hocevar](https://github.com/search?q=Andreas Hocevar&type=Users))
* [#5183](https://github.com/openlayers/openlayers/pull/5183) - Update istanbul to version 0.4.3 🚀 ([@openlayers](https://github.com/openlayers))
* [#5187](https://github.com/openlayers/openlayers/pull/5187) - Remove goog.functions.and from ol.interaction.Modify ([@fredj](https://github.com/fredj))
* [#5176](https://github.com/openlayers/openlayers/pull/5176) - Update jquery to version 2.2.3 🚀 ([@openlayers](https://github.com/openlayers))
* [#5173](https://github.com/openlayers/openlayers/pull/5173) - Use ol.dom.createCanvasContext2D ([@fredj](https://github.com/fredj))
* [#5171](https://github.com/openlayers/openlayers/pull/5171) - Move olx.source.AttributionOption out of externs/olx.js ([@fredj](https://github.com/fredj))
* [#5170](https://github.com/openlayers/openlayers/pull/5170) - Update eslint to version 2.7.0 🚀 ([@openlayers](https://github.com/openlayers))
* [#5167](https://github.com/openlayers/openlayers/pull/5167) - Remove FastClick from mobile-full-screen example ([@fredj](https://github.com/fredj))
* [#5166](https://github.com/openlayers/openlayers/pull/5166) - Remove jquery dependency from measure example ([@fredj](https://github.com/fredj))
* [#5164](https://github.com/openlayers/openlayers/pull/5164) - Cartodb cleanup ([@fredj](https://github.com/fredj))
