# 4.2.0

## Summary

The v4.2.0 release includes features and fixes from 87 pull requests.

#### New `movestart` event on `ol.Map`

The map now has a `movestart` event, as countarpart to the already existing `moveend` event.

#### New `moveTolerance` option in `ol.Map`

Some touch devices do not play well with OpenLayers's way of detecting clicks. To overcome this, a new `moveTolerance` option was introduced, so users can override the 1 pixel threshold above which a touch-release sequence won't be considered a click any more.

#### Support for multiple layers in `ol.format.TopoJSON`

With the new `layerName` and `layers` options, applications can extract the layer as additional attribute for vector features from `ol.format.TopoJSON`. This can especially be useful for styling vector tile layers.

#### New `tileJSON` option for `ol.source.TileJSON`

Like `ol.source.TileUTFGrid`, `ol.source.TileJSON` now also has a `tileJSON` option to configue it with inline TileJSON instead of a TileJSON URL.

#### New `ol.format.filter.during` filter

Although OpenLayers has no support for WFS v2.0, we added `ol.format.filter.during` for the `During` temporal operator.

#### Improved vector tile rendering at non-native resolutions

The vector tile renderer now uses an internal tile grid for all resolutions to cache pre-rendered tiles, even if the tile source does not have tiles for the viewed resolution. This improves rendering quality and performance.

#### New `insertVertexCondition` for `ol.interaction.Modify`

Applications can now control whether a vertex will be inserted into the modified geometry. This makes it easier to modify custom geometries.

#### New `callback` option for `ol.View#fit()`

To allow applications to perform custom actions when an animation associated with `ol.View#fit()` is completed, that method now has a new `callback` option.

#### New `ol.View#getInteracting()` getter

Like `ol.View#getAnimating()` returns `true` during a view animation, `ol.View#getInteracting()` returns `true` while users are interacting with the view.

#### New `hasZ` option for `ol.format.WFS#writeTransaction()`

When the new `hasZ` option is set to `true`, 3D coordinates will be preserved and encoded when writing a WFS transaction.

#### New `wrapX` option for `ol.source.Stamen`

Like other tile sources, `ol.source.Stamen` now also has a `wrapX` option, which allows applications to turn off wrapping the world in x direction.

#### Label support for `ol.Graticule`

The `ol.Graticule` component has several new options to add and control the output of labels. To turn on labelling, configure `ol.Graticule` with `showLabels: true`. The new options to control label formatting are `lonLabelFormatter`, `latLabelFormatter`, `lonLabelPosition` and `latLabelPosition`.

#### Return values of two `ol.style.RegularShape` getters have changed

To provide a more consistent behaviour the following getters now return the same value that was given to constructor:

`ol.style.RegularShape#getPoints` does not return the double amount of points anymore if a radius2 is set.

`ol.style.RegularShape#getRadius2` will return `undefined` if no radius2 is set.

## Detailed changes

 * [#6912](https://github.com/openlayers/openlayers/pull/6912) - Use class instead of style for Translate cursor ([@ahocevar](https://github.com/ahocevar))
 * [#6858](https://github.com/openlayers/openlayers/pull/6858) - Webgl vector improvements ([@GaborFarkas](https://github.com/GaborFarkas))
 * [#6890](https://github.com/openlayers/openlayers/pull/6890) - Add a movestart event ([@ahocevar](https://github.com/ahocevar))
 * [#6910](https://github.com/openlayers/openlayers/pull/6910) - Avoid duplicates in Observables list ([@ahocevar](https://github.com/ahocevar))
 * [#6902](https://github.com/openlayers/openlayers/pull/6902) - Require minimum duration for kinetic animation ([@ahocevar](https://github.com/ahocevar))
 * [#6904](https://github.com/openlayers/openlayers/pull/6904) - chore(package): update sinon to version 2.3.4 ([@openlayers](https://github.com/openlayers))
 * [#6901](https://github.com/openlayers/openlayers/pull/6901) - Added release note for changed methods of ol.style.regularShape ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#6886](https://github.com/openlayers/openlayers/pull/6886) - Make ol.source.Cluster extensible ([@gberaudo](https://github.com/gberaudo))
 * [#6887](https://github.com/openlayers/openlayers/pull/6887) - Disable rotation for views with enableRotation: false ([@ahocevar](https://github.com/ahocevar))
 * [#6900](https://github.com/openlayers/openlayers/pull/6900) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6897](https://github.com/openlayers/openlayers/pull/6897) - ProjectionLike in proj.getPointResolution ([@probins](https://github.com/probins))
 * [#6888](https://github.com/openlayers/openlayers/pull/6888) - Add note about custom functions to getPointResolution ([@probins](https://github.com/probins))
 * [#6893](https://github.com/openlayers/openlayers/pull/6893) - Fix decimals options when writing features ([@tchandelle](https://github.com/tchandelle))
 * [#6759](https://github.com/openlayers/openlayers/pull/6759) - Regular shape points ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#6892](https://github.com/openlayers/openlayers/pull/6892) - Accept a ol.ProjectionLike instead of ol.proj.Projection ([@fredj](https://github.com/fredj))
 * [#6883](https://github.com/openlayers/openlayers/pull/6883) - Remove unused ol.pointer.EventSource#getMapping function ([@fredj](https://github.com/fredj))
 * [#6870](https://github.com/openlayers/openlayers/pull/6870) - Center map on proper earth, not one to the left ([@kannes](https://github.com/kannes))
 * [#6872](https://github.com/openlayers/openlayers/pull/6872) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6876](https://github.com/openlayers/openlayers/pull/6876) - Only test ol.interaction.DragAndDrop if FileReader is supported ([@fredj](https://github.com/fredj))
 * [#6874](https://github.com/openlayers/openlayers/pull/6874) - Remove unused var from ol.proj ([@probins](https://github.com/probins))
 * [#6875](https://github.com/openlayers/openlayers/pull/6875) - chore(package): update sinon to version 2.3.2 ([@openlayers](https://github.com/openlayers))
 * [#6867](https://github.com/openlayers/openlayers/pull/6867) - add getArea to api ([@cs09g](https://github.com/cs09g))
 * [#6863](https://github.com/openlayers/openlayers/pull/6863) - change size to optional ([@cs09g](https://github.com/cs09g))
 * [#6864](https://github.com/openlayers/openlayers/pull/6864) - fix(package): update closure-util to version 1.21.0 ([@openlayers](https://github.com/openlayers))
 * [#6834](https://github.com/openlayers/openlayers/pull/6834) - Move tolerance option ([@notnotse](https://github.com/notnotse))
 * [#6856](https://github.com/openlayers/openlayers/pull/6856) - Fix creation of new URL in readSharedStyle_ and readSharedStyleMap_ ([@oterral](https://github.com/oterral))
 * [#6852](https://github.com/openlayers/openlayers/pull/6852) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6851](https://github.com/openlayers/openlayers/pull/6851) - Register/unregister listeners in setActive ([@ahocevar](https://github.com/ahocevar))
 * [#6832](https://github.com/openlayers/openlayers/pull/6832) - Force state of error tiles when usInterimTilesOnError is false ([@oterral](https://github.com/oterral))
 * [#6849](https://github.com/openlayers/openlayers/pull/6849) - Create URL object only when we can ([@oterral](https://github.com/oterral))
 * [#6845](https://github.com/openlayers/openlayers/pull/6845) - Snap on circles ([@tchandelle](https://github.com/tchandelle))
 * [#6842](https://github.com/openlayers/openlayers/pull/6842) - add condition to check if active ([@cs09g](https://github.com/cs09g))
 * [#6844](https://github.com/openlayers/openlayers/pull/6844) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6841](https://github.com/openlayers/openlayers/pull/6841) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6839](https://github.com/openlayers/openlayers/pull/6839) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6838](https://github.com/openlayers/openlayers/pull/6838) - fix(package): update handlebars to version 4.0.10 ([@openlayers](https://github.com/openlayers))
 * [#6817](https://github.com/openlayers/openlayers/pull/6817) - Multiple layers in TopoJSON vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#6833](https://github.com/openlayers/openlayers/pull/6833) - Fix geojson-vt example for line and point geometries ([@oterral](https://github.com/oterral))
 * [#6829](https://github.com/openlayers/openlayers/pull/6829) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6819](https://github.com/openlayers/openlayers/pull/6819) - Adjust/fix API for working with vector tile features ([@ahocevar](https://github.com/ahocevar))
 * [#6818](https://github.com/openlayers/openlayers/pull/6818) - Add tileJSON option to ol.source.TileJSON ([@ahocevar](https://github.com/ahocevar))
 * [#6805](https://github.com/openlayers/openlayers/pull/6805) - Display country name on click select ([@fredj](https://github.com/fredj))
 * [#6813](https://github.com/openlayers/openlayers/pull/6813) - Prepend the version with a v ([@tschaub](https://github.com/tschaub))
 * [#6814](https://github.com/openlayers/openlayers/pull/6814) - Re-add ol.render.Feature#getGeometry() ([@ahocevar](https://github.com/ahocevar))
 * [#6812](https://github.com/openlayers/openlayers/pull/6812) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6786](https://github.com/openlayers/openlayers/pull/6786) - Add ol.format.filter.during ([@fredj](https://github.com/fredj))
 * [#6806](https://github.com/openlayers/openlayers/pull/6806) - Add note about features with the same id ([@drnextgis](https://github.com/drnextgis))
 * [#6802](https://github.com/openlayers/openlayers/pull/6802) - Remove unused setFeatures and getFormat methods ([@ahocevar](https://github.com/ahocevar))
 * [#6801](https://github.com/openlayers/openlayers/pull/6801) - Add getId method for ol.render.Feature ([@ahocevar](https://github.com/ahocevar))
 * [#6778](https://github.com/openlayers/openlayers/pull/6778) - Add a small tolerance when testing pointer event positions ([@fredj](https://github.com/fredj))
 * [#6796](https://github.com/openlayers/openlayers/pull/6796) - Re-add accidently dropped condition ([@ahocevar](https://github.com/ahocevar))
 * [#6798](https://github.com/openlayers/openlayers/pull/6798) - chore(package): update clean-css-cli to version 4.1.2 ([@openlayers](https://github.com/openlayers))
 * [#6795](https://github.com/openlayers/openlayers/pull/6795) - Fix ol.DrawGeometryFunctionType coordinates argument type ([@fredj](https://github.com/fredj))
 * [#6797](https://github.com/openlayers/openlayers/pull/6797) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6779](https://github.com/openlayers/openlayers/pull/6779) - Decouple source and rendered tile grid of vector tile sources ([@ahocevar](https://github.com/ahocevar))
 * [#6785](https://github.com/openlayers/openlayers/pull/6785) - Add insertVertexCondition to ol.interaction.Modify options ([@fredj](https://github.com/fredj))
 * [#6792](https://github.com/openlayers/openlayers/pull/6792) - Create intermediate canvas when resolutions have changed ([@ahocevar](https://github.com/ahocevar))
 * [#6790](https://github.com/openlayers/openlayers/pull/6790) - Update resemblejs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6784](https://github.com/openlayers/openlayers/pull/6784) - chore(package): update clean-css-cli to version 4.1.0 ([@openlayers](https://github.com/openlayers))
 * [#6556](https://github.com/openlayers/openlayers/pull/6556) - Reading kml xunits/yunits insetPixels ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#6775](https://github.com/openlayers/openlayers/pull/6775) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6774](https://github.com/openlayers/openlayers/pull/6774) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6770](https://github.com/openlayers/openlayers/pull/6770) - Enforce the "no missing requires" rule ([@tschaub](https://github.com/tschaub))
 * [#6772](https://github.com/openlayers/openlayers/pull/6772) - Remove html tag from shortdesc ([@fredj](https://github.com/fredj))
 * [#6769](https://github.com/openlayers/openlayers/pull/6769) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6757](https://github.com/openlayers/openlayers/pull/6757) - Fix crashing on creation of snap-interaction, if Circle is among the features to snap to. ([@hajjimurad](https://github.com/hajjimurad))
 * [#6766](https://github.com/openlayers/openlayers/pull/6766) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6765](https://github.com/openlayers/openlayers/pull/6765) - Add new callback function to view.FitOptions ([@fredj](https://github.com/fredj))
 * [#6764](https://github.com/openlayers/openlayers/pull/6764) - Added View#getInteracting() to the api ([@mblinsitu](https://github.com/mblinsitu))
 * [#6760](https://github.com/openlayers/openlayers/pull/6760) - Update handlebars to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6761](https://github.com/openlayers/openlayers/pull/6761) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6755](https://github.com/openlayers/openlayers/pull/6755) - Add missing goog.require ([@fredj](https://github.com/fredj))
 * [#6751](https://github.com/openlayers/openlayers/pull/6751) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6750](https://github.com/openlayers/openlayers/pull/6750) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6741](https://github.com/openlayers/openlayers/pull/6741) - Allow user selection in overlay container ([@fredj](https://github.com/fredj))
 * [#6744](https://github.com/openlayers/openlayers/pull/6744) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6737](https://github.com/openlayers/openlayers/pull/6737) - Graticule labels ([@ahocevar](https://github.com/ahocevar))
 * [#6740](https://github.com/openlayers/openlayers/pull/6740) - Fix spelling ([@fredj](https://github.com/fredj))
 * [#6730](https://github.com/openlayers/openlayers/pull/6730) - Update metalsmith-layouts to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6732](https://github.com/openlayers/openlayers/pull/6732) - Use firefox < 53 in travis ([@fredj](https://github.com/fredj))
 * [#6677](https://github.com/openlayers/openlayers/pull/6677) - Add an option to writeTransaction to support 3D geometries ([@Jenselme](https://github.com/Jenselme))
 * [#6524](https://github.com/openlayers/openlayers/pull/6524) - Don't append feature prefix twice in WFS requests ([@Jenselme](https://github.com/Jenselme))
 * [#6727](https://github.com/openlayers/openlayers/pull/6727) - Add default value in doc for the hitTolerance option ([@fredj](https://github.com/fredj))
 * [#6724](https://github.com/openlayers/openlayers/pull/6724) - Add wrapX option to Stamen source ([@fredj](https://github.com/fredj))
 * [#6728](https://github.com/openlayers/openlayers/pull/6728) - Fix tissot examples docs ([@fredj](https://github.com/fredj))
 * [#6725](https://github.com/openlayers/openlayers/pull/6725) - Update dependencies to enable Greenkeeper 🌴 ([@openlayers](https://github.com/openlayers))
 * [#6711](https://github.com/openlayers/openlayers/pull/6711) - Correct path to cleancss ([@tschaub](https://github.com/tschaub))
