# v4.6.0

### Summary

The 4.6 release includes enhancements and fixes from 30 or so pull requests.  Headlining this release, vector layers got new `textBackgroundFill`, `textBackgroundStroke` and `padding` options that can be used to render background boxes for text. `ol.source.ImageVector` is now deprecated and replaced by a more convenient way to render vectors as images: by simply setting `renderMode: 'image'` on the vector layer.

Please note that if you are using `closure-util` to build your OpenLayers based application, it is time to migrate to using the [`ol` package](https://www.npmjs.com/package/ol) and a module bundler like webpack.  OpenLayers has not had a dependency on the Closure Library since the [3.19 release](https://github.com/openlayers/openlayers/releases/tag/v3.19.0); and with the 5.0 release we will be moving completely away from `goog.require` and `goog.provide`, dropping support for `closure-util`, and going with ES modules for our sources.

See the [wiki](https://github.com/openlayers/openlayers/wiki/OpenLayers-v5.x) about upcoming changes in 5.0 and tips on how to upgrade.  We likely won't have another 4.x release before the 5.0 release.  If you're interested in continuing to get feature enhancements in future releases, migrating to the `ol` package now will make the transition easier.


### Upgrade notes

#### Renamed `exceedLength` option of `ol.style.Text` to `overflow`

To update your applications, simply replace `exceedLength` with `overflow`.

#### Deprecation of `ol.source.ImageVector`

Rendering vector sources as image is now directly supported by `ol.layer.Vector` with the new `renderMode: 'image'` configuration option. Change code like this:

```js
new ol.layer.Image({
  source: new ol.source.ImageVector({
    style: myStyle,
    source: new ol.source.Vector({
      url: 'my/data.json',
      format: new ol.format.GeoJSON()
    })
  })
});
```
to:

```js
new ol.layer.Vector({
  renderMode: 'image',
  style: myStyle,
  source: new ol.source.Vector({
    url: 'my/data.json',
    format: new ol.format.GeoJSON()
  })
});
```


## Detailed changes

See below for the full list of changes.

 * [#7538](https://github.com/openlayers/openlayers/pull/7538) - removeFromLoadedExtents to remove extents that failed to load ([@ahocevar](https://github.com/ahocevar))
 * [#7537](https://github.com/openlayers/openlayers/pull/7537) - Fix Draw.removeLastPoint exception when no points to remove ([@walkermatt](https://github.com/walkermatt))
 * [#7461](https://github.com/openlayers/openlayers/pull/7461) - Use the matrixSet projection by default ([@oterral](https://github.com/oterral))
 * [#5883](https://github.com/openlayers/openlayers/pull/5883) - Fixes setUrl() for WMTS sources (ol.source.WMTS) ([@bylexus](https://github.com/bylexus))
 * [#7531](https://github.com/openlayers/openlayers/pull/7531) - Update the ol package readme ([@ahocevar](https://github.com/ahocevar))
 * [#7372](https://github.com/openlayers/openlayers/pull/7372) - Add method to set max cache size in ol.style.IconImageCache ([@notnotse](https://github.com/notnotse))
 * [#7530](https://github.com/openlayers/openlayers/pull/7530) - Check forward/back 1 world if wrapping ([@raiyni](https://github.com/raiyni))
 * [#7526](https://github.com/openlayers/openlayers/pull/7526) - Allow clicks to be stopped while drawing ([@tschaub](https://github.com/tschaub))
 * [#7524](https://github.com/openlayers/openlayers/pull/7524) - Snap view center to pixel ([@ahocevar](https://github.com/ahocevar))
 * [#7521](https://github.com/openlayers/openlayers/pull/7521) - fix setMinZoom/setMaxZoom ([@cs09g](https://github.com/cs09g))
 * [#7519](https://github.com/openlayers/openlayers/pull/7519) - Reuse declutter tree for hit detection ([@ahocevar](https://github.com/ahocevar))
 * [#7499](https://github.com/openlayers/openlayers/pull/7499) - Remove attributions from olx.FrameState instances ([@openlayers](https://github.com/openlayers))
 * [#7501](https://github.com/openlayers/openlayers/pull/7501) - Option to render vector layers as images ([@ahocevar](https://github.com/ahocevar))
 * [#7516](https://github.com/openlayers/openlayers/pull/7516) - Deprecate exceedLength and replace with overflow ([@ahocevar](https://github.com/ahocevar))
 * [#7510](https://github.com/openlayers/openlayers/pull/7510) - Do not fade the states layer ([@ahocevar](https://github.com/ahocevar))
 * [#7513](https://github.com/openlayers/openlayers/pull/7513) - Make strokeKey safer ([@ahocevar](https://github.com/ahocevar))
 * [#7514](https://github.com/openlayers/openlayers/pull/7514) - Prune the label cache less aggressively ([@ahocevar](https://github.com/ahocevar))
 * [#7505](https://github.com/openlayers/openlayers/pull/7505) - Remove ol.DeviceOrientation link from API index ([@fredj](https://github.com/fredj))
 * [#7497](https://github.com/openlayers/openlayers/pull/7497) - Use getGeometry ([@nicholas-l](https://github.com/nicholas-l))
 * [#7495](https://github.com/openlayers/openlayers/pull/7495) - Remove layer renderers when viewport is removed ([@ahocevar](https://github.com/ahocevar))
 * [#7492](https://github.com/openlayers/openlayers/pull/7492) - Remove unneeded type cast from examples ([@fredj](https://github.com/fredj))
 * [#7489](https://github.com/openlayers/openlayers/pull/7489) - Allow string to be passed as ol.interaction.Draw type ([@fredj](https://github.com/fredj))
 * [#7445](https://github.com/openlayers/openlayers/pull/7445) - Load css rules from full-screen.css in examples ([@fredj](https://github.com/fredj))
 * [#7481](https://github.com/openlayers/openlayers/pull/7481) - Make zoom to extent control extensible ([@gberaudo](https://github.com/gberaudo))
 * [#7477](https://github.com/openlayers/openlayers/pull/7477) - Make text states available for replay time ([@ahocevar](https://github.com/ahocevar))
 * [#7482](https://github.com/openlayers/openlayers/pull/7482) - Reset rotation after rendering ([@ahocevar](https://github.com/ahocevar))
 * [#7480](https://github.com/openlayers/openlayers/pull/7480) - Create a new image when loading tile after an error ([@ahocevar](https://github.com/ahocevar))
 * [#7476](https://github.com/openlayers/openlayers/pull/7476) - Reset text measurements when available fonts change ([@ahocevar](https://github.com/ahocevar))
 * [#7454](https://github.com/openlayers/openlayers/pull/7454) - Add text background rendering and text padding ([@ahocevar](https://github.com/ahocevar))
 * [#7468](https://github.com/openlayers/openlayers/pull/7468) - Add new API-key for HERE example ([@chrismayer](https://github.com/chrismayer))
 * [#7465](https://github.com/openlayers/openlayers/pull/7465) - Export ol.proj.Projection#getAxisOrientation function ([@fredj](https://github.com/fredj))
 * [#7462](https://github.com/openlayers/openlayers/pull/7462) - Respect metersPerUnit in ScaleLine control ([@ahocevar](https://github.com/ahocevar))


Additionally a number of updates where made to our dependencies:
 * [#7536](https://github.com/openlayers/openlayers/pull/7536) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7533](https://github.com/openlayers/openlayers/pull/7533) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7527](https://github.com/openlayers/openlayers/pull/7527) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7511](https://github.com/openlayers/openlayers/pull/7511) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7512](https://github.com/openlayers/openlayers/pull/7512) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7484](https://github.com/openlayers/openlayers/pull/7484) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
